/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.gmf.internal.bridge.naming.ClassGenNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.DefaultGenNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.DesignGenNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.GenNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.gen.GenNamingMediatorImpl;
import org.eclipse.gmf.internal.common.IncrementalNamesDispenser;
import org.eclipse.gmf.tests.ConfiguredTestCase;
import org.eclipse.jdt.core.JavaConventions;

public class NamingStrategyTest
extends ConfiguredTestCase {
    private static final boolean STRICT_CHECK = true;

    public NamingStrategyTest(String name) {
        super(name);
    }

    public void testUniqueValueDispenser() {
        IncrementalNamesDispenser d = new IncrementalNamesDispenser();
        String semanticPart = "Rocket";
        String suffixPart = "Node";
        String name1 = d.get(semanticPart, suffixPart);
        String name2 = d.get(semanticPart, suffixPart);
        NamingStrategyTest.assertFalse((String)"Names are not unique", (boolean)name1.equals(name2));
    }

    public void testDefaultEPNamingStrategy() {
        this.doTest(new GenNamingMediatorImpl().getEditPart());
    }

    public void testPrefixNameStrategy() {
        DefaultGenNamingStrategy pns = new DefaultGenNamingStrategy(null, null, null, null);
        pns = new DesignGenNamingStrategy(null, null, (GenNamingStrategy)pns, null);
        pns = new ClassGenNamingStrategy(null, null, (GenNamingStrategy)pns, null);
        this.doTest((GenNamingStrategy)pns);
    }

    private void doTest(GenNamingStrategy strategy) {
        String diagramName = strategy.get(this.getSetup().getGenModel().getGenDiagram());
        String nodeName = strategy.get(this.getSetup().getGenModel().getNodeA());
        String link1Name = strategy.get(this.getSetup().getGenModel().getLinkC());
        String link2Name = strategy.get(this.getSetup().getGenModel().getLinkD());
        this.assertStatus("Invalid Java class name '" + diagramName + " for diagram", JavaConventions.validateJavaTypeName((String)diagramName, (String)"1.4", (String)"1.4"));
        this.assertStatus("Invalid Java class name '" + nodeName + " for node", JavaConventions.validateJavaTypeName((String)nodeName, (String)"1.4", (String)"1.4"));
        this.assertStatus("Invalid Java class name '" + link1Name + " for link", JavaConventions.validateJavaTypeName((String)link1Name, (String)"1.4", (String)"1.4"));
        this.assertStatus("Invalid Java class name '" + link2Name + " for link", JavaConventions.validateJavaTypeName((String)link2Name, (String)"1.4", (String)"1.4"));
    }

    private void assertStatus(String message, IStatus status) {
        NamingStrategyTest.assertTrue((String)message, (boolean)status.isOK());
    }
}

