/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.common;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.m2m.atl.common.ATLLogFormatter;

public class ATLLogger {
    public static final String LOGGER_ID = "org.eclipse.m2m.atl";
    public static final Level LOGLEVEL = Level.INFO;
    protected static Logger logger;

    protected ATLLogger() {
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger(LOGGER_ID);
            logger.setLevel(LOGLEVEL);
            logger.setUseParentHandlers(false);
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(ATLLogFormatter.INSTANCE);
            handler.setLevel(LOGLEVEL);
            logger.addHandler(handler);
        }
        return logger;
    }

    public static void log(Level level, String msg, Throwable thrown) {
        ATLLogger.getLogger().log(level, msg, thrown);
    }

    public static void fine(String msg) {
        ATLLogger.log(Level.FINE, msg, null);
    }

    public static void info(String msg) {
        ATLLogger.log(Level.INFO, msg, null);
    }

    public static void warning(String msg) {
        ATLLogger.log(Level.WARNING, msg, null);
    }

    public static void severe(String msg) {
        ATLLogger.log(Level.SEVERE, msg, null);
    }
}

