/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.ui;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandBuilder;
import org.eclipse.xtend.typesystem.xsd.builder.XSDManager;
import org.eclipse.xtend.typesystem.xsd.ui.XSDMetamodelStore;
import org.eclipse.xtend.typesystem.xsd.ui.XSDToolsPlugin;

public class XSDBuilderConfigurator {
    private PreferenceChangeListener listener = new PreferenceChangeListener();

    private void addBuilder(IProject project) {
        try {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            int idx = commands.length;
            int i = 0;
            while (i < commands.length) {
                String n = commands[i].getBuilderName();
                if (n.equals("org.eclipse.xtend.typesystem.xsd.ui.xsdBuilder")) {
                    return;
                }
                if (n.equals(XtendXpandBuilder.getBUILDER_ID())) {
                    idx = i;
                }
                ++i;
            }
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, idx);
            System.arraycopy(commands, idx, newCommands, idx + 1, commands.length - idx);
            ICommand command = desc.newCommand();
            command.setBuilderName("org.eclipse.xtend.typesystem.xsd.ui.xsdBuilder");
            newCommands[idx] = command;
            desc.setBuildSpec(newCommands);
            project.setDescription(desc, null);
            XSDToolsPlugin.traceLog("Added XSD Builder to Project " + project.getName());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private void configureAllBuilders() {
        IProject[] projects;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            if (proj.isOpen()) {
                if (XSDToolsPlugin.isXSDProject(proj)) {
                    this.addBuilder(proj);
                } else {
                    this.removeBuilder(proj);
                }
            }
            ++n2;
        }
    }

    private void removeBuilder(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals("org.eclipse.xtend.typesystem.xsd.ui.xsdBuilder")) {
                    ICommand[] newCommands = new ICommand[commands.length - 1];
                    System.arraycopy(commands, 0, newCommands, 0, i);
                    System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                    description.setBuildSpec(newCommands);
                    project.setDescription(description, null);
                    XSDToolsPlugin.traceLog("Removed XSD Builder from Project " + project.getName());
                    return;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        this.configureAllBuilders();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener, 8);
    }

    public void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.listener);
    }

    private class PreferenceChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private PreferenceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            if (res.getProject() != null && !res.getProject().isAccessible()) {
                XSDMetamodelStore s = XSDToolsPlugin.getDefault().getXSDStore();
                XSDManager m = s.getXSDManager(res.getProject());
                if (m != null) {
                    m.clear();
                }
                return false;
            }
            if (res.isAccessible() && ".settings".equals(res.getName())) {
                IProject proj = res.getProject();
                if (XSDToolsPlugin.isXSDProject(proj)) {
                    XSDBuilderConfigurator.this.addBuilder(proj);
                } else {
                    XSDBuilderConfigurator.this.removeBuilder(proj);
                }
            }
            return true;
        }
    }
}

