/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.analysis;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.build.analysis.AbstractRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.ActionAssignmentAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.AssignmentAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.DataTypeRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.DirectAssignmentAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.IdiomGrammarMatch;
import org.eclipse.ocl.examples.xtext.build.analysis.IdiomSerializationMatch;
import org.eclipse.ocl.examples.xtext.build.analysis.LocatorHelper;
import org.eclipse.ocl.examples.xtext.build.analysis.ParserRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.SerializationRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.TerminalRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationNode;
import org.eclipse.ocl.examples.xtext.idioms.CustomSegment;
import org.eclipse.ocl.examples.xtext.idioms.HalfNewLineSegment;
import org.eclipse.ocl.examples.xtext.idioms.Idiom;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsImport;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsModel;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsPackage;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsUtils;
import org.eclipse.ocl.examples.xtext.idioms.NewLineSegment;
import org.eclipse.ocl.examples.xtext.idioms.NoSpaceSegment;
import org.eclipse.ocl.examples.xtext.idioms.PopSegment;
import org.eclipse.ocl.examples.xtext.idioms.PostCommentSegment;
import org.eclipse.ocl.examples.xtext.idioms.PreCommentSegment;
import org.eclipse.ocl.examples.xtext.idioms.PushSegment;
import org.eclipse.ocl.examples.xtext.idioms.ReferredSegment;
import org.eclipse.ocl.examples.xtext.idioms.Segment;
import org.eclipse.ocl.examples.xtext.idioms.SegmentDeclaration;
import org.eclipse.ocl.examples.xtext.idioms.SoftNewLineSegment;
import org.eclipse.ocl.examples.xtext.idioms.SoftSpaceSegment;
import org.eclipse.ocl.examples.xtext.idioms.SubIdiom;
import org.eclipse.ocl.examples.xtext.idioms.ValueSegment;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.EClassValue;
import org.eclipse.ocl.examples.xtext.serializer.EnumerationValue;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleVector;
import org.eclipse.ocl.examples.xtext.serializer.Indexed;
import org.eclipse.ocl.examples.xtext.serializer.ParserRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRule;
import org.eclipse.ocl.examples.xtext.serializer.SerializationSegment;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.ocl.examples.xtext.serializer.TreeIterable;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.service.GrammarProvider;

public class GrammarAnalysis {
    @Inject
    private @NonNull GrammarProvider grammarProvider;
    @Inject
    private @Nullable Provider<ResourceSet> resourceSetProvider;
    private @Nullable Grammar grammar = null;
    private final @NonNull List<@NonNull AbstractRuleAnalysis> ruleAnalyses = new ArrayList<AbstractRuleAnalysis>();
    private final @NonNull Map<@NonNull AbstractRule, @NonNull AbstractRuleAnalysis> rule2ruleAnalysis = new HashMap<AbstractRule, AbstractRuleAnalysis>();
    private final @NonNull Map<@NonNull AbstractElement, @NonNull AssignmentAnalysis> assignment2assignmentAnalysis = new HashMap<AbstractElement, AssignmentAnalysis>();
    private final @NonNull Map<@NonNull EReference, @NonNull List<@NonNull AssignmentAnalysis>> containment2assignmentAnalyses = new HashMap<EReference, List<AssignmentAnalysis>>();
    private @Nullable Map<@NonNull EClass, @NonNull List<@NonNull ParserRuleAnalysis>> eClass2ruleAnalyses = null;
    private @Nullable Map<@NonNull EAttribute, @NonNull Set<@NonNull EnumerationValue>> eAttribute2enumerationValues = null;
    private final @NonNull Map<@NonNull String, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EnumerationValue.EnumerationValueSingle> value2enumerationValue = new HashMap<String, EnumerationValue.EnumerationValueSingle>();
    private final @NonNull Map<@NonNull List<@NonNull String>, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EnumerationValue.EnumerationValueMultiple> values2enumerationValue = new HashMap<List<String>, EnumerationValue.EnumerationValueMultiple>();
    private @Nullable List<@NonNull EClassValue> sortedProducedEClassValues = null;
    private @Nullable Map<@NonNull SerializationRule, @NonNull SerializationRuleAnalysis> serializationRule2aserializationRuleAnalysis = null;
    private @NonNull Map<@NonNull Segment, @NonNull SerializationSegment> segment2serializationSegment = new HashMap<Segment, SerializationSegment>();
    private final @NonNull Map<@NonNull EClass, @NonNull EClassValue> eClass2eClassValue = new HashMap<EClass, EClassValue>();
    private @Nullable Map<@NonNull String, @NonNull String> multipleLineCommentCharacterRanges = null;
    private @Nullable List<@NonNull String> singleLineCommentKeywords = null;
    private @Nullable GrammarRuleVector leafGrammarRulesVector = null;

    public GrammarAnalysis() {
        this.grammar = null;
    }

    public GrammarAnalysis(@NonNull Grammar grammar) {
        this.grammar = grammar;
    }

    public void addAssignmentAnalysis(@NonNull AssignmentAnalysis assignmentAnalysis) {
        AssignmentAnalysis old = (AssignmentAnalysis)SerializationUtils.maybeNull((Object)this.assignment2assignmentAnalysis.put(assignmentAnalysis.getActionOrAssignment(), assignmentAnalysis));
        assert (old == null);
    }

    public void addContainment(@NonNull AssignmentAnalysis assignmentAnalysis, @NonNull EReference eReference) {
        ArrayList<@NonNull AssignmentAnalysis> assignmentAnalyses = (ArrayList<AssignmentAnalysis>)SerializationUtils.maybeNull(this.containment2assignmentAnalyses.get(eReference));
        if (assignmentAnalyses == null) {
            assignmentAnalyses = new ArrayList<AssignmentAnalysis>();
            this.containment2assignmentAnalyses.put(eReference, assignmentAnalyses);
        }
        assignmentAnalyses.add(assignmentAnalysis);
    }

    protected void addEClassValue(@NonNull EClassValue eClassValue) {
        assert (eClassValue != null);
        EClassValue old = (EClassValue)SerializationUtils.maybeNull((Object)this.eClass2eClassValue.put(eClassValue.getEClass(), eClassValue));
        assert (old == null);
    }

    public void addEnumeration(@NonNull EAttribute eAttribute, @NonNull EnumerationValue enumerationValue) {
        HashSet<EnumerationValue> enumerationValues;
        Map<@NonNull EAttribute, @NonNull Set<@NonNull EnumerationValue>> eAttribute2enumerationValues2 = this.eAttribute2enumerationValues;
        if (eAttribute2enumerationValues2 == null) {
            this.eAttribute2enumerationValues = eAttribute2enumerationValues2 = new HashMap<EAttribute, Set<EnumerationValue>>();
        }
        if ((enumerationValues = (HashSet<EnumerationValue>)SerializationUtils.maybeNull(eAttribute2enumerationValues2.get(eAttribute))) == null) {
            enumerationValues = new HashSet<EnumerationValue>();
            eAttribute2enumerationValues2.put(eAttribute, enumerationValues);
        }
        enumerationValues.add(enumerationValue);
    }

    public void analyze() {
        HashMap<@NonNull AbstractRule, @NonNull List<@NonNull RuleCall>> rule2ruleCalls = new HashMap<AbstractRule, List<RuleCall>>();
        Map<@NonNull String, @NonNull List<@NonNull AbstractRule>> ruleName2rules = this.analyzeRuleNames(rule2ruleCalls);
        this.createRuleAnalyses(ruleName2rules, rule2ruleCalls);
        ArrayList<@NonNull ParserRuleAnalysis> parserRuleAnalyses = new ArrayList<ParserRuleAnalysis>(this.ruleAnalyses.size());
        ArrayList<@NonNull TerminalRuleAnalysis> terminalRuleAnalyses = new ArrayList<TerminalRuleAnalysis>();
        for (AbstractRuleAnalysis abstractRuleAnalysis : this.ruleAnalyses) {
            if (abstractRuleAnalysis instanceof ParserRuleAnalysis) {
                parserRuleAnalyses.add((ParserRuleAnalysis)abstractRuleAnalysis);
                continue;
            }
            if (!(abstractRuleAnalysis instanceof TerminalRuleAnalysis)) continue;
            terminalRuleAnalyses.add((TerminalRuleAnalysis)abstractRuleAnalysis);
        }
        Collections.sort(parserRuleAnalyses, AbstractRuleAnalysis.QualifiedNameableComparator.INSTANCE);
        for (ParserRuleAnalysis ruleAnalysis : parserRuleAnalyses) {
            ruleAnalysis.analyzeActionsAndAssignments();
        }
        for (ParserRuleAnalysis ruleAnalysis : parserRuleAnalyses) {
            ruleAnalysis.getSuperRuleAnalysisClosure();
        }
        for (AssignmentAnalysis assignmentAnalysis : this.assignment2assignmentAnalysis.values()) {
            assignmentAnalysis.analyzeContainmentAndTargets();
        }
        for (ParserRuleAnalysis parserRuleAnalysis : parserRuleAnalyses) {
            parserRuleAnalysis.getSerializationRuleAnalyses();
        }
        for (ParserRuleAnalysis parserRuleAnalysis : parserRuleAnalyses) {
            parserRuleAnalysis.analyzeMatches();
        }
        this.eClass2ruleAnalyses = this.analyzeProductions(parserRuleAnalyses);
        this.analyzeSerializations(parserRuleAnalyses);
    }

    protected void analyzeHiddenRules(@NonNull Grammar grammar) {
        for (AbstractRule hiddenRule : grammar.getHiddenTokens()) {
            AbstractElement firstElement;
            EList elements;
            int size;
            assert (hiddenRule != null);
            AbstractElement alternatives = hiddenRule.getAlternatives();
            if (!(alternatives instanceof Group) || (size = (elements = ((Group)alternatives).getElements()).size()) <= 1 || !((firstElement = (AbstractElement)elements.get(0)) instanceof Keyword)) continue;
            if (size == 2) {
                AbstractElement lastElement = (AbstractElement)elements.get(1);
                if (!(lastElement instanceof UntilToken)) continue;
                AbstractElement terminal = ((UntilToken)lastElement).getTerminal();
                if (size != 2 || !(terminal instanceof Keyword)) continue;
                Map<@NonNull String, @NonNull String> multipleLineCommentCharacterRanges2 = this.multipleLineCommentCharacterRanges;
                if (multipleLineCommentCharacterRanges2 == null) {
                    multipleLineCommentCharacterRanges2 = this.multipleLineCommentCharacterRanges = new HashMap<String, String>();
                }
                multipleLineCommentCharacterRanges2.put((String)SerializationUtils.nonNullState((Object)((Keyword)firstElement).getValue()), (String)SerializationUtils.nonNullState((Object)((Keyword)terminal).getValue()));
                continue;
            }
            List<@NonNull String> singleLineCommentKeywords2 = this.singleLineCommentKeywords;
            if (singleLineCommentKeywords2 == null) {
                this.singleLineCommentKeywords = singleLineCommentKeywords2 = new ArrayList<String>();
            }
            singleLineCommentKeywords2.add((String)SerializationUtils.nonNullState((Object)((Keyword)firstElement).getValue()));
        }
    }

    protected @NonNull Map<@NonNull EClass, @NonNull List<@NonNull ParserRuleAnalysis>> analyzeProductions(@NonNull Iterable<@NonNull ParserRuleAnalysis> ruleAnalyses) {
        HashMap<@NonNull EClass, @NonNull List<@NonNull ParserRuleAnalysis>> eClass2parserRules = new HashMap<EClass, List<ParserRuleAnalysis>>();
        for (ParserRuleAnalysis ruleAnalysis : ruleAnalyses) {
            for (SerializationRuleAnalysis serializationRuleAnalysis : ruleAnalysis.getSerializationRuleAnalyses()) {
                EClass eClass = serializationRuleAnalysis.getProducedEClass();
                ArrayList<@NonNull ParserRuleAnalysis> parserRuleAnalyses = (ArrayList<ParserRuleAnalysis>)SerializationUtils.maybeNull((Object)((List)eClass2parserRules.get(eClass)));
                if (parserRuleAnalyses == null) {
                    parserRuleAnalyses = new ArrayList<ParserRuleAnalysis>();
                    eClass2parserRules.put(eClass, parserRuleAnalyses);
                }
                parserRuleAnalyses.add(ruleAnalysis);
            }
        }
        return eClass2parserRules;
    }

    protected @NonNull Map<@NonNull String, @NonNull List<@NonNull AbstractRule>> analyzeRuleNames(@NonNull Map<@NonNull AbstractRule, @NonNull List<@NonNull RuleCall>> rule2ruleCalls) {
        HashMap<@NonNull String, @NonNull List<@NonNull AbstractRule>> ruleName2rules = new HashMap<String, List<AbstractRule>>();
        ArrayList<@NonNull Grammar> grammars = new ArrayList<Grammar>();
        grammars.add(this.getGrammar());
        int i = 0;
        while (i < grammars.size()) {
            @NonNull Grammar grammar = (Grammar)SerializationUtils.nonNullState((Object)((Grammar)grammars.get(i)));
            this.analyzeHiddenRules(grammar);
            for (EObject eObject : new TreeIterable((EObject)grammar, true)) {
                if (eObject instanceof Grammar) {
                    for (Grammar usedGrammar : ((Grammar)eObject).getUsedGrammars()) {
                        if (usedGrammar == null || grammars.contains(usedGrammar)) continue;
                        grammars.add(usedGrammar);
                    }
                    continue;
                }
                if (eObject instanceof AbstractRule) {
                    AbstractRule abstractRule = (AbstractRule)eObject;
                    String ruleName = SerializationUtils.getName((AbstractRule)abstractRule);
                    ArrayList<@NonNull AbstractRule> rules = (ArrayList<AbstractRule>)SerializationUtils.maybeNull((Object)((List)ruleName2rules.get(ruleName)));
                    if (rules == null) {
                        rules = new ArrayList<AbstractRule>();
                        ruleName2rules.put(ruleName, rules);
                    }
                    rules.add(abstractRule);
                    continue;
                }
                if (!(eObject instanceof RuleCall)) continue;
                RuleCall ruleCall = (RuleCall)eObject;
                AbstractRule rule = SerializationUtils.getRule((RuleCall)ruleCall);
                ArrayList<@NonNull RuleCall> ruleCalls = (ArrayList<RuleCall>)SerializationUtils.maybeNull(rule2ruleCalls.get(rule));
                if (ruleCalls == null) {
                    ruleCalls = new ArrayList<RuleCall>();
                    rule2ruleCalls.put(rule, ruleCalls);
                }
                ruleCalls.add(ruleCall);
            }
            ++i;
        }
        return ruleName2rules;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void analyzeSerializations(@NonNull Iterable<@NonNull ParserRuleAnalysis> ruleAnalyses) {
        Map<@NonNull SerializationRule, @NonNull SerializationRuleAnalysis> serializationRule2aserializationRuleAnalysis2 = this.serializationRule2aserializationRuleAnalysis;
        assert (serializationRule2aserializationRuleAnalysis2 == null);
        this.serializationRule2aserializationRuleAnalysis = serializationRule2aserializationRuleAnalysis2 = new HashMap<SerializationRule, SerializationRuleAnalysis>();
        HashMap<@NonNull EClass, @NonNull ArrayList<@NonNull E>> eClass2serializationRuleList = new HashMap();
        for (ParserRuleAnalysis parserRuleAnalysis : ruleAnalyses) {
            for (SerializationRuleAnalysis serializationRuleAnalysis : parserRuleAnalysis.getSerializationRuleAnalyses()) {
                EClass eClass = serializationRuleAnalysis.getProducedEClass();
                ArrayList<@NonNull SerializationRuleAnalysis> serializationRuleAnalyses = (ArrayList<SerializationRuleAnalysis>)SerializationUtils.maybeNull((Object)((List)eClass2serializationRuleList.get(eClass)));
                if (serializationRuleAnalyses == null) {
                    serializationRuleAnalyses = new ArrayList<SerializationRuleAnalysis>();
                    eClass2serializationRuleList.put(eClass, serializationRuleAnalyses);
                }
                if (serializationRuleAnalyses.contains(serializationRuleAnalysis)) continue;
                serializationRuleAnalyses.add(serializationRuleAnalysis);
            }
        }
        for (Map.Entry entry : eClass2serializationRuleList.entrySet()) {
            EClass eClass = (EClass)SerializationUtils.nonNullState((Object)((EClass)entry.getKey()));
            @NonNull List serializationRuleAnalyses = (List)SerializationUtils.nonNullState((Object)((List)entry.getValue()));
            Map<@NonNull EReference, @NonNull Set<@NonNull GrammarRuleValue>> eContainmentFeature2assignedTargetRuleValues = this.getEContainmentFeature2assignedTargetRuleValues(serializationRuleAnalyses);
            EClassValue.EReference_TargetGrammarRuleVector[] eReferenceRuleIndexes = null;
            if (eContainmentFeature2assignedTargetRuleValues != null) {
                eReferenceRuleIndexes = new EClassValue.EReference_TargetGrammarRuleVector[eContainmentFeature2assignedTargetRuleValues.size()];
                int i2 = 0;
                for (Map.Entry<EReference, Set<GrammarRuleValue>> entry2 : eContainmentFeature2assignedTargetRuleValues.entrySet()) {
                    @NonNull Set values = (Set)SerializationUtils.nonNullState(entry2.getValue());
                    ParserRuleValue[] parserRuleValues = new ParserRuleValue[values.size()];
                    int i3 = 0;
                    for (GrammarRuleValue value : values) {
                        parserRuleValues[i3++] = (ParserRuleValue)value;
                    }
                    eReferenceRuleIndexes[i2++] = new EClassValue.EReference_TargetGrammarRuleVector(entry2.getKey(), new GrammarRuleVector((Indexed[])parserRuleValues));
                }
            }
            @NonNull SerializationRule[] serializationRules = new SerializationRule[serializationRuleAnalyses.size()];
            int i = 0;
            for (SerializationRuleAnalysis serializationRuleAnalysis : serializationRuleAnalyses) {
                SerializationRule serializationRule = serializationRuleAnalysis.getSerializationRule();
                serializationRules[i++] = serializationRule;
                serializationRule2aserializationRuleAnalysis2.put(serializationRule, serializationRuleAnalysis);
            }
            this.addEClassValue(new EClassValue(eClass, serializationRules, eReferenceRuleIndexes));
        }
        for (SerializationRule serializationRule : serializationRule2aserializationRuleAnalysis2.keySet()) {
            SerializationRuleAnalysis serializationRuleAnalysis;
            serializationRuleAnalysis = (SerializationRuleAnalysis)SerializationUtils.maybeNull((Object)serializationRule2aserializationRuleAnalysis2.get(serializationRule));
            assert (serializationRuleAnalysis != null);
            @NonNull SerializationRule serializationRule2 = serializationRuleAnalysis.getSerializationRule();
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EClassValue.EReference_TargetGrammarRuleVector @Nullable [] basicGetEReferenceRuleIndexes(@NonNull EClass eClass) {
        EClassValue eClassValue = this.getEClassValue(eClass);
        return eClassValue.basicGetEReferenceRuleIndexes();
    }

    public @Nullable AbstractRuleAnalysis basicGetRuleAnalysis(int ruleValueIndex) {
        return this.ruleAnalyses.get(ruleValueIndex);
    }

    public @Nullable GrammarRuleValue basicGetRuleValue(int ruleValueIndex) {
        AbstractRuleAnalysis ruleAnalysis = (AbstractRuleAnalysis)SerializationUtils.nonNullState((Object)this.ruleAnalyses.get(ruleValueIndex));
        return ruleAnalysis.basicGetRuleValue();
    }

    public @NonNull IdiomGrammarMatch createIdiomMatch(@NonNull Idiom idiom, @NonNull AbstractElement grammarElement) {
        return new IdiomGrammarMatch(idiom, grammarElement);
    }

    public @NonNull IdiomSerializationMatch createIdiomMatch(@NonNull Idiom idiom, @NonNull SerializationNode serializationNode) {
        return new IdiomSerializationMatch(idiom, serializationNode);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void createRuleAnalyses(@NonNull Map<@NonNull String, @NonNull List<@NonNull AbstractRule>> ruleName2rules, @NonNull Map<@NonNull AbstractRule, @NonNull List<@NonNull RuleCall>> rule2ruleCalls) {
        ArrayList<@NonNull String> ruleNames = new ArrayList<String>(ruleName2rules.keySet());
        Collections.sort(ruleNames);
        for (String ruleName : ruleNames) {
            AbstractRuleAnalysis ruleAnalysis;
            @NonNull List rules = (List)SerializationUtils.maybeNull(ruleName2rules.get(ruleName));
            assert (rules != null);
            AbstractRule activeRule = null;
            if (rules.size() == 1) {
                activeRule = (AbstractRule)SerializationUtils.maybeNull((Object)((AbstractRule)rules.get(0)));
            } else {
                for (AbstractRule rule : rules) {
                    @NonNull List ruleCalls = (List)SerializationUtils.maybeNull(rule2ruleCalls.get(rule));
                    if (ruleCalls == null) continue;
                    if (activeRule != null) {
                        throw new IllegalStateException("Duplicate overridden rule '" + ruleName + "'");
                    }
                    activeRule = rule;
                }
            }
            if (activeRule == null) {
                throw new IllegalStateException("No unique rule '" + ruleName + "'");
            }
            int ruleIndex = this.ruleAnalyses.size();
            if (activeRule instanceof ParserRule) {
                EClassifier eClassifier = SerializationUtils.getClassifier((TypeRef)activeRule.getType());
                ruleAnalysis = eClassifier instanceof EClass ? new ParserRuleAnalysis(this, ruleIndex, (ParserRule)activeRule, (EClass)eClassifier) : new DataTypeRuleAnalysis(this, ruleIndex, (ParserRule)activeRule, (EDataType)eClassifier);
            } else if (activeRule instanceof TerminalRule) {
                ruleAnalysis = new TerminalRuleAnalysis(this, ruleIndex, (TerminalRule)activeRule);
            } else {
                throw new UnsupportedOperationException();
            }
            this.rule2ruleAnalysis.put(activeRule, ruleAnalysis);
            this.ruleAnalyses.add(ruleAnalysis);
        }
    }

    public @NonNull ActionAssignmentAnalysis getAssignmentAnalysis(@NonNull Action action) {
        assert (this.assignment2assignmentAnalysis != null);
        return (ActionAssignmentAnalysis)SerializationUtils.nonNullState((Object)this.assignment2assignmentAnalysis.get(action));
    }

    public @NonNull List<@NonNull AssignmentAnalysis> getAssignmentAnalyses(@NonNull EStructuralFeature eFeature) {
        assert (this.containment2assignmentAnalyses != null);
        return (List)SerializationUtils.nonNullState(this.containment2assignmentAnalyses.get(eFeature));
    }

    public @NonNull DirectAssignmentAnalysis getAssignmentAnalysis(@NonNull Assignment assignment) {
        assert (this.assignment2assignmentAnalysis != null);
        return (DirectAssignmentAnalysis)SerializationUtils.nonNullState((Object)this.assignment2assignmentAnalysis.get(assignment));
    }

    public @NonNull EClassValue getEClassValue(@NonNull EClass eClass) {
        assert (this.eClass2eClassValue.size() > 0);
        return (EClassValue)SerializationUtils.nonNullState((Object)this.eClass2eClassValue.get(eClass));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EClassValue.EReference_TargetGrammarRuleVector @NonNull [] getEReferenceRuleIndexes(@NonNull EClass eClass) {
        return (EClassValue.EReference_TargetGrammarRuleVector[])SerializationUtils.nonNullState((Object)this.basicGetEReferenceRuleIndexes(eClass));
    }

    public @Nullable Map<@NonNull EReference, @NonNull Set<@NonNull GrammarRuleValue>> getEContainmentFeature2assignedTargetRuleValues(@NonNull Iterable<@NonNull SerializationRuleAnalysis> serializationRules) {
        HashMap<@NonNull EReference, @NonNull HashSet<@NonNull E>> eContainmentFeature2assignedTargetRuleValues = null;
        for (EReference eContainmentFeature : this.containment2assignmentAnalyses.keySet()) {
            HashSet<GrammarRuleValue> targetRuleValues = null;
            for (SerializationRuleAnalysis serializationRule : serializationRules) {
                Iterable<@NonNull AssignedSerializationNode> assignedSerializationNodes = serializationRule.getAssignedSerializationNodes(eContainmentFeature);
                if (assignedSerializationNodes == null) continue;
                for (AssignedSerializationNode assignedSerializationNode : assignedSerializationNodes) {
                    for (AbstractRuleAnalysis targetRuleAnalysis : assignedSerializationNode.getTargetRuleAnalyses()) {
                        if (targetRuleValues == null) {
                            targetRuleValues = new HashSet<GrammarRuleValue>();
                        }
                        targetRuleValues.add(targetRuleAnalysis.getRuleValue());
                    }
                }
            }
            if (targetRuleValues == null) continue;
            if (eContainmentFeature2assignedTargetRuleValues == null) {
                eContainmentFeature2assignedTargetRuleValues = new HashMap();
            }
            eContainmentFeature2assignedTargetRuleValues.put(eContainmentFeature, targetRuleValues);
        }
        return eContainmentFeature2assignedTargetRuleValues;
    }

    public @NonNull EnumerationValue getEnumerationValue(@NonNull Keyword keyword) {
        String value = SerializationUtils.getValue((Keyword)keyword);
        EnumerationValue.EnumerationValueSingle enumerationValue = (EnumerationValue.EnumerationValueSingle)SerializationUtils.maybeNull((Object)this.value2enumerationValue.get(value));
        if (enumerationValue == null) {
            enumerationValue = new EnumerationValue.EnumerationValueSingle(value);
            this.value2enumerationValue.put(value, enumerationValue);
        }
        return enumerationValue;
    }

    public @NonNull EnumerationValue getEnumerationValue(@NonNull Iterable<@NonNull Keyword> keywords) {
        ArrayList<@NonNull String> values = new ArrayList<String>();
        for (Keyword keyword : keywords) {
            values.add(SerializationUtils.getValue((Keyword)keyword));
        }
        Collections.sort(values);
        EnumerationValue.EnumerationValueMultiple enumerationValue = (EnumerationValue.EnumerationValueMultiple)SerializationUtils.maybeNull((Object)this.values2enumerationValue.get(values));
        if (enumerationValue == null) {
            enumerationValue = new EnumerationValue.EnumerationValueMultiple(values);
            this.values2enumerationValue.put(values, enumerationValue);
        }
        return enumerationValue;
    }

    public @NonNull Iterable<@NonNull EnumerationValue> getEnumerationValues() {
        return new HashSet<EnumerationValue.EnumerationValueMultiple>(this.values2enumerationValue.values());
    }

    public @NonNull Grammar getGrammar() {
        Grammar grammar2 = this.grammar;
        if (grammar2 == null) {
            this.grammar = grammar2 = (Grammar)SerializationUtils.nonNullState((Object)this.grammarProvider.getGrammar((Object)this));
        }
        return grammar2;
    }

    public @NonNull IdiomsModel getIdiomsModel(@NonNull ResourceSet resourceSet, @NonNull URI uri) {
        IdiomsPackage.eINSTANCE.getClass();
        Resource resource = resourceSet.getResource(uri, true);
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        @NonNull IdiomsModel castIdiomModel = (IdiomsModel)resource.getContents().get(0);
        return castIdiomModel;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Iterable<@NonNull Idiom> getIdioms() {
        Grammar grammar = this.getGrammar();
        ResourceSet resourceSet = grammar.eResource().getResourceSet();
        if (resourceSet == null) {
            if (this.resourceSetProvider != null) {
                resourceSet = (ResourceSet)this.resourceSetProvider.get();
                assert (resourceSet != null);
            } else {
                resourceSet = new ResourceSetImpl();
            }
        }
        URI xtextURI = grammar.eResource().getURI();
        URI idiomsURI = xtextURI.trimFileExtension().appendFileExtension("idioms");
        assert (idiomsURI != null);
        @NonNull ArrayList idiomsModels = Lists.newArrayList((Object[])new IdiomsModel[]{this.getIdiomsModel(resourceSet, idiomsURI)});
        ArrayList<@NonNull Idiom> idioms = new ArrayList<Idiom>();
        StringBuilder s = null;
        int i = 0;
        while (i < idiomsModels.size()) {
            IdiomsModel idiomsModel = (IdiomsModel)SerializationUtils.nonNullState((Object)((IdiomsModel)idiomsModels.get(i)));
            List errors = (List)SerializationUtils.nonNullState((Object)idiomsModel.eResource().getErrors());
            if (errors.size() > 0) {
                if (s == null) {
                    s = new StringBuilder();
                }
                s.append(SerializationUtils.formatResourceDiagnostics((List)errors, (String)"", (String)"\n"));
            }
            Iterables.addAll(idioms, (Iterable)IdiomsUtils.getOwnedIdioms((IdiomsModel)idiomsModel));
            for (IdiomsImport idiomsImport : IdiomsUtils.getOwnedWiths((IdiomsModel)idiomsModel)) {
                IdiomsModel importedIdiomsModel = IdiomsUtils.getIdiomsModel((IdiomsImport)idiomsImport);
                if (idiomsModels.contains(importedIdiomsModel)) continue;
                idiomsModels.add(importedIdiomsModel);
            }
            ++i;
        }
        if (s != null) {
            throw new IllegalStateException("Failed to load idioms" + s.toString());
        }
        return idioms;
    }

    public @NonNull SerializationSegment @NonNull [] @NonNull [] getInnerFormattingSegments(@NonNull ParserRuleValue parserRuleValue) {
        return parserRuleValue.getInnerFormattingSegments();
    }

    public @NonNull GrammarRuleVector getLeafGrammarRulesVector() {
        GrammarRuleVector leafGrammarRulesVector2 = this.leafGrammarRulesVector;
        if (leafGrammarRulesVector2 == null) {
            leafGrammarRulesVector2 = new GrammarRuleVector();
            for (AbstractRuleAnalysis ruleAnalysis : this.rule2ruleAnalysis.values()) {
                Collection<ParserRuleAnalysis> subRuleAnalysesClosure;
                if (!(ruleAnalysis instanceof ParserRuleAnalysis) || (subRuleAnalysesClosure = ((ParserRuleAnalysis)ruleAnalysis).getSubRuleAnalysesClosure()).size() > 1) continue;
                leafGrammarRulesVector2.set(ruleAnalysis.getIndex());
            }
        }
        return leafGrammarRulesVector2;
    }

    public @NonNull LocatorHelper.LocatorSwitch getLocatorSwitch() {
        return LocatorHelper.LocatorSwitch.INSTANCE;
    }

    public @Nullable Map<@NonNull String, @NonNull String> getMultipleLineCommentCharacterRanges() {
        return this.multipleLineCommentCharacterRanges;
    }

    public @NonNull SerializationSegment @NonNull [] @NonNull [] getOuterFormattingSegments(@NonNull ParserRuleValue parserRuleValue) {
        return parserRuleValue.getOuterFormattingSegments();
    }

    public @NonNull List<@NonNull ParserRuleAnalysis> getProducingRuleAnalyses(@NonNull EClass eClass) {
        assert (this.eClass2ruleAnalyses != null);
        return (List)SerializationUtils.nonNullState(this.eClass2ruleAnalyses.get(eClass));
    }

    public @NonNull Iterable<@NonNull AbstractRuleAnalysis> getRuleAnalyses() {
        assert (this.eClass2ruleAnalyses != null);
        return (Iterable)SerializationUtils.nonNullState(this.rule2ruleAnalysis.values());
    }

    public @NonNull AbstractRuleAnalysis getRuleAnalysis(@NonNull AbstractRule abstractRule) {
        assert (this.rule2ruleAnalysis != null);
        return (AbstractRuleAnalysis)SerializationUtils.nonNullState((Object)this.rule2ruleAnalysis.get(abstractRule));
    }

    public @NonNull AbstractRuleAnalysis getRuleAnalysis(int ruleValueIndex) {
        return (AbstractRuleAnalysis)SerializationUtils.nonNullState((Object)this.ruleAnalyses.get(ruleValueIndex));
    }

    public @NonNull String getRuleName(int ruleValueIndex) {
        return this.getRuleAnalysis(ruleValueIndex).getName();
    }

    public @NonNull GrammarRuleValue getRuleValue(int ruleValueIndex) {
        return this.getRuleAnalysis(ruleValueIndex).getRuleValue();
    }

    public @NonNull SerializationRuleAnalysis getSerializationRuleAnalysis(@NonNull SerializationRule serializationRule) {
        assert (this.serializationRule2aserializationRuleAnalysis != null);
        return (SerializationRuleAnalysis)SerializationUtils.nonNullState((Object)this.serializationRule2aserializationRuleAnalysis.get(serializationRule));
    }

    public @NonNull SerializationRule @NonNull [] getSerializationRules(@NonNull ParserRuleValue ruleValue) {
        return ruleValue.getSerializationRules();
    }

    public @NonNull SerializationSegment getSerializationSegment(@NonNull Segment segment) {
        SerializationSegment serializationSegment = (SerializationSegment)SerializationUtils.maybeNull((Object)this.segment2serializationSegment.get(segment));
        if (serializationSegment == null) {
            if (segment instanceof HalfNewLineSegment) {
                serializationSegment = SerializationSegment.HALF_NEW_LINE;
            } else if (segment instanceof NewLineSegment) {
                serializationSegment = SerializationSegment.NEW_LINE;
            } else if (segment instanceof NoSpaceSegment) {
                serializationSegment = SerializationSegment.NO_SPACE;
            } else if (segment instanceof PopSegment) {
                serializationSegment = SerializationSegment.POP;
            } else if (segment instanceof PostCommentSegment) {
                serializationSegment = SerializationSegment.POST_COMMENT;
            } else if (segment instanceof PreCommentSegment) {
                serializationSegment = SerializationSegment.PRE_COMMENT;
            } else if (segment instanceof PushSegment) {
                serializationSegment = SerializationSegment.PUSH;
            } else if (segment instanceof SoftNewLineSegment) {
                serializationSegment = SerializationSegment.SOFT_NEW_LINE;
            } else if (segment instanceof SoftSpaceSegment) {
                serializationSegment = SerializationSegment.SOFT_SPACE;
            } else if (segment instanceof ValueSegment) {
                serializationSegment = SerializationSegment.VALUE;
            } else if (segment instanceof CustomSegment) {
                String supportClassName = ((CustomSegment)segment).getSupportClassName();
                assert (supportClassName != null);
                serializationSegment = new SerializationSegment.CustomSerializationSegment(supportClassName);
            } else {
                throw new UnsupportedOperationException();
            }
            this.segment2serializationSegment.put(segment, serializationSegment);
        }
        return serializationSegment;
    }

    public @NonNull SerializationSegment @Nullable [] getSerializationSegments(@NonNull List<@NonNull SubIdiom> subIdioms, @Nullable Boolean isAll) {
        @NonNull SerializationSegment @Nullable [] serializationSegments = null;
        ArrayList mergedSegments = null;
        for (SubIdiom subIdiom : subIdioms) {
            EList segments;
            if (isAll != null && subIdiom.isAll() != isAll.booleanValue() || (segments = subIdiom.getOwnedSegments()) == null) continue;
            if (mergedSegments == null) {
                mergedSegments = new ArrayList(segments);
                continue;
            }
            ArrayList<Segment> newMergedSegments = new ArrayList<Segment>(segments.size() + mergedSegments.size() - 1);
            for (Segment segment : mergedSegments) {
                if (segment instanceof ValueSegment) {
                    newMergedSegments.addAll((Collection<Segment>)segments);
                    continue;
                }
                newMergedSegments.add(segment);
            }
            mergedSegments = newMergedSegments;
        }
        if (mergedSegments != null) {
            serializationSegments = new SerializationSegment[mergedSegments.size()];
            int j = 0;
            while (j < serializationSegments.length) {
                Segment segment = (Segment)SerializationUtils.nonNullState((Object)((Segment)mergedSegments.get(j)));
                if (segment instanceof ReferredSegment) {
                    segment = IdiomsUtils.getOwnedSegment((SegmentDeclaration)IdiomsUtils.getSegmentDeclaration((ReferredSegment)((ReferredSegment)segment)));
                }
                serializationSegments[j] = this.getSerializationSegment(segment);
                ++j;
            }
        }
        return serializationSegments;
    }

    public @Nullable List<@NonNull String> getSingleLineCommentKeywords() {
        return this.singleLineCommentKeywords;
    }

    public @NonNull Iterable<@NonNull EClassValue> getSortedProducedEClassValues() {
        List<@NonNull EClassValue> sortedProducedEClassValues2 = this.sortedProducedEClassValues;
        if (sortedProducedEClassValues2 == null) {
            assert (this.eClass2eClassValue.size() > 0);
            this.sortedProducedEClassValues = sortedProducedEClassValues2 = new ArrayList<EClassValue>((Collection)SerializationUtils.nonNullState(this.eClass2eClassValue.values()));
            Collections.sort(this.sortedProducedEClassValues, SerializationUtils.NAMEABLE_COMPARATOR);
        }
        return sortedProducedEClassValues2;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull String toString() {
        DiagnosticStringBuilder s = new DiagnosticStringBuilder();
        s.append("Xtext production rule -> Xtext base rules <=> User EClass - User EStructuralFeatures");
        for (AbstractRuleAnalysis abstractRuleAnalysis : this.ruleAnalyses) {
            s.append("\n  ");
            s.append(abstractRuleAnalysis.getName());
            if (!(abstractRuleAnalysis instanceof ParserRuleAnalysis)) continue;
            ParserRuleAnalysis parserRuleAnalysis = (ParserRuleAnalysis)abstractRuleAnalysis;
            s.append(" -");
            Map<@NonNull EStructuralFeature, @NonNull List<@NonNull AssignmentAnalysis>> eFeature2assignmentAnalyses = parserRuleAnalysis.getEFeature2assignmentAnalyses();
            ArrayList<@NonNull EStructuralFeature> eFeatures = new ArrayList<EStructuralFeature>(eFeature2assignmentAnalyses.keySet());
            Collections.sort(eFeatures, SerializationUtils.ENAMED_ELEMENT_COMPARATOR);
            boolean isFirstFeature = true;
            for (EStructuralFeature eFeature : eFeatures) {
                if (isFirstFeature) {
                    s.append(" ");
                } else {
                    s.append(",");
                }
                @NonNull List assignmentAnalyses = (List)SerializationUtils.maybeNull(eFeature2assignmentAnalyses.get(eFeature));
                assert (assignmentAnalyses != null);
                int size = assignmentAnalyses.size();
                if (size != 1) {
                    s.appendObject((Object)size);
                    s.append("*");
                }
                s.append(eFeature.getName());
                isFirstFeature = false;
            }
            for (SerializationRuleAnalysis serializationRule : parserRuleAnalysis.getSerializationRuleAnalyses()) {
                s.appendIndentation(2);
                s.append("|& ");
                serializationRule.toRuleString(s, -1);
            }
        }
        s.append("\n\nUser EClass <=> Prioritized serialization rule(s)");
        s.append(super.toString());
        @NonNull String castString = s.toString();
        return castString;
    }
}

