/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystem;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.junit.After;
import org.junit.Before;

public class PrettyPrinterTest
extends PivotTestSuite {
    public PrettyPrinterTest() {
        super(false);
    }

    @Override
    protected @NonNull MyOCL createOCL() {
        return new MyOCL(this.getTestFileSystem(), this.getTestPackageName(), this.getName());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void test_ReservedWords() {
        MyOCL ocl = this.createOCL();
        ocl.assertPrintResults(null, "let _'and' : Boolean[1] = false in _'and' and _'and'");
        ocl.assertPrintResults(null, "let _'else' : Boolean[1] = false in if _'else' then _'else' else _'else' endif");
        ocl.assertPrintResults(null, "let _'endif' : Boolean[1] = false in if _'endif' then _'endif' else _'endif' endif");
        ocl.assertPrintResults(null, "let _'false' : Boolean[1] = false in _'false' and _'false'");
        ocl.assertPrintResults(null, "let _'if' : Boolean[1] = false in if _'if' then _'if' else _'if' endif");
        ocl.assertPrintResults(null, "let _'implies' : Boolean[1] = false in _'implies' implies _'implies'");
        ocl.assertPrintResults(null, "let _'in' : Boolean[1] = false in _'in'");
        ocl.assertPrintResults(null, "let _'invalid' : Boolean[1] = false in _'invalid' and invalid");
        ocl.assertPrintResults(null, "let _'let' : Boolean[1] = false in _'let'");
        ocl.assertPrintResults(null, "let _'not' : Boolean[1] = false in not _'not'");
        ocl.assertPrintResults(null, "let _'null' : Boolean[1] = false in _'null' and null");
        ocl.assertPrintResults(null, "let _'or' : Boolean[1] = false in _'or' or _'or'");
        ocl.assertPrintResults(null, "let _'self' : Boolean = false in self or _'self'", "let _'self' : Boolean[1] = false in self or self");
        ocl.assertPrintResults(null, "let _'then' : Boolean[1] = false in if _'then' then _'then' else _'then' endif");
        ocl.assertPrintResults(null, "let _'true' : Boolean[1] = false in _'true' and _'true'");
        ocl.assertPrintResults(null, "let _'xor' : Boolean[1] = false in _'xor' xor _'xor'");
        ocl.dispose();
    }

    public void test_SetDifference() {
        MyOCL ocl = this.createOCL();
        ocl.assertPrintResults(null, "let a : Set(Integer) = Set{1} in let b : Set(Integer) = Set{1} in a - b");
        ocl.dispose();
    }

    public void test_SourceNavigationPrecedence() {
        MyOCL ocl = this.createOCL();
        ocl.assertPrintResults(null, "let a : Set(Integer) = Set{1} in (a - a)->isEmpty()");
        ocl.assertPrintResults(null, "let a : Set(Integer) = Set{1} in a->isEmpty()");
        ocl.assertPrintResults(null, "let a : Set(Integer) = Set{1} in a->asSet()->asSet()");
        ocl.assertPrintResults(null, "let a : Set(Integer) = Set{1} in a->select(true)->asSet()");
        ocl.dispose();
    }

    public void test_ImplicitCollect() {
        MyOCL ocl = this.createOCL();
        ocl.assertPrintResults(null, "Set{1}.toString()");
        ocl.dispose();
    }

    public void test_ElseIf() {
        MyOCL ocl = this.createOCL();
        ocl.assertPrintResults(null, "if true then 1 else 2 endif");
        ocl.assertPrintResults(null, "if true then 1 elseif true then 2 else 3 endif");
        ocl.assertPrintResults(null, "if true then 1 elseif true then 2 elseif true then 3 else 4 endif");
        ocl.assertPrintResults(null, "if if true then 1 elseif true then 2 else if true then 1 elseif true then 2 else 3 endif endif then if true then 1 elseif true then 2 else 3 endif elseif if true then 1 elseif true then 2 else 3 endif then 2 else 3 endif");
        ocl.dispose();
    }

    public static class MyOCL
    extends TestOCL {
        public MyOCL(@NonNull TestFileSystem testFileSystem, @NonNull String testPackageName, @NonNull String name) {
            super(testFileSystem, testPackageName, name, OCL.NO_PROJECTS, null);
        }

        protected @Nullable Object assertPrintResults(@Nullable Object context, @NonNull String expression) {
            try {
                Class contextType = this.getContextType(context);
                ExpressionInOCL query = this.createQuery((EObject)contextType, expression);
                String prettyExpression = PrettyPrinter.print((Element)query);
                PrettyPrinterTest.assertEquals((String)expression, (String)prettyExpression);
            }
            catch (ParserException e) {
                PrettyPrinterTest.fail((String)("Failed to parse \"" + expression + "\": " + e.getLocalizedMessage()));
            }
            return null;
        }

        protected @Nullable Object assertPrintResults(@Nullable Object context, @NonNull String expression, @NonNull String expectedExpression) {
            try {
                Class contextType = this.getContextType(context);
                ExpressionInOCL query = this.createQuery((EObject)contextType, expression);
                String prettyExpression = PrettyPrinter.print((Element)query);
                PrettyPrinterTest.assertEquals((String)expectedExpression, (String)prettyExpression);
            }
            catch (ParserException e) {
                PrettyPrinterTest.fail((String)("Failed to parse \"" + expression + "\": " + e.getLocalizedMessage()));
            }
            return null;
        }
    }
}

