/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.xtext.resource.impl.BinaryGrammarResourceFactoryImpl;

public abstract class AbstractGrammarTests
extends XtextTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected void doTestGrammar(@NonNull Class<?> grammarClass, @NonNull String fileName, @NonNull Resource javaResource) throws IOException, InterruptedException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xtextbin", new BinaryGrammarResourceFactoryImpl());
        Resource binaryResource = resourceSet.createResource(URI.createURI((String)fileName), null);
        InputStream inputStream = grammarClass.getResourceAsStream(fileName);
        binaryResource.load(inputStream, null);
        assert (binaryResource != null);
        AbstractGrammarTests.assertNoResourceErrors("Load failed", binaryResource);
        AbstractGrammarTests.assertNoUnresolvedProxies("Java Model", binaryResource);
        AbstractGrammarTests.assertNoValidationErrors("File Model", binaryResource);
        AbstractGrammarTests.assertNoResourceErrors("Java Model", javaResource);
        AbstractGrammarTests.assertNoUnresolvedProxies("Java Model", javaResource);
        AbstractGrammarTests.assertNoValidationErrors("Java Model", javaResource);
        TestUtil.assertSameModel(binaryResource, javaResource);
        AbstractGrammarTests.disposeResourceSet((ResourceSet)resourceSet);
        resourceSet = null;
    }
}

