/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.idioms.serializer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.CustomSegmentSupport;
import org.eclipse.ocl.examples.xtext.serializer.SerializationBuilder;
import org.eclipse.ocl.examples.xtext.serializer.UserElementFormatter;
import org.eclipse.ocl.examples.xtext.serializer.UserElementSerializer;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class IdiomsCommentSegmentSupport
implements CustomSegmentSupport {
    protected void appendComment(@NonNull SerializationBuilder serializationBuilder, @NonNull String comment) {
        serializationBuilder.append(SerializationBuilder.HALF_NEW_LINE);
        serializationBuilder.append("/*");
        serializationBuilder.append(SerializationBuilder.PUSH_NEXT);
        serializationBuilder.append(" *");
        int start = 0;
        while (true) {
            int index;
            String line = comment.substring(start, (index = comment.indexOf(10, start)) >= 0 ? index : comment.length());
            assert (line != null);
            serializationBuilder.append(line);
            if (index < 0) break;
            serializationBuilder.append(SerializationBuilder.NEW_LINE);
            start = index + 1;
        }
        serializationBuilder.append(SerializationBuilder.POP);
        serializationBuilder.append("*/");
        serializationBuilder.append(SerializationBuilder.NEW_LINE);
    }

    protected @Nullable String getComment(@NonNull EObject eObject) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)eObject);
        if (node == null) {
            return null;
        }
        List<ILeafNode> documentationNodes = this.getDocumentationNodes(node);
        if (documentationNodes == null) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        for (ILeafNode documentationNode : documentationNodes) {
            String text = documentationNode.getText().replace("\r", "");
            if (text.length() < 4 || !text.startsWith("/*") || !text.endsWith("*/")) continue;
            String contentString = text.substring(2, text.length() - 2);
            boolean firstLine = true;
            String[] stringArray = contentString.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (s.length() > 0) {
                    s.append("\n");
                }
                s.append(!firstLine && string.startsWith(" *") ? string.substring(2) : string);
                firstLine = false;
                ++n2;
            }
        }
        return s.toString();
    }

    protected @Nullable List<@NonNull ILeafNode> getDocumentationNodes(@NonNull ICompositeNode node) {
        ArrayList<@NonNull ILeafNode> documentationNodes = null;
        for (ILeafNode leafNode : node.getLeafNodes()) {
            EObject grammarElement = leafNode.getGrammarElement();
            if (!(grammarElement instanceof TerminalRule)) break;
            TerminalRule terminalRule = (TerminalRule)grammarElement;
            String name = terminalRule.getName();
            if ("WS".equals(name) || "SL_COMMENT".equals(name)) continue;
            if (!"ML_COMMENT".equals(name)) break;
            if (documentationNodes == null) {
                documentationNodes = new ArrayList<ILeafNode>();
            }
            documentationNodes.add(leafNode);
        }
        return documentationNodes;
    }

    public void format(@NonNull UserElementFormatter fomatter, @NonNull SerializationBuilder serializationBuilder) {
        EObject eObject = fomatter.getElement();
        String comment = this.getComment(eObject);
        if (comment != null) {
            this.appendComment(serializationBuilder, comment);
        }
    }

    public void serialize(int thisSserializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
        EObject eObject = serializer.getElement();
        String comment = this.getComment(eObject);
        if (comment != null) {
            this.appendComment(serializationBuilder, comment);
        }
    }
}

