/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllSubclassesFinder {
    private static final Logger logger = Logger.getLogger(AllSubclassesFinder.class.getName());
    private final EPackage.Registry registry;
    private static AllSubclassesFinder instance;
    private Set<EPackage> cachedPackages;
    private Map<EClass, Set<EClass>> subclasses = new HashMap<EClass, Set<EClass>>();

    public static AllSubclassesFinder getInstance() {
        if (instance == null) {
            instance = new AllSubclassesFinder();
        }
        return instance;
    }

    protected AllSubclassesFinder() {
        this(EPackage.Registry.INSTANCE);
    }

    public AllSubclassesFinder(EPackage.Registry registry) {
        this.registry = registry;
        this.cachedPackages = new HashSet<EPackage>();
    }

    private void cachePackage(EPackage ePackage) {
        for (EClassifier c : ePackage.getEClassifiers()) {
            if (!(c instanceof EClass)) continue;
            this.cacheSubclassRelations((EClass)c);
        }
    }

    private void cacheSubclassRelations(EClass c) {
        for (EClass sup : c.getESuperTypes()) {
            this.cacheSubclassForSuperclass(c, sup);
        }
    }

    private void cacheSubclassForSuperclass(EClass sub, EClass sup) {
        Set<EClass> subclassesOfSup = this.subclasses.get(sup);
        if (subclassesOfSup == null) {
            subclassesOfSup = new HashSet<EClass>();
            this.subclasses.put(sup, subclassesOfSup);
        }
        subclassesOfSup.add(sub);
        for (EClass supsup : sup.getESuperTypes()) {
            this.cacheSubclassForSuperclass(sub, supsup);
        }
    }

    public Collection<EClass> getAllSubclasses(EClass c) {
        this.updateOppositeCache();
        Collection result = this.subclasses.get(c);
        result = result == null ? Collections.emptySet() : Collections.unmodifiableCollection(result);
        return result;
    }

    private void updateOppositeCache() {
        HashSet registryKeys = new HashSet(this.registry.keySet());
        for (String packageUri : registryKeys) {
            try {
                EPackage ePackage = this.registry.getEPackage(packageUri);
                if (this.cachedPackages.contains(ePackage)) continue;
                this.cachedPackages.add(ePackage);
                this.cachePackage(ePackage);
            }
            catch (Throwable e) {
                logger.warning("couldn't resolve Ecore package with URI " + packageUri + ": " + e.getMessage());
            }
        }
    }
}

