/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.export;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.export.ValidityExporterDescriptor;
import org.eclipse.ocl.examples.emf.validation.validity.export.ValidityExporterRegistry;

public class ValidityExporterListener
implements IRegistryEventListener {
    public static final String VALIDITY_EXPORTER_EXTENSION_POINT = "org.eclipse.ocl.examples.emf.validation.validity.validity_exporter";
    private static final @NonNull String VALIDITY_EXPORTER_TAG_EXTENSION = "exporter";
    private static final @NonNull String VALIDITY_EXPORTER_CLASS_ATTRIBUTE = "class";
    private static final @NonNull String VALIDITY_EXPORTER_NAME_ATTRIBUTE = "name";
    private static final @NonNull String VALIDITY_EXPORTER_TYPE_ATTRIBUTE = "type";

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        System.err.println("Plugin " + extension.getContributor().getName() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        System.err.println(text);
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "The required attribute '" + attributeName + "' not defined");
    }

    private void parseExtension(IExtension extension) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            String name = elem.getName();
            if (VALIDITY_EXPORTER_TAG_EXTENSION.equals(name)) {
                String exporterType = elem.getAttribute(VALIDITY_EXPORTER_TYPE_ATTRIBUTE);
                String exporterName = elem.getAttribute(VALIDITY_EXPORTER_NAME_ATTRIBUTE);
                if (exporterType == null) {
                    this.logMissingAttribute(elem, VALIDITY_EXPORTER_TYPE_ATTRIBUTE);
                } else if (exporterName == null) {
                    this.logMissingAttribute(elem, VALIDITY_EXPORTER_NAME_ATTRIBUTE);
                } else {
                    ValidityExporterRegistry.INSTANCE.addExporter(new ValidityExporterDescriptor(elem, VALIDITY_EXPORTER_CLASS_ATTRIBUTE, exporterType, exporterName));
                }
            }
            ++n2;
        }
    }

    public void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(VALIDITY_EXPORTER_EXTENSION_POINT);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elem = iConfigurationElementArray[n4];
                String name = elem.getName();
                if (VALIDITY_EXPORTER_TAG_EXTENSION.equals(name)) {
                    String exporterType = elem.getAttribute(VALIDITY_EXPORTER_TYPE_ATTRIBUTE);
                    if (exporterType == null) {
                        this.logMissingAttribute(elem, VALIDITY_EXPORTER_TYPE_ATTRIBUTE);
                    } else {
                        ValidityExporterRegistry.INSTANCE.removeExtension(exporterType);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }
}

