/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.elements;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.build.analysis.SerializationRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.elements.SequenceSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationNode;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;

public class SerializationRuleAnalysisComparator
implements Comparator<SerializationRuleAnalysis> {
    private Map<@NonNull SerializationRuleAnalysis, @NonNull Integer> rule2size = new HashMap<SerializationRuleAnalysis, Integer>();

    @Override
    public int compare(@NonNull SerializationRuleAnalysis rule1, @NonNull SerializationRuleAnalysis rule2) {
        int size2;
        int size1 = this.getSize(rule1);
        int diff = size1 - (size2 = this.getSize(rule2));
        if (diff != 0) {
            return diff;
        }
        String name1 = rule1.getVariantName();
        String name2 = rule2.getVariantName();
        diff = name1.compareTo(name2);
        assert (diff != 0);
        return diff;
    }

    private int getSize(@NonNull SerializationRuleAnalysis serializationRule) {
        Integer size = (Integer)SerializationUtils.maybeNull((Object)this.rule2size.get(serializationRule));
        if (size == null) {
            size = this.getSize(serializationRule.getRootSerializationNode());
            this.rule2size.put(serializationRule, size);
        }
        return size;
    }

    private int getSize(@NonNull SerializationNode parentSerializationNode) {
        int size = 0;
        if (parentSerializationNode instanceof SequenceSerializationNode) {
            for (SerializationNode childSerializationNode : ((SequenceSerializationNode)parentSerializationNode).getSerializationNodes()) {
                size += 2 * this.getSize(childSerializationNode);
            }
        } else {
            ++size;
        }
        return size;
    }
}

