/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.Indexed;
import org.eclipse.ocl.examples.xtext.serializer.Nameable;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CharacterRange;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;

public class SerializationUtils {
    public static @NonNull String defaultIndentation = "    ";
    public static final @NonNull ENamedElementComparator ENAMED_ELEMENT_COMPARATOR = ENamedElementComparator.INSTANCE;
    public static final @NonNull IndexedComparator INDEXED_COMPARATOR = IndexedComparator.INSTANCE;
    public static final @NonNull NameableComparator NAMEABLE_COMPARATOR = NameableComparator.INSTANCE;

    public static void appendIndentation(@NonNull StringBuilder s, int depth) {
        SerializationUtils.appendIndentation(s, depth, defaultIndentation);
    }

    public static void appendIndentation(@NonNull StringBuilder s, int depth, @NonNull String string) {
        if (depth >= 0) {
            s.append("\n");
        }
        int i = 0;
        while (i < depth) {
            s.append(string);
            ++i;
        }
    }

    public static @NonNull EClass eClass(@NonNull EObject eObject) {
        return SerializationUtils.nonNullState(eObject.eClass());
    }

    public static @NonNull EStructuralFeature eContainingFeature(@NonNull EObject eObject) {
        return SerializationUtils.nonNullState(eObject.eContainingFeature());
    }

    public static @NonNull EReference eContainmentFeature(@NonNull EObject eObject) {
        return SerializationUtils.nonNullState(eObject.eContainmentFeature());
    }

    public static @NonNull EObject eContainer(@NonNull EObject eObject) {
        return SerializationUtils.nonNullState(eObject.eContainer());
    }

    public static void formatDiagnostic(@NonNull StringBuilder s, @NonNull Diagnostic diagnostic, @NonNull String newLine) {
        if (diagnostic.getSeverity() != 0) {
            s.append(newLine);
            s.append(String.valueOf(diagnostic.getSeverity()) + " - ");
            String location = diagnostic.getSource();
            if (location != null) {
                s.append(location);
                s.append(": ");
            }
            s.append(diagnostic.getMessage());
            for (Object obj : diagnostic.getData()) {
                s.append(newLine);
                s.append("\t");
                s.append(obj);
            }
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                if (childDiagnostic == null) continue;
                SerializationUtils.formatDiagnostic(s, childDiagnostic, String.valueOf(newLine) + "\t");
            }
        }
    }

    public static String formatResourceDiagnostics(@NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    Resource.Diagnostic> diagnostics, @NonNull String messagePrefix, @NonNull String newLine) {
        if (diagnostics.size() <= 0) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(messagePrefix);
        for (Resource.Diagnostic diagnostic : diagnostics) {
            if (diagnostic instanceof Diagnostic) {
                SerializationUtils.formatDiagnostic(s, (Diagnostic)diagnostic, newLine);
                continue;
            }
            s.append(newLine);
            String location = diagnostic.getLocation();
            if (location != null) {
                s.append(location);
                s.append(":");
            }
            s.append(diagnostic.getLine());
            try {
                int column = diagnostic.getColumn();
                if (column > 0) {
                    s.append(":");
                    s.append(column);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            s.append(": ");
            s.append(diagnostic.getMessage());
        }
        return s.toString();
    }

    public static @NonNull AbstractElement getAlternatives(@NonNull AbstractRule abstractRule) {
        return SerializationUtils.nonNullState(abstractRule.getAlternatives());
    }

    public static @NonNull Iterable<@NonNull INode> getChildren(@NonNull ICompositeNode compositeNode) {
        return SerializationUtils.nullFree(compositeNode.getChildren());
    }

    public static @NonNull EClassifier getClassifier(TypeRef type) {
        return SerializationUtils.nonNullState(type.getClassifier());
    }

    public static @NonNull EClass getEClassScope(@NonNull AbstractElement abstractElement) {
        TypeRef type = null;
        AbstractElement eObject = abstractElement;
        AbstractElement eChild = null;
        while (type == null && eObject != null) {
            if (eObject instanceof ParserRule) {
                type = ((ParserRule)eObject).getType();
            } else {
                if (eObject instanceof Action && ((Action)eObject).getFeature() != null) {
                    type = ((Action)eObject).getType();
                    break;
                }
                if (eObject instanceof Group && eChild != null) {
                    List<@NonNull AbstractElement> elements = SerializationUtils.getElements((CompoundElement)((Group)eObject));
                    int index = elements.indexOf(eChild);
                    assert (index >= 0);
                    int i = index;
                    while (--i >= 0) {
                        AbstractElement element = elements.get(i);
                        if (!(element instanceof Action)) continue;
                        type = ((Action)element).getType();
                        break;
                    }
                }
            }
            eChild = eObject;
            eObject = eObject.eContainer();
        }
        if (type != null) {
            return (EClass)SerializationUtils.getClassifier(type);
        }
        throw new IllegalStateException();
    }

    public static @NonNull EClass getEContainingClass(@NonNull EStructuralFeature eFeature) {
        return SerializationUtils.nonNullState(eFeature.getEContainingClass());
    }

    public static @NonNull EPackage getEPackage(@NonNull EClassifier eClassifier) {
        return SerializationUtils.nonNullState(eClassifier.getEPackage());
    }

    public static @NonNull List<@NonNull AbstractElement> getElements(@NonNull CompoundElement compoundElement) {
        return SerializationUtils.nullFree(compoundElement.getElements());
    }

    public static @NonNull Grammar getEContainingGrammar(@NonNull EObject eObject) {
        EObject eCursor = eObject;
        while (eCursor != null) {
            if (eCursor instanceof Grammar) {
                return (Grammar)eCursor;
            }
            eCursor = eCursor.eContainer();
        }
        throw new IllegalStateException();
    }

    public static @NonNull EClass getEReferenceType(@NonNull EReference eReference) {
        return SerializationUtils.nonNullState(eReference.getEReferenceType());
    }

    public static @NonNull EStructuralFeature getEStructuralFeature(@NonNull EClass eClass, @NonNull String featureName) {
        return SerializationUtils.nonNullState(eClass.getEStructuralFeature(featureName));
    }

    public static @NonNull EStructuralFeature getEStructuralFeature(@NonNull Assignment assignment) {
        return SerializationUtils.getEStructuralFeature(SerializationUtils.getEClassScope((AbstractElement)assignment), SerializationUtils.getFeature(assignment));
    }

    public static @NonNull EClass getSubTypeOf(@NonNull EClass thisEClass, @NonNull EClass thatEClass) {
        if (thisEClass == thatEClass) {
            return thisEClass;
        }
        if (thisEClass.isSuperTypeOf(thatEClass)) {
            return thatEClass;
        }
        if (thatEClass.isSuperTypeOf(thisEClass)) {
            return thisEClass;
        }
        throw new IllegalStateException("No common subtype");
    }

    public static @NonNull String getFeature(@NonNull Action action) {
        return SerializationUtils.nonNullState(action.getFeature());
    }

    public static @NonNull String getFeature(@NonNull Assignment assignment) {
        return SerializationUtils.nonNullState(assignment.getFeature());
    }

    public static @NonNull Keyword getLeft(@NonNull CharacterRange characterRange) {
        return SerializationUtils.nonNullState(characterRange.getLeft());
    }

    public static @NonNull String getName(@NonNull AbstractRule abstractRule) {
        return SerializationUtils.nonNullState(abstractRule.getName());
    }

    public static @NonNull String getName(@NonNull ENamedElement eNamedElement) {
        return SerializationUtils.nonNullState(eNamedElement.getName());
    }

    public static @NonNull Resource getResource(@NonNull EObject eObject) {
        return SerializationUtils.nonNullState(eObject.eResource());
    }

    public static @NonNull Keyword getRight(@NonNull CharacterRange characterRange) {
        return SerializationUtils.nonNullState(characterRange.getRight());
    }

    public static @NonNull AbstractRule getRule(@NonNull RuleCall ruleCall) {
        return SerializationUtils.nonNullState(ruleCall.getRule());
    }

    public static @NonNull String getSafeName(@Nullable Nameable aNameable) {
        if (aNameable == null) {
            return "";
        }
        String name = aNameable.getName();
        if (name == null) {
            name = "";
        }
        return name;
    }

    public static @NonNull AbstractElement getTerminal(@NonNull Assignment assignment) {
        return SerializationUtils.nonNullState(assignment.getTerminal());
    }

    public static @NonNull AbstractElement getTerminal(@NonNull CrossReference crossReference) {
        return SerializationUtils.nonNullState(crossReference.getTerminal());
    }

    public static @NonNull AbstractElement getTerminal(@NonNull UntilToken untilToken) {
        return SerializationUtils.nonNullState(untilToken.getTerminal());
    }

    public static @NonNull TypeRef getType(@NonNull AbstractRule abstractRule) {
        return SerializationUtils.nonNullState(abstractRule.getType());
    }

    public static @NonNull TypeRef getType(@NonNull Action action) {
        return SerializationUtils.nonNullState(action.getType());
    }

    public static @NonNull Iterable<@NonNull Grammar> getUsedGrammars(@NonNull Grammar grammar) {
        return SerializationUtils.nullFree(grammar.getUsedGrammars());
    }

    public static @NonNull String getValue(@NonNull Keyword keyword) {
        return SerializationUtils.nonNullState(keyword.getValue());
    }

    public static <T> @Nullable T maybeNull(T aT) {
        return aT;
    }

    public static <T> @NonNull T nonNullState(@Nullable T aT) {
        if (aT == null) {
            throw new IllegalStateException();
        }
        return aT;
    }

    public static <T> @NonNull List<@NonNull T> nullFree(@Nullable List<T> nullFreeList) {
        return nullFreeList != null ? nullFreeList : Collections.emptyList();
    }

    public static <T> @NonNull EList<@NonNull T> nullFree(@Nullable EList<T> nullFreeList) {
        return nullFreeList != null ? nullFreeList : ECollections.EMPTY_ELIST;
    }

    public static <T> @NonNull Iterable<@NonNull T> nullFree(@Nullable Iterable<T> nullFreeList) {
        return nullFreeList != null ? nullFreeList : ECollections.EMPTY_ELIST;
    }

    public static <T extends Comparable<T>> int safeCompareTo(@Nullable T object, @Nullable T otherObject) {
        if (object == null) {
            return otherObject == null ? 0 : 1;
        }
        return otherObject == null ? -1 : object.compareTo(otherObject);
    }

    public static boolean safeEquals(@Nullable Object object, @Nullable Object otherObject) {
        return object == null ? otherObject == null : object.equals(otherObject);
    }

    public static final class ENamedElementComparator
    implements Comparator<ENamedElement> {
        public static final @NonNull ENamedElementComparator INSTANCE = new ENamedElementComparator();

        @Override
        public int compare(@NonNull ENamedElement o1, @NonNull ENamedElement o2) {
            String n2;
            if (o1 == o2) {
                return 0;
            }
            String n1 = o1.getName();
            int comparison = SerializationUtils.safeCompareTo(n1, n2 = o2.getName());
            if (comparison != 0) {
                return comparison;
            }
            if (o1 instanceof EPackage && o2 instanceof EPackage && (comparison = SerializationUtils.safeCompareTo(n1 = ((EPackage)o1).getNsURI(), n2 = ((EPackage)o2).getNsURI())) != 0) {
                return comparison;
            }
            EObject p1 = o1.eContainer();
            EObject p2 = o2.eContainer();
            if (p1 instanceof ENamedElement && p2 instanceof ENamedElement) {
                return this.compare((ENamedElement)p1, (ENamedElement)p2);
            }
            return comparison;
        }
    }

    public static final class IndexedComparator
    implements Comparator<Indexed> {
        public static final @NonNull IndexedComparator INSTANCE = new IndexedComparator();

        @Override
        public int compare(@NonNull Indexed o1, @NonNull Indexed o2) {
            int n1 = o1.getIndex();
            int n2 = o2.getIndex();
            return n1 - n2;
        }
    }

    public static final class NameableComparator
    implements Comparator<Nameable> {
        public static final @NonNull NameableComparator INSTANCE = new NameableComparator();

        @Override
        public int compare(@NonNull Nameable o1, @NonNull Nameable o2) {
            String n1 = o1.getName();
            String n2 = o2.getName();
            return SerializationUtils.safeCompareTo(n1, n2);
        }
    }

    public static class NodeIterator
    implements Iterator<INode> {
        private @Nullable INode node;
        private boolean hasNext;
        private boolean childrenPending;

        public NodeIterator(@NonNull INode node) {
            this.node = node;
            this.hasNext = true;
            this.childrenPending = node instanceof ICompositeNode;
        }

        public NodeIterator(@NonNull NodeIterator nodeIterator) {
            this.node = nodeIterator.node;
            this.hasNext = nodeIterator.hasNext;
            this.childrenPending = nodeIterator.childrenPending;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            INode thisNode = this.node;
            if (thisNode == null) {
                return false;
            }
            INode nextNode = null;
            if (this.childrenPending) {
                nextNode = ((ICompositeNode)thisNode).getFirstChild();
                this.childrenPending = nextNode instanceof ICompositeNode;
            }
            if (nextNode == null) {
                nextNode = thisNode.getNextSibling();
                if (nextNode == null) {
                    nextNode = thisNode.getParent();
                    this.childrenPending = false;
                } else {
                    this.childrenPending = nextNode instanceof ICompositeNode;
                }
            }
            this.node = nextNode;
            this.hasNext = nextNode != null;
            return this.hasNext;
        }

        public boolean isChildrenPending() {
            assert (this.node instanceof ICompositeNode);
            return this.childrenPending;
        }

        @Override
        public @NonNull INode next() {
            this.hasNext = false;
            if (this.node != null) {
                return this.node;
            }
            throw new NoSuchElementException();
        }
    }

    public static class ToStringComparator<T>
    implements Comparator<T> {
        public static final @NonNull ToStringComparator<@NonNull Object> INSTANCE = new ToStringComparator(null);
        private final Map<@NonNull T, @NonNull String> object2string;

        public ToStringComparator() {
            this(new HashMap());
        }

        protected ToStringComparator(@Nullable Map<@NonNull T, @NonNull String> object2string) {
            this.object2string = object2string;
        }

        @Override
        public int compare(@NonNull T o1, @NonNull T o2) {
            String s2;
            String s1;
            if (this.object2string == null) {
                s1 = o1.toString();
                s2 = o2.toString();
            } else {
                s1 = this.getString(o1);
                s2 = this.getString(o2);
            }
            return SerializationUtils.safeCompareTo(s1, s2);
        }

        protected @NonNull String getString(@NonNull T o) {
            String string = SerializationUtils.maybeNull(this.object2string.get(o));
            if (string == null) {
                string = o.toString();
                if (string == null) {
                    string = "";
                }
                this.object2string.put(o, string);
            }
            return string;
        }
    }
}

