/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.actions;

import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ui.messages.ValidityUIMessages;
import org.eclipse.ocl.examples.emf.validation.validity.ui.plugin.ValidityUIPlugin;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public final class FilterValidationResultAction
extends Action
implements IMenuCreator {
    protected final @NonNull ValidityView validityView;
    private Action enableErrorNodesAction;
    private Action enableWarningNodesAction;
    private Action enableSuccessNodesAction;
    private Action enableInfoNodesAction;
    private Action enableFatalNodesAction;
    private MenuManager menuManager = new MenuManager();

    public FilterValidationResultAction(@NonNull ValidityView validityView) {
        super(ValidityUIMessages.ValidityView_Action_FilterResult_Title);
        this.validityView = validityView;
        this.setToolTipText(ValidityUIMessages.ValidityView_Action_FilterResult_ToolTipText);
        URL image = (URL)ValidityUIPlugin.INSTANCE.getImage(ValidityUIMessages.ValidityView_Action_FilterResult_ImageLocation);
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)image));
        this.setMenuCreator(this);
        this.enableFatalNodesAction = this.createFatalNodesFilterAction();
        this.enableErrorNodesAction = this.createErrorNodesFilterAction();
        this.enableWarningNodesAction = this.createWarningNodesFilterAction();
        this.enableInfoNodesAction = this.createInfoNodesFilterAction();
        this.enableSuccessNodesAction = this.createSuccessNodesFilterAction();
    }

    private Action createFatalNodesFilterAction() {
        String text = MessageFormat.format(ValidityUIMessages.ValidityView_Action_ShowNodesByKind_Title, ValidityUIMessages.ValidityView_Action_ShowNodesByKind_Kind_Failure);
        String toolTipText = ValidityUIMessages.ValidityView_Action_ShowFailedElementsNodes_ToolTipText;
        return new SwitchFilterAction(text, toolTipText, Severity.FATAL);
    }

    private Action createErrorNodesFilterAction() {
        String kind = ValidityUIMessages.ValidityView_Action_ShowNodesByKind_Kind_Error;
        String text = MessageFormat.format(ValidityUIMessages.ValidityView_Action_ShowNodesByKind_Title, kind);
        String toolTipText = MessageFormat.format(ValidityUIMessages.ValidityView_Action_ShowNodesByKind_ToolTipText, kind);
        return new SwitchFilterAction(text, toolTipText, Severity.ERROR);
    }

    private Action createWarningNodesFilterAction() {
        String kind = ValidityUIMessages.ValidityView_Action_ShowNodesByKind_Kind_Warning;
        String text = MessageFormat.format(ValidityUIMessages.ValidityView_Action_ShowNodesByKind_Title, kind);
        String toolTipText = MessageFormat.format(ValidityUIMessages.ValidityView_Action_ShowNodesByKind_ToolTipText, kind);
        return new SwitchFilterAction(text, toolTipText, Severity.WARNING);
    }

    private Action createInfoNodesFilterAction() {
        String kind = ValidityUIMessages.ValidityView_Action_ShowNodesByKind_Kind_Info;
        String text = MessageFormat.format(ValidityUIMessages.ValidityView_Action_ShowNodesByKind_Title, kind);
        String toolTipText = MessageFormat.format(ValidityUIMessages.ValidityView_Action_ShowNodesByKind_ToolTipText, kind);
        return new SwitchFilterAction(text, toolTipText, Severity.INFO);
    }

    private Action createSuccessNodesFilterAction() {
        String kind = ValidityUIMessages.ValidityView_Action_ShowNodesByKind_Kind_OK;
        String text = MessageFormat.format(ValidityUIMessages.ValidityView_Action_ShowNodesByKind_Title, kind);
        String toolTipText = MessageFormat.format(ValidityUIMessages.ValidityView_Action_ShowNodesByKind_ToolTipText, kind);
        return new SwitchFilterAction(text, toolTipText, Severity.OK);
    }

    public void dispose() {
        this.menuManager.dispose();
    }

    public Menu getMenu(Control parent) {
        if (this.menuManager.getMenu() == null) {
            this.menuManager.createContextMenu(parent);
        } else {
            this.menuManager.removeAll();
        }
        this.addActionToMenu((IAction)this.enableErrorNodesAction);
        this.addActionToMenu((IAction)this.enableInfoNodesAction);
        this.addActionToMenu((IAction)this.enableFatalNodesAction);
        this.addActionToMenu((IAction)this.enableWarningNodesAction);
        this.addActionToMenu((IAction)this.enableSuccessNodesAction);
        return this.menuManager.getMenu();
    }

    public Menu getMenu(Menu parent) {
        if (this.menuManager.getMenu() != null) {
            return this.menuManager.getMenu();
        }
        return null;
    }

    public void addActionToMenu(IAction action) {
        this.menuManager.add((IContributionItem)new ActionContributionItem(action));
    }

    private class SwitchFilterAction
    extends Action {
        private final @NonNull Severity severity;

        public SwitchFilterAction(String text, @NonNull String toolTipText, Severity acceptedSeverity) {
            super(text, 2);
            this.setToolTipText(toolTipText);
            this.severity = acceptedSeverity;
        }

        public void run() {
            if (this.isChecked()) {
                FilterValidationResultAction.this.validityView.addFilteredSeverity(this.severity);
            } else {
                FilterValidationResultAction.this.validityView.removeFilteredSeverity(this.severity);
            }
        }
    }
}

