/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.ocl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.ocl.EnvironmentFactory;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.ocl.OCLExpressionPicker;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.ocl.OCLExpressionWithContext;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.ocl.OCLTestExpressionContainer;
import org.eclipse.ocl.examples.impactanalyzer.util.OCL;
import org.eclipse.ocl.utilities.ExpressionInOCL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLExpressionFromClassTcsPicker
implements OCLExpressionPicker {
    public List<OCLExpressionWithContext> pickUpExpressions() {
        ArrayList<OCLExpressionWithContext> result = new ArrayList<OCLExpressionWithContext>();
        for (OCLTestExpressionContainer.OclExpressionWithPackage expression : OCLTestExpressionContainer.getExpressionList()) {
            result.add(this.parse(expression.getOcl(), expression.getPackage(), expression));
        }
        return result;
    }

    public OCLExpressionWithContext pickUpExpression(int index) {
        return this.parse(OCLTestExpressionContainer.getExpressionList().get(index).getOcl(), OCLTestExpressionContainer.getExpressionList().get(index).getPackage(), OCLTestExpressionContainer.getExpressionList().get(index));
    }

    protected OCLExpressionWithContext parse(String expression, EPackage basePackage, OCLTestExpressionContainer.OclExpressionWithPackage oclWithPackage) {
        OCLInput exp = new OCLInput(expression);
        String nsPrefix = basePackage.getNsPrefix();
        EPackage.Registry.INSTANCE.put((Object)nsPrefix, (Object)basePackage);
        ArrayList<String> path = new ArrayList<String>();
        path.add(nsPrefix);
        org.eclipse.ocl.ecore.OCL ocl = OCL.newInstance();
        ocl = org.eclipse.ocl.ecore.OCL.newInstance(new EnvironmentFactory().createPackageContext((Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)ocl.getEnvironment(), basePackage));
        OCLExpressionWithContext result = null;
        try {
            ExpressionInOCL specification = ((Constraint)ocl.parse(exp).iterator().next()).getSpecification();
            OCLExpression expr = (OCLExpression)specification.getBodyExpression();
            result = new OCLExpressionWithContext(expr, (EClass)specification.getContextVariable().getType(), oclWithPackage);
        }
        catch (ParserException e) {
            System.err.println("Error while parsing Expression:" + exp);
            e.printStackTrace();
            System.exit(0);
        }
        return result;
    }
}

