/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.ocl;

import behavioral.bpdm.BpdmPackage;
import behavioral.businesstasks.BusinesstasksPackage;
import behavioral.events.EventsPackage;
import behavioral.rules.RulesPackage;
import data.classes.ClassesPackage;
import data.constraints.ConstraintsPackage;
import data.documents.DocumentsPackage;
import data.generics.GenericsPackage;
import data.quantitystructure.QuantitystructurePackage;
import data.timedependency.TimedependencyPackage;
import data.tuples.TuplesPackage;
import dataaccess.analytics.AnalyticsPackage;
import dataaccess.expressions.ExpressionsPackage;
import dataaccess.expressions.fp.FpPackage;
import dataaccess.expressions.literals.LiteralsPackage;
import dataaccess.query.QueryPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.delegate.SettingBehavior;
import org.eclipse.ocl.ecore.delegate.ValidationBehavior;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.ocl.OCLExpressionPicker;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.ocl.OCLExpressionWithContext;
import org.eclipse.ocl.examples.impactanalyzer.util.OCL;
import persistence.actions.ActionsPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLExpressionFromModelPicker
implements OCLExpressionPicker {
    public List<OCLExpressionWithContext> pickUpExpressions() {
        return this.pickUpExpressions(new EPackage[]{ClassesPackage.eINSTANCE, ConstraintsPackage.eINSTANCE, DocumentsPackage.eINSTANCE, GenericsPackage.eINSTANCE, QuantitystructurePackage.eINSTANCE, TimedependencyPackage.eINSTANCE, TuplesPackage.eINSTANCE, AnalyticsPackage.eINSTANCE, ExpressionsPackage.eINSTANCE, FpPackage.eINSTANCE, LiteralsPackage.eINSTANCE, QueryPackage.eINSTANCE, behavioral.actions.ActionsPackage.eINSTANCE, BpdmPackage.eINSTANCE, BusinesstasksPackage.eINSTANCE, EventsPackage.eINSTANCE, RulesPackage.eINSTANCE, ActionsPackage.eINSTANCE, persistence.expressions.ExpressionsPackage.eINSTANCE});
    }

    public List<OCLExpressionWithContext> pickUpExpressions(EPackage ... packages) {
        ArrayList<OCLExpressionWithContext> expressionSet = new ArrayList<OCLExpressionWithContext>(this.searchAndParseExpressions(packages));
        return expressionSet;
    }

    private Collection<OCLExpressionWithContext> searchAndParseExpressions(EPackage ... ps) {
        HashSet<OCLExpressionWithContext> allConstraints = new HashSet<OCLExpressionWithContext>();
        EPackage[] ePackageArray = ps;
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage p = ePackageArray[n2];
            for (EClassifier c : p.getEClassifiers()) {
                if (!(c instanceof EClass)) continue;
                for (OCLExpression invariant : this.getInvariants((EClass)c)) {
                    allConstraints.add(new OCLExpressionWithContext(invariant, (EClass)c));
                }
                for (EAttribute at : ((EClass)c).getEAttributes()) {
                    EAnnotation a = OCLCommon.getDelegateAnnotation((EModelElement)at);
                    if (a == null) continue;
                    System.out.println("hurra");
                    allConstraints.add(new OCLExpressionWithContext(SettingBehavior.INSTANCE.getFeatureBody(OCL.newInstance(), (EStructuralFeature)at), (EClass)c));
                }
            }
            ++n2;
        }
        return allConstraints;
    }

    private Collection<OCLExpression> getInvariants(EClass c) {
        String spaceSeparatedConstraintNames;
        HashSet<OCLExpression> result = new HashSet<OCLExpression>();
        EAnnotation ann = c.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (ann != null && (spaceSeparatedConstraintNames = (String)ann.getDetails().get((Object)"constraints")) != null) {
            String[] constraintNames;
            String[] stringArray = constraintNames = spaceSeparatedConstraintNames.split(" ");
            int n = constraintNames.length;
            int n2 = 0;
            while (n2 < n) {
                String constraintName = stringArray[n2];
                OCLExpression invariant = ValidationBehavior.INSTANCE.getInvariant((EClassifier)c, constraintName, OCL.newInstance());
                result.add(invariant);
                ++n2;
            }
        }
        return result;
    }
}

