/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.data;

import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public class VMValueData
implements Serializable {
    private static final long serialVersionUID = 875965513717520820L;
    public static final int PRIMITIVE = 0;
    public static final int OBJECT_REF = 1;
    public static final int COLLECTION_REF = 2;
    public static final int INVALID = 3;
    public static final int RESOURCE = 4;
    public final int kind;
    public final @NonNull String value;
    public final boolean hasVariables;

    public static @NonNull VMValueData invalid() {
        return new VMValueData(3, "OclInvalid");
    }

    public static @NonNull String toValueString(int status) {
        switch (status) {
            case 0: {
                return "PRIMITIVE";
            }
            case 1: {
                return "OBJECT_REF";
            }
            case 2: {
                return "COLLECTION_REF";
            }
            case 3: {
                return "INVALID";
            }
            case 4: {
                return "RESOURCE";
            }
        }
        return "???";
    }

    public VMValueData(int kind, @NonNull String value) {
        this(kind, value, false);
    }

    public VMValueData(int kind, @NonNull String value, boolean hasVariables) {
        this.kind = kind;
        this.value = value;
        this.hasVariables = hasVariables;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + VMValueData.toValueString(this.kind) + ", " + this.value + ")";
    }
}

