/*******************************************************************************
 * Copyright (c) 2011, 2021 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
package org.eclipse.ocl.xtext.oclinecore.serializer;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.xtext.oclinecore.services.OCLinEcoreGrammarAccess;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.serializer.analysis.GrammarAlias.AbstractElementAlias;
import org.eclipse.xtext.serializer.analysis.GrammarAlias.AlternativeAlias;
import org.eclipse.xtext.serializer.analysis.GrammarAlias.GroupAlias;
import org.eclipse.xtext.serializer.analysis.GrammarAlias.TokenAlias;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider.ISynNavigable;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider.ISynTransition;
import org.eclipse.xtext.serializer.sequencer.AbstractSyntacticSequencer;

@SuppressWarnings("all")
public abstract class AbstractOCLinEcoreSyntacticSequencer extends AbstractSyntacticSequencer {

	protected OCLinEcoreGrammarAccess grammarAccess;
	protected AbstractElementAlias match_AttributeCS_CommaKeyword_5_1_1_q;
	protected AbstractElementAlias match_AttributeCS_SemicolonKeyword_6_1_or___LeftCurlyBracketKeyword_6_0_0_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___or___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4____a_RightCurlyBracketKeyword_6_0_2__;
	protected AbstractElementAlias match_AttributeCS_UnrestrictedNameParserRuleCall_6_0_1_1_1_q;
	protected AbstractElementAlias match_AttributeCS_UnrestrictedNameParserRuleCall_6_0_1_2_1_q;
	protected AbstractElementAlias match_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a__a;
	protected AbstractElementAlias match_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a;
	protected AbstractElementAlias match_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a___or_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a_SemicolonKeyword_6_0_1_2_4__q___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__p_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__p_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a__a__;
	protected AbstractElementAlias match_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a__a;
	protected AbstractElementAlias match_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a;
	protected AbstractElementAlias match_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a___or_____InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a_SemicolonKeyword_6_0_1_1_4__q___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__p_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__p_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a__a__;
	protected AbstractElementAlias match_AttributeCS___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a;
	protected AbstractElementAlias match_AttributeCS___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__p;
	protected AbstractElementAlias match_AttributeCS___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a;
	protected AbstractElementAlias match_AttributeCS___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__p;
	protected AbstractElementAlias match_AttributeCS_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___or___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4____a;
	protected AbstractElementAlias match_DataTypeCS_SemicolonKeyword_6_1_or___LeftCurlyBracketKeyword_6_0_0_RightCurlyBracketKeyword_6_0_2__;
	protected AbstractElementAlias match_DataTypeCS___LeftCurlyBracketKeyword_5_0_SerializableKeyword_5_1_1_q_RightCurlyBracketKeyword_5_2__q;
	protected AbstractElementAlias match_EnumerationCS_SemicolonKeyword_5_1_or___LeftCurlyBracketKeyword_5_0_0_RightCurlyBracketKeyword_5_0_2__;
	protected AbstractElementAlias match_EnumerationCS___LeftCurlyBracketKeyword_4_0_SerializableKeyword_4_1_1_q_RightCurlyBracketKeyword_4_2__q;
	protected AbstractElementAlias match_EnumerationLiteralCS_SemicolonKeyword_3_1_or___LeftCurlyBracketKeyword_3_0_0_RightCurlyBracketKeyword_3_0_2__;
	protected AbstractElementAlias match_ImplicitOppositeCS_CommaKeyword_4_1_1_q;
	protected AbstractElementAlias match_ImportCS_ImportKeyword_0_0_or_LibraryKeyword_0_1;
	protected AbstractElementAlias match_InvariantConstraintCS_SemicolonKeyword_3_1_or___ColonKeyword_3_0_0_SemicolonKeyword_3_0_2__;
	protected AbstractElementAlias match_MultiplicityCS_VerticalLineQuestionMarkKeyword_2_0_q;
	protected AbstractElementAlias match_OperationCS_CommaKeyword_9_1_1_q;
	protected AbstractElementAlias match_OperationCS_SemicolonKeyword_10_1_or___LeftCurlyBracketKeyword_10_0_0___BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2_SemicolonKeyword_10_0_1_2_4__a_RightCurlyBracketKeyword_10_0_2__;
	protected AbstractElementAlias match_OperationCS_UnrestrictedNameParserRuleCall_10_0_1_2_1_q;
	protected AbstractElementAlias match_OperationCS___BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2_SemicolonKeyword_10_0_1_2_4__a;
	protected AbstractElementAlias match_OperationCS___SemicolonKeyword_10_0_1_2_4_BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2__a;
	protected AbstractElementAlias match_OperationCS___SemicolonKeyword_10_0_1_2_4_BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2__p;
	protected AbstractElementAlias match_PackageCS_SemicolonKeyword_4_1_or___LeftCurlyBracketKeyword_4_0_0_RightCurlyBracketKeyword_4_0_2__;
	protected AbstractElementAlias match_ParameterCS_CommaKeyword_2_1_1_q;
	protected AbstractElementAlias match_ParameterCS___LeftCurlyBracketKeyword_3_0_RightCurlyBracketKeyword_3_2__q;
	protected AbstractElementAlias match_ReferenceCS_CommaKeyword_6_1_1_q;
	protected AbstractElementAlias match_ReferenceCS_SemicolonKeyword_7_1_or___LeftCurlyBracketKeyword_7_0_0_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___or___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4____a_RightCurlyBracketKeyword_7_0_2__;
	protected AbstractElementAlias match_ReferenceCS_UnrestrictedNameParserRuleCall_7_0_1_2_1_q;
	protected AbstractElementAlias match_ReferenceCS_UnrestrictedNameParserRuleCall_7_0_1_3_1_q;
	protected AbstractElementAlias match_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a__a;
	protected AbstractElementAlias match_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a;
	protected AbstractElementAlias match_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a___or_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a_SemicolonKeyword_7_0_1_3_4__q___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__p_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__p_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a__a__;
	protected AbstractElementAlias match_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a__a;
	protected AbstractElementAlias match_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a;
	protected AbstractElementAlias match_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a___or_____InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a_SemicolonKeyword_7_0_1_2_4__q___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__p_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__p_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a__a__;
	protected AbstractElementAlias match_ReferenceCS___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a;
	protected AbstractElementAlias match_ReferenceCS___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__p;
	protected AbstractElementAlias match_ReferenceCS___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a;
	protected AbstractElementAlias match_ReferenceCS___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__p;
	protected AbstractElementAlias match_ReferenceCS_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___or___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4____a;
	protected AbstractElementAlias match_StructuredClassCS_SemicolonKeyword_7_1_or___LeftCurlyBracketKeyword_7_0_0_RightCurlyBracketKeyword_7_0_2__;
	protected AbstractElementAlias match_StructuredClassCS___LeftCurlyBracketKeyword_6_0_RightCurlyBracketKeyword_6_2__q;
	protected AbstractElementAlias match_TopLevelCS___ModuleKeyword_1_0_UnrestrictedNameParserRuleCall_1_1__q;
	protected AbstractElementAlias match_TupleTypeCS___LeftParenthesisKeyword_1_0_RightParenthesisKeyword_1_2__q;

	@Inject
	protected void init(IGrammarAccess access) {
		grammarAccess = (OCLinEcoreGrammarAccess) access;
		match_AttributeCS_CommaKeyword_5_1_1_q = new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getCommaKeyword_5_1_1());
		match_AttributeCS_SemicolonKeyword_6_1_or___LeftCurlyBracketKeyword_6_0_0_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___or___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4____a_RightCurlyBracketKeyword_6_0_2__ = new AlternativeAlias(false, false, new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getLeftCurlyBracketKeyword_6_0_0()), new AlternativeAlias(true, true, new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4())), new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4()))), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getRightCurlyBracketKeyword_6_0_2())), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_1()));
		match_AttributeCS_UnrestrictedNameParserRuleCall_6_0_1_1_1_q = new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1());
		match_AttributeCS_UnrestrictedNameParserRuleCall_6_0_1_2_1_q = new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1());
		match_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4())));
		match_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4()));
		match_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a___or_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a_SemicolonKeyword_6_0_1_2_4__q___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__p_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__p_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a__a__ = new AlternativeAlias(false, false, new GroupAlias(false, false, new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2())), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4())), new GroupAlias(true, false, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4())), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2())), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4()), new GroupAlias(true, false, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4())), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2())))), new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()))));
		match_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4())));
		match_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4()));
		match_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a___or_____InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a_SemicolonKeyword_6_0_1_1_4__q___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__p_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__p_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a__a__ = new AlternativeAlias(false, false, new GroupAlias(false, false, new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2())), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4())), new GroupAlias(true, false, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4())), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2())), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4()), new GroupAlias(true, false, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4())), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2())))), new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()))));
		match_AttributeCS___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4())), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()));
		match_AttributeCS___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__p = new GroupAlias(true, false, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4())), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()));
		match_AttributeCS___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4())), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()));
		match_AttributeCS___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__p = new GroupAlias(true, false, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4())), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()));
		match_AttributeCS_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___or___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4____a = new AlternativeAlias(true, true, new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getDerivationKeyword_6_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_2_4())), new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getInitialKeyword_6_0_1_1_0()), new TokenAlias(false, true, grammarAccess.getAttributeCSAccess().getUnrestrictedNameParserRuleCall_6_0_1_1_1()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getColonKeyword_6_0_1_1_2()), new TokenAlias(false, false, grammarAccess.getAttributeCSAccess().getSemicolonKeyword_6_0_1_1_4())));
		match_DataTypeCS_SemicolonKeyword_6_1_or___LeftCurlyBracketKeyword_6_0_0_RightCurlyBracketKeyword_6_0_2__ = new AlternativeAlias(false, false, new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getDataTypeCSAccess().getLeftCurlyBracketKeyword_6_0_0()), new TokenAlias(false, false, grammarAccess.getDataTypeCSAccess().getRightCurlyBracketKeyword_6_0_2())), new TokenAlias(false, false, grammarAccess.getDataTypeCSAccess().getSemicolonKeyword_6_1()));
		match_DataTypeCS___LeftCurlyBracketKeyword_5_0_SerializableKeyword_5_1_1_q_RightCurlyBracketKeyword_5_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getDataTypeCSAccess().getLeftCurlyBracketKeyword_5_0()), new TokenAlias(false, true, grammarAccess.getDataTypeCSAccess().getSerializableKeyword_5_1_1()), new TokenAlias(false, false, grammarAccess.getDataTypeCSAccess().getRightCurlyBracketKeyword_5_2()));
		match_EnumerationCS_SemicolonKeyword_5_1_or___LeftCurlyBracketKeyword_5_0_0_RightCurlyBracketKeyword_5_0_2__ = new AlternativeAlias(false, false, new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getEnumerationCSAccess().getLeftCurlyBracketKeyword_5_0_0()), new TokenAlias(false, false, grammarAccess.getEnumerationCSAccess().getRightCurlyBracketKeyword_5_0_2())), new TokenAlias(false, false, grammarAccess.getEnumerationCSAccess().getSemicolonKeyword_5_1()));
		match_EnumerationCS___LeftCurlyBracketKeyword_4_0_SerializableKeyword_4_1_1_q_RightCurlyBracketKeyword_4_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getEnumerationCSAccess().getLeftCurlyBracketKeyword_4_0()), new TokenAlias(false, true, grammarAccess.getEnumerationCSAccess().getSerializableKeyword_4_1_1()), new TokenAlias(false, false, grammarAccess.getEnumerationCSAccess().getRightCurlyBracketKeyword_4_2()));
		match_EnumerationLiteralCS_SemicolonKeyword_3_1_or___LeftCurlyBracketKeyword_3_0_0_RightCurlyBracketKeyword_3_0_2__ = new AlternativeAlias(false, false, new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getEnumerationLiteralCSAccess().getLeftCurlyBracketKeyword_3_0_0()), new TokenAlias(false, false, grammarAccess.getEnumerationLiteralCSAccess().getRightCurlyBracketKeyword_3_0_2())), new TokenAlias(false, false, grammarAccess.getEnumerationLiteralCSAccess().getSemicolonKeyword_3_1()));
		match_ImplicitOppositeCS_CommaKeyword_4_1_1_q = new TokenAlias(false, true, grammarAccess.getImplicitOppositeCSAccess().getCommaKeyword_4_1_1());
		match_ImportCS_ImportKeyword_0_0_or_LibraryKeyword_0_1 = new AlternativeAlias(false, false, new TokenAlias(false, false, grammarAccess.getImportCSAccess().getImportKeyword_0_0()), new TokenAlias(false, false, grammarAccess.getImportCSAccess().getLibraryKeyword_0_1()));
		match_InvariantConstraintCS_SemicolonKeyword_3_1_or___ColonKeyword_3_0_0_SemicolonKeyword_3_0_2__ = new AlternativeAlias(false, false, new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getInvariantConstraintCSAccess().getColonKeyword_3_0_0()), new TokenAlias(false, false, grammarAccess.getInvariantConstraintCSAccess().getSemicolonKeyword_3_0_2())), new TokenAlias(false, false, grammarAccess.getInvariantConstraintCSAccess().getSemicolonKeyword_3_1()));
		match_MultiplicityCS_VerticalLineQuestionMarkKeyword_2_0_q = new TokenAlias(false, true, grammarAccess.getMultiplicityCSAccess().getVerticalLineQuestionMarkKeyword_2_0());
		match_OperationCS_CommaKeyword_9_1_1_q = new TokenAlias(false, true, grammarAccess.getOperationCSAccess().getCommaKeyword_9_1_1());
		match_OperationCS_SemicolonKeyword_10_1_or___LeftCurlyBracketKeyword_10_0_0___BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2_SemicolonKeyword_10_0_1_2_4__a_RightCurlyBracketKeyword_10_0_2__ = new AlternativeAlias(false, false, new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getLeftCurlyBracketKeyword_10_0_0()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getBodyKeyword_10_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getOperationCSAccess().getUnrestrictedNameParserRuleCall_10_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getColonKeyword_10_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getSemicolonKeyword_10_0_1_2_4())), new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getRightCurlyBracketKeyword_10_0_2())), new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getSemicolonKeyword_10_1()));
		match_OperationCS_UnrestrictedNameParserRuleCall_10_0_1_2_1_q = new TokenAlias(false, true, grammarAccess.getOperationCSAccess().getUnrestrictedNameParserRuleCall_10_0_1_2_1());
		match_OperationCS___BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2_SemicolonKeyword_10_0_1_2_4__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getBodyKeyword_10_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getOperationCSAccess().getUnrestrictedNameParserRuleCall_10_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getColonKeyword_10_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getSemicolonKeyword_10_0_1_2_4()));
		match_OperationCS___SemicolonKeyword_10_0_1_2_4_BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getSemicolonKeyword_10_0_1_2_4()), new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getBodyKeyword_10_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getOperationCSAccess().getUnrestrictedNameParserRuleCall_10_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getColonKeyword_10_0_1_2_2()));
		match_OperationCS___SemicolonKeyword_10_0_1_2_4_BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2__p = new GroupAlias(true, false, new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getSemicolonKeyword_10_0_1_2_4()), new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getBodyKeyword_10_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getOperationCSAccess().getUnrestrictedNameParserRuleCall_10_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getOperationCSAccess().getColonKeyword_10_0_1_2_2()));
		match_PackageCS_SemicolonKeyword_4_1_or___LeftCurlyBracketKeyword_4_0_0_RightCurlyBracketKeyword_4_0_2__ = new AlternativeAlias(false, false, new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getPackageCSAccess().getLeftCurlyBracketKeyword_4_0_0()), new TokenAlias(false, false, grammarAccess.getPackageCSAccess().getRightCurlyBracketKeyword_4_0_2())), new TokenAlias(false, false, grammarAccess.getPackageCSAccess().getSemicolonKeyword_4_1()));
		match_ParameterCS_CommaKeyword_2_1_1_q = new TokenAlias(false, true, grammarAccess.getParameterCSAccess().getCommaKeyword_2_1_1());
		match_ParameterCS___LeftCurlyBracketKeyword_3_0_RightCurlyBracketKeyword_3_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getParameterCSAccess().getLeftCurlyBracketKeyword_3_0()), new TokenAlias(false, false, grammarAccess.getParameterCSAccess().getRightCurlyBracketKeyword_3_2()));
		match_ReferenceCS_CommaKeyword_6_1_1_q = new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getCommaKeyword_6_1_1());
		match_ReferenceCS_SemicolonKeyword_7_1_or___LeftCurlyBracketKeyword_7_0_0_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___or___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4____a_RightCurlyBracketKeyword_7_0_2__ = new AlternativeAlias(false, false, new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getLeftCurlyBracketKeyword_7_0_0()), new AlternativeAlias(true, true, new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4())), new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4()))), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getRightCurlyBracketKeyword_7_0_2())), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_1()));
		match_ReferenceCS_UnrestrictedNameParserRuleCall_7_0_1_2_1_q = new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1());
		match_ReferenceCS_UnrestrictedNameParserRuleCall_7_0_1_3_1_q = new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1());
		match_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4())));
		match_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4()));
		match_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a___or_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a_SemicolonKeyword_7_0_1_3_4__q___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__p_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__p_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a__a__ = new AlternativeAlias(false, false, new GroupAlias(false, false, new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2())), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4())), new GroupAlias(true, false, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4())), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2())), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4()), new GroupAlias(true, false, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4())), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2())))), new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()))));
		match_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4())));
		match_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4()));
		match_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a___or_____InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a_SemicolonKeyword_7_0_1_2_4__q___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__p_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__p_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a__a__ = new AlternativeAlias(false, false, new GroupAlias(false, false, new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2())), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4())), new GroupAlias(true, false, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4())), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2())), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4()), new GroupAlias(true, false, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4())), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2())))), new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()))));
		match_ReferenceCS___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4())), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()));
		match_ReferenceCS___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__p = new GroupAlias(true, false, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4())), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()));
		match_ReferenceCS___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a = new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4())), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()));
		match_ReferenceCS___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__p = new GroupAlias(true, false, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4()), new GroupAlias(true, true, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4())), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()));
		match_ReferenceCS_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___or___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4____a = new AlternativeAlias(true, true, new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getDerivationKeyword_7_0_1_3_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_3_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_3_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_3_4())), new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getInitialKeyword_7_0_1_2_0()), new TokenAlias(false, true, grammarAccess.getReferenceCSAccess().getUnrestrictedNameParserRuleCall_7_0_1_2_1()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getColonKeyword_7_0_1_2_2()), new TokenAlias(false, false, grammarAccess.getReferenceCSAccess().getSemicolonKeyword_7_0_1_2_4())));
		match_StructuredClassCS_SemicolonKeyword_7_1_or___LeftCurlyBracketKeyword_7_0_0_RightCurlyBracketKeyword_7_0_2__ = new AlternativeAlias(false, false, new GroupAlias(false, false, new TokenAlias(false, false, grammarAccess.getStructuredClassCSAccess().getLeftCurlyBracketKeyword_7_0_0()), new TokenAlias(false, false, grammarAccess.getStructuredClassCSAccess().getRightCurlyBracketKeyword_7_0_2())), new TokenAlias(false, false, grammarAccess.getStructuredClassCSAccess().getSemicolonKeyword_7_1()));
		match_StructuredClassCS___LeftCurlyBracketKeyword_6_0_RightCurlyBracketKeyword_6_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getStructuredClassCSAccess().getLeftCurlyBracketKeyword_6_0()), new TokenAlias(false, false, grammarAccess.getStructuredClassCSAccess().getRightCurlyBracketKeyword_6_2()));
		match_TopLevelCS___ModuleKeyword_1_0_UnrestrictedNameParserRuleCall_1_1__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getTopLevelCSAccess().getModuleKeyword_1_0()), new TokenAlias(false, false, grammarAccess.getTopLevelCSAccess().getUnrestrictedNameParserRuleCall_1_1()));
		match_TupleTypeCS___LeftParenthesisKeyword_1_0_RightParenthesisKeyword_1_2__q = new GroupAlias(false, true, new TokenAlias(false, false, grammarAccess.getTupleTypeCSAccess().getLeftParenthesisKeyword_1_0()), new TokenAlias(false, false, grammarAccess.getTupleTypeCSAccess().getRightParenthesisKeyword_1_2()));
	}

	@Override
	protected String getUnassignedRuleCallToken(EObject semanticObject, RuleCall ruleCall, INode node) {
		if (ruleCall.getRule() == grammarAccess.getUnrestrictedNameRule())
			return getUnrestrictedNameToken(semanticObject, ruleCall, node);
		return "";
	}

	/**
	 * @Override
	 * UnrestrictedName returns ecore::EString:
	 * 	EnumerationLiteralName
	 * |	'annotation'
	 * |	'documentation'
	 * |	'invariant'
	 * |	'literal'
	 * |	'opposite'
	 * |	'serializable'
	 * |	'sysml'
	 * ;
	 */
	protected String getUnrestrictedNameToken(EObject semanticObject, RuleCall ruleCall, INode node) {
		if (node != null)
			return getTokenText(node);
		return "";
	}

	@Override
	protected void emitUnassignedTokens(EObject semanticObject, ISynTransition transition, INode fromNode, INode toNode) {
		if (transition.getAmbiguousSyntaxes().isEmpty()) return;
		List<INode> transitionNodes = collectNodes(fromNode, toNode);
		for (AbstractElementAlias syntax : transition.getAmbiguousSyntaxes()) {
			List<INode> syntaxNodes = getNodesFor(transitionNodes, syntax);
			if (match_AttributeCS_CommaKeyword_5_1_1_q.equals(syntax))
				emit_AttributeCS_CommaKeyword_5_1_1_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS_SemicolonKeyword_6_1_or___LeftCurlyBracketKeyword_6_0_0_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___or___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4____a_RightCurlyBracketKeyword_6_0_2__.equals(syntax))
				emit_AttributeCS_SemicolonKeyword_6_1_or___LeftCurlyBracketKeyword_6_0_0_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___or___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4____a_RightCurlyBracketKeyword_6_0_2__(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS_UnrestrictedNameParserRuleCall_6_0_1_1_1_q.equals(syntax))
				emit_AttributeCS_UnrestrictedNameParserRuleCall_6_0_1_1_1_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS_UnrestrictedNameParserRuleCall_6_0_1_2_1_q.equals(syntax))
				emit_AttributeCS_UnrestrictedNameParserRuleCall_6_0_1_2_1_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a__a.equals(syntax))
				emit_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a.equals(syntax))
				emit_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a___or_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a_SemicolonKeyword_6_0_1_2_4__q___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__p_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__p_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a__a__.equals(syntax))
				emit_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a___or_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a_SemicolonKeyword_6_0_1_2_4__q___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__p_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__p_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a__a__(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a__a.equals(syntax))
				emit_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a.equals(syntax))
				emit_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a___or_____InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a_SemicolonKeyword_6_0_1_1_4__q___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__p_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__p_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a__a__.equals(syntax))
				emit_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a___or_____InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a_SemicolonKeyword_6_0_1_1_4__q___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__p_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__p_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a__a__(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a.equals(syntax))
				emit_AttributeCS___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__p.equals(syntax))
				emit_AttributeCS___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__p(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a.equals(syntax))
				emit_AttributeCS___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__p.equals(syntax))
				emit_AttributeCS___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__p(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_AttributeCS_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___or___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4____a.equals(syntax))
				emit_AttributeCS_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___or___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4____a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_DataTypeCS_SemicolonKeyword_6_1_or___LeftCurlyBracketKeyword_6_0_0_RightCurlyBracketKeyword_6_0_2__.equals(syntax))
				emit_DataTypeCS_SemicolonKeyword_6_1_or___LeftCurlyBracketKeyword_6_0_0_RightCurlyBracketKeyword_6_0_2__(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_DataTypeCS___LeftCurlyBracketKeyword_5_0_SerializableKeyword_5_1_1_q_RightCurlyBracketKeyword_5_2__q.equals(syntax))
				emit_DataTypeCS___LeftCurlyBracketKeyword_5_0_SerializableKeyword_5_1_1_q_RightCurlyBracketKeyword_5_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_EnumerationCS_SemicolonKeyword_5_1_or___LeftCurlyBracketKeyword_5_0_0_RightCurlyBracketKeyword_5_0_2__.equals(syntax))
				emit_EnumerationCS_SemicolonKeyword_5_1_or___LeftCurlyBracketKeyword_5_0_0_RightCurlyBracketKeyword_5_0_2__(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_EnumerationCS___LeftCurlyBracketKeyword_4_0_SerializableKeyword_4_1_1_q_RightCurlyBracketKeyword_4_2__q.equals(syntax))
				emit_EnumerationCS___LeftCurlyBracketKeyword_4_0_SerializableKeyword_4_1_1_q_RightCurlyBracketKeyword_4_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_EnumerationLiteralCS_SemicolonKeyword_3_1_or___LeftCurlyBracketKeyword_3_0_0_RightCurlyBracketKeyword_3_0_2__.equals(syntax))
				emit_EnumerationLiteralCS_SemicolonKeyword_3_1_or___LeftCurlyBracketKeyword_3_0_0_RightCurlyBracketKeyword_3_0_2__(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ImplicitOppositeCS_CommaKeyword_4_1_1_q.equals(syntax))
				emit_ImplicitOppositeCS_CommaKeyword_4_1_1_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ImportCS_ImportKeyword_0_0_or_LibraryKeyword_0_1.equals(syntax))
				emit_ImportCS_ImportKeyword_0_0_or_LibraryKeyword_0_1(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_InvariantConstraintCS_SemicolonKeyword_3_1_or___ColonKeyword_3_0_0_SemicolonKeyword_3_0_2__.equals(syntax))
				emit_InvariantConstraintCS_SemicolonKeyword_3_1_or___ColonKeyword_3_0_0_SemicolonKeyword_3_0_2__(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_MultiplicityCS_VerticalLineQuestionMarkKeyword_2_0_q.equals(syntax))
				emit_MultiplicityCS_VerticalLineQuestionMarkKeyword_2_0_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_OperationCS_CommaKeyword_9_1_1_q.equals(syntax))
				emit_OperationCS_CommaKeyword_9_1_1_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_OperationCS_SemicolonKeyword_10_1_or___LeftCurlyBracketKeyword_10_0_0___BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2_SemicolonKeyword_10_0_1_2_4__a_RightCurlyBracketKeyword_10_0_2__.equals(syntax))
				emit_OperationCS_SemicolonKeyword_10_1_or___LeftCurlyBracketKeyword_10_0_0___BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2_SemicolonKeyword_10_0_1_2_4__a_RightCurlyBracketKeyword_10_0_2__(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_OperationCS_UnrestrictedNameParserRuleCall_10_0_1_2_1_q.equals(syntax))
				emit_OperationCS_UnrestrictedNameParserRuleCall_10_0_1_2_1_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_OperationCS___BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2_SemicolonKeyword_10_0_1_2_4__a.equals(syntax))
				emit_OperationCS___BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2_SemicolonKeyword_10_0_1_2_4__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_OperationCS___SemicolonKeyword_10_0_1_2_4_BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2__a.equals(syntax))
				emit_OperationCS___SemicolonKeyword_10_0_1_2_4_BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_OperationCS___SemicolonKeyword_10_0_1_2_4_BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2__p.equals(syntax))
				emit_OperationCS___SemicolonKeyword_10_0_1_2_4_BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2__p(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_PackageCS_SemicolonKeyword_4_1_or___LeftCurlyBracketKeyword_4_0_0_RightCurlyBracketKeyword_4_0_2__.equals(syntax))
				emit_PackageCS_SemicolonKeyword_4_1_or___LeftCurlyBracketKeyword_4_0_0_RightCurlyBracketKeyword_4_0_2__(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ParameterCS_CommaKeyword_2_1_1_q.equals(syntax))
				emit_ParameterCS_CommaKeyword_2_1_1_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ParameterCS___LeftCurlyBracketKeyword_3_0_RightCurlyBracketKeyword_3_2__q.equals(syntax))
				emit_ParameterCS___LeftCurlyBracketKeyword_3_0_RightCurlyBracketKeyword_3_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS_CommaKeyword_6_1_1_q.equals(syntax))
				emit_ReferenceCS_CommaKeyword_6_1_1_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS_SemicolonKeyword_7_1_or___LeftCurlyBracketKeyword_7_0_0_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___or___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4____a_RightCurlyBracketKeyword_7_0_2__.equals(syntax))
				emit_ReferenceCS_SemicolonKeyword_7_1_or___LeftCurlyBracketKeyword_7_0_0_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___or___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4____a_RightCurlyBracketKeyword_7_0_2__(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS_UnrestrictedNameParserRuleCall_7_0_1_2_1_q.equals(syntax))
				emit_ReferenceCS_UnrestrictedNameParserRuleCall_7_0_1_2_1_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS_UnrestrictedNameParserRuleCall_7_0_1_3_1_q.equals(syntax))
				emit_ReferenceCS_UnrestrictedNameParserRuleCall_7_0_1_3_1_q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a__a.equals(syntax))
				emit_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a.equals(syntax))
				emit_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a___or_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a_SemicolonKeyword_7_0_1_3_4__q___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__p_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__p_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a__a__.equals(syntax))
				emit_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a___or_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a_SemicolonKeyword_7_0_1_3_4__q___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__p_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__p_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a__a__(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a__a.equals(syntax))
				emit_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a.equals(syntax))
				emit_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a___or_____InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a_SemicolonKeyword_7_0_1_2_4__q___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__p_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__p_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a__a__.equals(syntax))
				emit_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a___or_____InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a_SemicolonKeyword_7_0_1_2_4__q___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__p_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__p_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a__a__(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a.equals(syntax))
				emit_ReferenceCS___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__p.equals(syntax))
				emit_ReferenceCS___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__p(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a.equals(syntax))
				emit_ReferenceCS___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__p.equals(syntax))
				emit_ReferenceCS___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__p(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_ReferenceCS_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___or___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4____a.equals(syntax))
				emit_ReferenceCS_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___or___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4____a(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_StructuredClassCS_SemicolonKeyword_7_1_or___LeftCurlyBracketKeyword_7_0_0_RightCurlyBracketKeyword_7_0_2__.equals(syntax))
				emit_StructuredClassCS_SemicolonKeyword_7_1_or___LeftCurlyBracketKeyword_7_0_0_RightCurlyBracketKeyword_7_0_2__(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_StructuredClassCS___LeftCurlyBracketKeyword_6_0_RightCurlyBracketKeyword_6_2__q.equals(syntax))
				emit_StructuredClassCS___LeftCurlyBracketKeyword_6_0_RightCurlyBracketKeyword_6_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_TopLevelCS___ModuleKeyword_1_0_UnrestrictedNameParserRuleCall_1_1__q.equals(syntax))
				emit_TopLevelCS___ModuleKeyword_1_0_UnrestrictedNameParserRuleCall_1_1__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else if (match_TupleTypeCS___LeftParenthesisKeyword_1_0_RightParenthesisKeyword_1_2__q.equals(syntax))
				emit_TupleTypeCS___LeftParenthesisKeyword_1_0_RightParenthesisKeyword_1_2__q(semanticObject, getLastNavigableState(), syntaxNodes);
			else acceptNodes(getLastNavigableState(), syntaxNodes);
		}
	}

	/**
	 * Ambiguous syntax:
	 *     ','?
	 *
	 * This ambiguous syntax occurs at:
	 *     (
	 *         qualifiers+='!derived'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!derived'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!id'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!id'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!ordered'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!ordered'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!readonly'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!readonly'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!transient'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!transient'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unique'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unique'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unsettable'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unsettable'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!volatile'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!volatile'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='derived'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='derived'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='id'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='id'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='ordered'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='ordered'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='readonly'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='readonly'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='transient'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='transient'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unique'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unique'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unsettable'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unsettable'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='volatile'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='volatile'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     qualifiers+='!derived' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!derived' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='id'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!id' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!id' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!id' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='id'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!id' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!ordered' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!ordered' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='id'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!readonly' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!readonly' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='id'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!transient' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!transient' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='id'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!unique' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!unique' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='id'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!unsettable' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!unsettable' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='id'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!volatile' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!volatile' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='id'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='derived' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='derived' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='id'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='id' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='id' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='id' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='id' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='id' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='id' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='id' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='id' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='id' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='id' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='id' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='id' (ambiguity) qualifiers+='id'
	 *     qualifiers+='id' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='id' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='id' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='id' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='id' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='id' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='ordered' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='ordered' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='id'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='readonly' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='readonly' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='id'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='transient' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='transient' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='id'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='unique' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='unique' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='id'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='unsettable' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='unsettable' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='id'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='volatile' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='volatile' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!id'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='id'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='volatile'
	 */
	protected void emit_AttributeCS_CommaKeyword_5_1_1_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';'
	 *
	 * This ambiguous syntax occurs at:
	 *     default=SINGLE_QUOTED_STRING (ambiguity) (rule end)
	 *     name=UnrestrictedName (ambiguity) (rule end)
	 *     ownedType=TypedMultiplicityRefCS (ambiguity) (rule end)
	 *     qualifiers+='!derived' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!id' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!ordered' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!readonly' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!transient' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!unique' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!unsettable' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!volatile' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='derived' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='id' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='ordered' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='readonly' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='transient' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='unique' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='unsettable' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='volatile' ','? '}' (ambiguity) (rule end)
	 */
	protected void emit_AttributeCS_SemicolonKeyword_6_1_or___LeftCurlyBracketKeyword_6_0_0_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___or___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4____a_RightCurlyBracketKeyword_6_0_2__(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     UnrestrictedName?
	 *
	 * This ambiguous syntax occurs at:
	 *     (
	 *         default=SINGLE_QUOTED_STRING
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         name=UnrestrictedName
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         ownedAnnotations+=AnnotationElementCS
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         ownedType=TypedMultiplicityRefCS
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!derived'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!id'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!ordered'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!readonly'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!transient'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unique'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unsettable'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!volatile'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='derived'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='id'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='ordered'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='readonly'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='transient'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unique'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unsettable'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='volatile'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 */
	protected void emit_AttributeCS_UnrestrictedNameParserRuleCall_6_0_1_1_1_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     UnrestrictedName?
	 *
	 * This ambiguous syntax occurs at:
	 *     (
	 *         default=SINGLE_QUOTED_STRING
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         name=UnrestrictedName
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         ownedAnnotations+=AnnotationElementCS
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         ownedType=TypedMultiplicityRefCS
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!derived'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!id'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!ordered'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!readonly'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!transient'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unique'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unsettable'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!volatile'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='derived'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='id'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='ordered'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='readonly'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='transient'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unique'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unsettable'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='volatile'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 */
	protected void emit_AttributeCS_UnrestrictedNameParserRuleCall_6_0_1_2_1_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('derivation' UnrestrictedName? ':' ';' ('initial' UnrestrictedName? ':' ';')*)*
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedDefaultExpressions+=SpecificationCS ';' ('initial' UnrestrictedName? ':' ';')* (ambiguity) '}' (rule end)
	 *     ownedDefaultExpressions+=SpecificationCS ';' ('initial' UnrestrictedName? ':' ';')* (ambiguity) ownedAnnotations+=AnnotationElementCS
	 */
	protected void emit_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('derivation' UnrestrictedName? ':' ';')*
	 *
	 * This ambiguous syntax occurs at:
	 *     default=SINGLE_QUOTED_STRING '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     name=UnrestrictedName '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ('initial' UnrestrictedName? ':' ';' (ambiguity))* '}' (rule end)
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ('initial' UnrestrictedName? ':' ';' (ambiguity))* ownedAnnotations+=AnnotationElementCS
	 *     ownedType=TypedMultiplicityRefCS '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!derived' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!id' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!ordered' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!readonly' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!transient' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unique' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unsettable' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!volatile' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='derived' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='id' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='ordered' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='readonly' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='transient' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unique' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unsettable' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='volatile' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (
	  *         ('derivation' UnrestrictedName? ':' (';' 'derivation' UnrestrictedName? ':')*) |
	  *         (
	  *             ('derivation' UnrestrictedName? ':' (';' 'derivation' UnrestrictedName? ':')* ';')?
	  *             ('initial' UnrestrictedName? ':' ';')+
	  *             'derivation'
	  *             UnrestrictedName?
	  *             ':'
	  *             (';' 'derivation' UnrestrictedName? ':')*
	  *             (
	  *                 ';'
	  *                 ('initial' UnrestrictedName? ':' ';')+
	  *                 'derivation'
	  *                 UnrestrictedName?
	  *                 ':'
	  *                 (';' 'derivation' UnrestrictedName? ':')*
	  *             )*
	  *         )
	  *     )
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_AttributeCS___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a___or_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a_SemicolonKeyword_6_0_1_2_4__q___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__p_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__p_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2___SemicolonKeyword_6_0_1_2_4_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a__a__(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('initial' UnrestrictedName? ':' ';' ('derivation' UnrestrictedName? ':' ';')*)*
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedDefaultExpressions+=SpecificationCS ';' ('derivation' UnrestrictedName? ':' ';')* (ambiguity) '}' (rule end)
	 *     ownedDefaultExpressions+=SpecificationCS ';' ('derivation' UnrestrictedName? ':' ';')* (ambiguity) ownedAnnotations+=AnnotationElementCS
	 */
	protected void emit_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('initial' UnrestrictedName? ':' ';')*
	 *
	 * This ambiguous syntax occurs at:
	 *     default=SINGLE_QUOTED_STRING '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     name=UnrestrictedName '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ('derivation' UnrestrictedName? ':' ';' (ambiguity))* '}' (rule end)
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ('derivation' UnrestrictedName? ':' ';' (ambiguity))* ownedAnnotations+=AnnotationElementCS
	 *     ownedType=TypedMultiplicityRefCS '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!derived' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!id' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!ordered' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!readonly' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!transient' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unique' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unsettable' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!volatile' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='derived' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='id' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='ordered' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='readonly' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='transient' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unique' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unsettable' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='volatile' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (
	  *         ('initial' UnrestrictedName? ':' (';' 'initial' UnrestrictedName? ':')*) |
	  *         (
	  *             ('initial' UnrestrictedName? ':' (';' 'initial' UnrestrictedName? ':')* ';')?
	  *             ('derivation' UnrestrictedName? ':' ';')+
	  *             'initial'
	  *             UnrestrictedName?
	  *             ':'
	  *             (';' 'initial' UnrestrictedName? ':')*
	  *             (
	  *                 ';'
	  *                 ('derivation' UnrestrictedName? ':' ';')+
	  *                 'initial'
	  *                 UnrestrictedName?
	  *                 ':'
	  *                 (';' 'initial' UnrestrictedName? ':')*
	  *             )*
	  *         )
	  *     )
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_AttributeCS___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a___or_____InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a_SemicolonKeyword_6_0_1_1_4__q___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__p_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__p_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2___SemicolonKeyword_6_0_1_1_4_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a__a__(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *
	 * This ambiguous syntax occurs at:
	 *     default=SINGLE_QUOTED_STRING '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     name=UnrestrictedName '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     ownedAnnotations+=AnnotationElementCS ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     ownedType=TypedMultiplicityRefCS '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!derived' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!id' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!ordered' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!readonly' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!transient' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unique' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unsettable' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!volatile' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='derived' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='id' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='ordered' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='readonly' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='transient' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unique' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unsettable' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='volatile' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_AttributeCS___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')+
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedDefaultExpressions+=SpecificationCS (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_AttributeCS___SemicolonKeyword_6_0_1_1_4___DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4__a_InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2__p(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *
	 * This ambiguous syntax occurs at:
	 *     default=SINGLE_QUOTED_STRING '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     name=UnrestrictedName '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     ownedAnnotations+=AnnotationElementCS ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     ownedType=TypedMultiplicityRefCS '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!derived' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!id' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!ordered' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!readonly' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!transient' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unique' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unsettable' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!volatile' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='derived' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='id' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='ordered' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='readonly' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='transient' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unique' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unsettable' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='volatile' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_AttributeCS___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')+
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedDefaultExpressions+=SpecificationCS (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_AttributeCS___SemicolonKeyword_6_0_1_2_4___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4__a_DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2__p(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))*
	 *
	 * This ambiguous syntax occurs at:
	 *     default=SINGLE_QUOTED_STRING '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     name=UnrestrictedName '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) '}' (rule end)
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedType=TypedMultiplicityRefCS '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!derived' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!id' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!ordered' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!readonly' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!transient' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!unique' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!unsettable' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!volatile' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='derived' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='id' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='ordered' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='readonly' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='transient' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='unique' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='unsettable' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='volatile' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 */
	protected void emit_AttributeCS_____DerivationKeyword_6_0_1_2_0_UnrestrictedNameParserRuleCall_6_0_1_2_1_q_ColonKeyword_6_0_1_2_2_SemicolonKeyword_6_0_1_2_4___or___InitialKeyword_6_0_1_1_0_UnrestrictedNameParserRuleCall_6_0_1_1_1_q_ColonKeyword_6_0_1_1_2_SemicolonKeyword_6_0_1_1_4____a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('{' '}') | ';'
	 *
	 * This ambiguous syntax occurs at:
	 *     instanceClassName=SINGLE_QUOTED_STRING ('{' '!serializable'? '}')? (ambiguity) (rule end)
	 *     isSerializable?='serializable' '}' (ambiguity) (rule end)
	 *     name=UnrestrictedName ('{' '!serializable'? '}')? (ambiguity) (rule end)
	 *     ownedSignature=TemplateSignatureCS ('{' '!serializable'? '}')? (ambiguity) (rule end)
	 */
	protected void emit_DataTypeCS_SemicolonKeyword_6_1_or___LeftCurlyBracketKeyword_6_0_0_RightCurlyBracketKeyword_6_0_2__(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('{' '!serializable'? '}')?
	 *
	 * This ambiguous syntax occurs at:
	 *     instanceClassName=SINGLE_QUOTED_STRING (ambiguity) '{' ownedAnnotations+=AnnotationElementCS
	 *     instanceClassName=SINGLE_QUOTED_STRING (ambiguity) '{' ownedConstraints+=InvariantConstraintCS
	 *     instanceClassName=SINGLE_QUOTED_STRING (ambiguity) (('{' '}') | ';') (rule end)
	 *     name=UnrestrictedName (ambiguity) '{' ownedAnnotations+=AnnotationElementCS
	 *     name=UnrestrictedName (ambiguity) '{' ownedConstraints+=InvariantConstraintCS
	 *     name=UnrestrictedName (ambiguity) (('{' '}') | ';') (rule end)
	 *     ownedSignature=TemplateSignatureCS (ambiguity) '{' ownedAnnotations+=AnnotationElementCS
	 *     ownedSignature=TemplateSignatureCS (ambiguity) '{' ownedConstraints+=InvariantConstraintCS
	 *     ownedSignature=TemplateSignatureCS (ambiguity) (('{' '}') | ';') (rule end)
	 */
	protected void emit_DataTypeCS___LeftCurlyBracketKeyword_5_0_SerializableKeyword_5_1_1_q_RightCurlyBracketKeyword_5_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('{' '}') | ';'
	 *
	 * This ambiguous syntax occurs at:
	 *     instanceClassName=SINGLE_QUOTED_STRING ('{' '!serializable'? '}')? (ambiguity) (rule end)
	 *     isSerializable?='serializable' '}' (ambiguity) (rule end)
	 *     name=UnrestrictedName ('{' '!serializable'? '}')? (ambiguity) (rule end)
	 *     ownedSignature=TemplateSignatureCS ('{' '!serializable'? '}')? (ambiguity) (rule end)
	 */
	protected void emit_EnumerationCS_SemicolonKeyword_5_1_or___LeftCurlyBracketKeyword_5_0_0_RightCurlyBracketKeyword_5_0_2__(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('{' '!serializable'? '}')?
	 *
	 * This ambiguous syntax occurs at:
	 *     instanceClassName=SINGLE_QUOTED_STRING (ambiguity) '{' ownedAnnotations+=AnnotationElementCS
	 *     instanceClassName=SINGLE_QUOTED_STRING (ambiguity) '{' ownedConstraints+=InvariantConstraintCS
	 *     instanceClassName=SINGLE_QUOTED_STRING (ambiguity) '{' ownedLiterals+=EnumerationLiteralCS
	 *     instanceClassName=SINGLE_QUOTED_STRING (ambiguity) (('{' '}') | ';') (rule end)
	 *     name=UnrestrictedName (ambiguity) '{' ownedAnnotations+=AnnotationElementCS
	 *     name=UnrestrictedName (ambiguity) '{' ownedConstraints+=InvariantConstraintCS
	 *     name=UnrestrictedName (ambiguity) '{' ownedLiterals+=EnumerationLiteralCS
	 *     name=UnrestrictedName (ambiguity) (('{' '}') | ';') (rule end)
	 *     ownedSignature=TemplateSignatureCS (ambiguity) '{' ownedAnnotations+=AnnotationElementCS
	 *     ownedSignature=TemplateSignatureCS (ambiguity) '{' ownedConstraints+=InvariantConstraintCS
	 *     ownedSignature=TemplateSignatureCS (ambiguity) '{' ownedLiterals+=EnumerationLiteralCS
	 *     ownedSignature=TemplateSignatureCS (ambiguity) (('{' '}') | ';') (rule end)
	 */
	protected void emit_EnumerationCS___LeftCurlyBracketKeyword_4_0_SerializableKeyword_4_1_1_q_RightCurlyBracketKeyword_4_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('{' '}') | ';'
	 *
	 * This ambiguous syntax occurs at:
	 *     literal=SINGLE_QUOTED_STRING (ambiguity) (rule end)
	 *     name=EnumerationLiteralName (ambiguity) (rule end)
	 *     name=UnrestrictedName (ambiguity) (rule end)
	 *     value=SIGNED (ambiguity) (rule end)
	 */
	protected void emit_EnumerationLiteralCS_SemicolonKeyword_3_1_or___LeftCurlyBracketKeyword_3_0_0_RightCurlyBracketKeyword_3_0_2__(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ','?
	 *
	 * This ambiguous syntax occurs at:
	 *     qualifiers+='!ordered' (ambiguity) '}' (rule end)
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!unique' (ambiguity) '}' (rule end)
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='ordered' (ambiguity) '}' (rule end)
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='unique' (ambiguity) '}' (rule end)
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='unique'
	 */
	protected void emit_ImplicitOppositeCS_CommaKeyword_4_1_1_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     'import' | 'library'
	 *
	 * This ambiguous syntax occurs at:
	 *     (rule start) (ambiguity) name=UnrestrictedName
	 *     (rule start) (ambiguity) ownedPathName=URIPathNameCS
	 */
	protected void emit_ImportCS_ImportKeyword_0_0_or_LibraryKeyword_0_1(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (':' ';') | ';'
	 *
	 * This ambiguous syntax occurs at:
	 *     name=UnrestrictedName (ambiguity) (rule end)
	 *     ownedMessageSpecification=SpecificationCS ')' (ambiguity) (rule end)
	 *     stereotype='invariant' (ambiguity) (rule end)
	 */
	protected void emit_InvariantConstraintCS_SemicolonKeyword_3_1_or___ColonKeyword_3_0_0_SemicolonKeyword_3_0_2__(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     '|?'?
	 *
	 * This ambiguous syntax occurs at:
	 *     lowerBound=LOWER (ambiguity) ']' (rule end)
	 *     stringBounds='*' (ambiguity) ']' (rule end)
	 *     stringBounds='+' (ambiguity) ']' (rule end)
	 *     stringBounds='?' (ambiguity) ']' (rule end)
	 *     upperBound=UPPER (ambiguity) ']' (rule end)
	 */
	protected void emit_MultiplicityCS_VerticalLineQuestionMarkKeyword_2_0_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ','?
	 *
	 * This ambiguous syntax occurs at:
	 *     qualifiers+='!derived' (ambiguity) '}' '{' 'body' UnrestrictedName? ':' (';' 'body' UnrestrictedName? ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='!derived' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!derived' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='!derived' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='!derived' (ambiguity) '}' (('{' ('body' UnrestrictedName? ':' ';')* '}') | ';') (rule end)
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!ordered' (ambiguity) '}' '{' 'body' UnrestrictedName? ':' (';' 'body' UnrestrictedName? ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='!ordered' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!ordered' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='!ordered' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='!ordered' (ambiguity) '}' (('{' ('body' UnrestrictedName? ':' ';')* '}') | ';') (rule end)
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!transient' (ambiguity) '}' '{' 'body' UnrestrictedName? ':' (';' 'body' UnrestrictedName? ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='!transient' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!transient' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='!transient' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='!transient' (ambiguity) '}' (('{' ('body' UnrestrictedName? ':' ';')* '}') | ';') (rule end)
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!unique' (ambiguity) '}' '{' 'body' UnrestrictedName? ':' (';' 'body' UnrestrictedName? ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='!unique' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!unique' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='!unique' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='!unique' (ambiguity) '}' (('{' ('body' UnrestrictedName? ':' ';')* '}') | ';') (rule end)
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='derived' (ambiguity) '}' '{' 'body' UnrestrictedName? ':' (';' 'body' UnrestrictedName? ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='derived' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='derived' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='derived' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='derived' (ambiguity) '}' (('{' ('body' UnrestrictedName? ':' ';')* '}') | ';') (rule end)
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='ordered' (ambiguity) '}' '{' 'body' UnrestrictedName? ':' (';' 'body' UnrestrictedName? ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='ordered' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='ordered' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='ordered' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='ordered' (ambiguity) '}' (('{' ('body' UnrestrictedName? ':' ';')* '}') | ';') (rule end)
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='transient' (ambiguity) '}' '{' 'body' UnrestrictedName? ':' (';' 'body' UnrestrictedName? ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='transient' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='transient' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='transient' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='transient' (ambiguity) '}' (('{' ('body' UnrestrictedName? ':' ';')* '}') | ';') (rule end)
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='unique' (ambiguity) '}' '{' 'body' UnrestrictedName? ':' (';' 'body' UnrestrictedName? ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='unique' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='unique' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='unique' (ambiguity) '}' '{' ('body' UnrestrictedName? ':' ';')* ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='unique' (ambiguity) '}' (('{' ('body' UnrestrictedName? ':' ';')* '}') | ';') (rule end)
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='unique'
	 */
	protected void emit_OperationCS_CommaKeyword_9_1_1_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('{' ('body' UnrestrictedName? ':' ';')* '}') | ';'
	 *
	 * This ambiguous syntax occurs at:
	 *     name=UnrestrictedName '(' ')' (ambiguity) (rule end)
	 *     ownedExceptions+=TypedRefCS (ambiguity) (rule end)
	 *     ownedParameters+=ParameterCS ')' (ambiguity) (rule end)
	 *     ownedType=TypedMultiplicityRefCS (ambiguity) (rule end)
	 *     qualifiers+='!derived' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!ordered' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!transient' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!unique' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='derived' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='ordered' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='transient' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='unique' ','? '}' (ambiguity) (rule end)
	 */
	protected void emit_OperationCS_SemicolonKeyword_10_1_or___LeftCurlyBracketKeyword_10_0_0___BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2_SemicolonKeyword_10_0_1_2_4__a_RightCurlyBracketKeyword_10_0_2__(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     UnrestrictedName?
	 *
	 * This ambiguous syntax occurs at:
	 *     name=UnrestrictedName '(' ')' '{' 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     ownedAnnotations+=AnnotationElementCS 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     ownedExceptions+=TypedRefCS '{' 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     ownedParameters+=ParameterCS ')' '{' 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     ownedPostconditions+=PostconditionConstraintCS 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     ownedPreconditions+=PreconditionConstraintCS 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     ownedType=TypedMultiplicityRefCS '{' 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='!derived' ','? '}' '{' 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='!ordered' ','? '}' '{' 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='!transient' ','? '}' '{' 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='!unique' ','? '}' '{' 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='derived' ','? '}' '{' 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='ordered' ','? '}' '{' 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='transient' ','? '}' '{' 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='unique' ','? '}' '{' 'body' (ambiguity) ':' (';' 'body' (ambiguity) ':')* ownedBodyExpressions+=SpecificationCS
	 */
	protected void emit_OperationCS_UnrestrictedNameParserRuleCall_10_0_1_2_1_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('body' UnrestrictedName? ':' ';')*
	 *
	 * This ambiguous syntax occurs at:
	 *     name=UnrestrictedName '(' ')' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     name=UnrestrictedName '(' ')' '{' (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     name=UnrestrictedName '(' ')' '{' (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) '}' (rule end)
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     ownedBodyExpressions+=SpecificationCS ';' (ambiguity) '}' (rule end)
	 *     ownedBodyExpressions+=SpecificationCS ';' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedBodyExpressions+=SpecificationCS ';' (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     ownedBodyExpressions+=SpecificationCS ';' (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     ownedExceptions+=TypedRefCS '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedExceptions+=TypedRefCS '{' (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     ownedExceptions+=TypedRefCS '{' (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     ownedParameters+=ParameterCS ')' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedParameters+=ParameterCS ')' '{' (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     ownedParameters+=ParameterCS ')' '{' (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     ownedPostconditions+=PostconditionConstraintCS (ambiguity) '}' (rule end)
	 *     ownedPostconditions+=PostconditionConstraintCS (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedPostconditions+=PostconditionConstraintCS (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     ownedPostconditions+=PostconditionConstraintCS (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     ownedPreconditions+=PreconditionConstraintCS (ambiguity) '}' (rule end)
	 *     ownedPreconditions+=PreconditionConstraintCS (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedPreconditions+=PreconditionConstraintCS (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     ownedPreconditions+=PreconditionConstraintCS (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     ownedType=TypedMultiplicityRefCS '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedType=TypedMultiplicityRefCS '{' (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     ownedType=TypedMultiplicityRefCS '{' (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='!derived' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!derived' ','? '}' '{' (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='!derived' ','? '}' '{' (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='!ordered' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!ordered' ','? '}' '{' (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='!ordered' ','? '}' '{' (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='!transient' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!transient' ','? '}' '{' (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='!transient' ','? '}' '{' (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='!unique' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!unique' ','? '}' '{' (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='!unique' ','? '}' '{' (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='derived' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='derived' ','? '}' '{' (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='derived' ','? '}' '{' (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='ordered' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='ordered' ','? '}' '{' (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='ordered' ','? '}' '{' (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='transient' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='transient' ','? '}' '{' (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='transient' ','? '}' '{' (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 *     qualifiers+='unique' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='unique' ','? '}' '{' (ambiguity) ownedPostconditions+=PostconditionConstraintCS
	 *     qualifiers+='unique' ','? '}' '{' (ambiguity) ownedPreconditions+=PreconditionConstraintCS
	 */
	protected void emit_OperationCS___BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2_SemicolonKeyword_10_0_1_2_4__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (';' 'body' UnrestrictedName? ':')*
	 *
	 * This ambiguous syntax occurs at:
	 *     name=UnrestrictedName '(' ')' '{' 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     ownedAnnotations+=AnnotationElementCS 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     ownedExceptions+=TypedRefCS '{' 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     ownedParameters+=ParameterCS ')' '{' 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     ownedPostconditions+=PostconditionConstraintCS 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     ownedPreconditions+=PreconditionConstraintCS 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     ownedType=TypedMultiplicityRefCS '{' 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='!derived' ','? '}' '{' 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='!ordered' ','? '}' '{' 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='!transient' ','? '}' '{' 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='!unique' ','? '}' '{' 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='derived' ','? '}' '{' 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='ordered' ','? '}' '{' 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='transient' ','? '}' '{' 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 *     qualifiers+='unique' ','? '}' '{' 'body' UnrestrictedName? ':' (ambiguity) ownedBodyExpressions+=SpecificationCS
	 */
	protected void emit_OperationCS___SemicolonKeyword_10_0_1_2_4_BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (';' 'body' UnrestrictedName? ':')+
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedBodyExpressions+=SpecificationCS (ambiguity) ownedBodyExpressions+=SpecificationCS
	 */
	protected void emit_OperationCS___SemicolonKeyword_10_0_1_2_4_BodyKeyword_10_0_1_2_0_UnrestrictedNameParserRuleCall_10_0_1_2_1_q_ColonKeyword_10_0_1_2_2__p(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('{' '}') | ';'
	 *
	 * This ambiguous syntax occurs at:
	 *     name=UnrestrictedName (ambiguity) (rule end)
	 *     nsPrefix=UnrestrictedName (ambiguity) (rule end)
	 *     nsURI=URI (ambiguity) (rule end)
	 */
	protected void emit_PackageCS_SemicolonKeyword_4_1_or___LeftCurlyBracketKeyword_4_0_0_RightCurlyBracketKeyword_4_0_2__(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ','?
	 *
	 * This ambiguous syntax occurs at:
	 *     qualifiers+='!ordered' (ambiguity) '}' '{' ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!ordered' (ambiguity) '}' ('{' '}')? (rule end)
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!unique' (ambiguity) '}' '{' ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!unique' (ambiguity) '}' ('{' '}')? (rule end)
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='ordered' (ambiguity) '}' '{' ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='ordered' (ambiguity) '}' ('{' '}')? (rule end)
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='unique' (ambiguity) '}' '{' ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='unique' (ambiguity) '}' ('{' '}')? (rule end)
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='unique'
	 */
	protected void emit_ParameterCS_CommaKeyword_2_1_1_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('{' '}')?
	 *
	 * This ambiguous syntax occurs at:
	 *     name=UnrestrictedName (ambiguity) (rule end)
	 *     ownedType=TypedMultiplicityRefCS (ambiguity) (rule end)
	 *     qualifiers+='!ordered' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!unique' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='ordered' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='unique' ','? '}' (ambiguity) (rule end)
	 */
	protected void emit_ParameterCS___LeftCurlyBracketKeyword_3_0_RightCurlyBracketKeyword_3_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ','?
	 *
	 * This ambiguous syntax occurs at:
	 *     (
	 *         qualifiers+='!composes'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!composes'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!derived'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!derived'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!ordered'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!ordered'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!readonly'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!readonly'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!resolve'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!resolve'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!transient'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!transient'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unique'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unique'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unsettable'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unsettable'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!volatile'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!volatile'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='composes'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='composes'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='derived'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='derived'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='ordered'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='ordered'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='readonly'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='readonly'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='resolve'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='resolve'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='transient'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='transient'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unique'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unique'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unsettable'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unsettable'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='volatile'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='volatile'
	 *         (ambiguity)
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         UnrestrictedName?
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     qualifiers+='!composes' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!composes' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!composes' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!composes' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!composes' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!derived' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!derived' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!derived' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!derived' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!derived' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!ordered' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!ordered' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!ordered' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!ordered' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!ordered' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!readonly' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!readonly' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!readonly' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!readonly' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!readonly' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!resolve' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!resolve' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!resolve' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!resolve' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!resolve' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!transient' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!transient' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!transient' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!transient' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!transient' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!unique' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!unique' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!unique' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!unique' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!unique' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!unsettable' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!unsettable' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!unsettable' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!unsettable' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!unsettable' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='!volatile' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!volatile' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!volatile' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!volatile' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='!volatile' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='composes' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='composes' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='composes' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='composes' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='composes' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='composes' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='derived' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='derived' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='derived' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='derived' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='derived' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='ordered' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='ordered' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='ordered' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='ordered' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='ordered' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='readonly' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='readonly' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='readonly' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='readonly' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='readonly' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='resolve' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='resolve' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='resolve' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='resolve' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='resolve' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='transient' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='transient' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='transient' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='transient' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='transient' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='unique' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='unique' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='unique' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='unique' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='unique' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='unsettable' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='unsettable' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='unsettable' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='unsettable' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='unsettable' (ambiguity) qualifiers+='volatile'
	 *     qualifiers+='volatile' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='volatile' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='volatile' (ambiguity) '}' '{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='volatile' (ambiguity) '}' (('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';') (rule end)
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!composes'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!derived'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!ordered'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!readonly'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!resolve'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!transient'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!unique'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!unsettable'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='!volatile'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='composes'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='derived'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='ordered'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='readonly'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='resolve'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='transient'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='unique'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='unsettable'
	 *     qualifiers+='volatile' (ambiguity) qualifiers+='volatile'
	 */
	protected void emit_ReferenceCS_CommaKeyword_6_1_1_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('{' (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))* '}') | ';'
	 *
	 * This ambiguous syntax occurs at:
	 *     default=SINGLE_QUOTED_STRING (ambiguity) (rule end)
	 *     name=UnrestrictedName (ambiguity) (rule end)
	 *     ownedType=TypedMultiplicityRefCS (ambiguity) (rule end)
	 *     qualifiers+='!composes' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!derived' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!ordered' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!readonly' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!resolve' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!transient' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!unique' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!unsettable' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='!volatile' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='composes' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='derived' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='ordered' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='readonly' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='resolve' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='transient' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='unique' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='unsettable' ','? '}' (ambiguity) (rule end)
	 *     qualifiers+='volatile' ','? '}' (ambiguity) (rule end)
	 *     referredOpposite=[Property|UnrestrictedName] (ambiguity) (rule end)
	 */
	protected void emit_ReferenceCS_SemicolonKeyword_7_1_or___LeftCurlyBracketKeyword_7_0_0_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___or___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4____a_RightCurlyBracketKeyword_7_0_2__(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     UnrestrictedName?
	 *
	 * This ambiguous syntax occurs at:
	 *     (
	 *         default=SINGLE_QUOTED_STRING
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         name=UnrestrictedName
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         ownedAnnotations+=AnnotationElementCS
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         ownedImplicitOpposites+=ImplicitOppositeCS
	 *         ';'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         ownedType=TypedMultiplicityRefCS
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!composes'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!derived'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!ordered'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!readonly'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!resolve'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!transient'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unique'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unsettable'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!volatile'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='composes'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='derived'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='ordered'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='readonly'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='resolve'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='transient'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unique'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unsettable'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='volatile'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         referredKeys+=[Property|UnrestrictedName]
	 *         ';'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         referredOpposite=[Property|UnrestrictedName]
	 *         '{'
	 *         ('derivation' UnrestrictedName? ':' ';')*
	 *         'initial'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 */
	protected void emit_ReferenceCS_UnrestrictedNameParserRuleCall_7_0_1_2_1_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     UnrestrictedName?
	 *
	 * This ambiguous syntax occurs at:
	 *     (
	 *         default=SINGLE_QUOTED_STRING
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         name=UnrestrictedName
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         ownedAnnotations+=AnnotationElementCS
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         ownedImplicitOpposites+=ImplicitOppositeCS
	 *         ';'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         ownedType=TypedMultiplicityRefCS
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!composes'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!derived'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!ordered'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!readonly'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!resolve'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!transient'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unique'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!unsettable'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='!volatile'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='composes'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='derived'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='ordered'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='readonly'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='resolve'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='transient'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unique'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='unsettable'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         qualifiers+='volatile'
	 *         ','?
	 *         '}'
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         referredKeys+=[Property|UnrestrictedName]
	 *         ';'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 *     (
	 *         referredOpposite=[Property|UnrestrictedName]
	 *         '{'
	 *         ('initial' UnrestrictedName? ':' ';')*
	 *         'derivation'
	 *         (ambiguity)
	 *         ':'
	 *         (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' (ambiguity) ':')*
	 *         ownedDefaultExpressions+=SpecificationCS
	 *     )
	 */
	protected void emit_ReferenceCS_UnrestrictedNameParserRuleCall_7_0_1_3_1_q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('derivation' UnrestrictedName? ':' ';' ('initial' UnrestrictedName? ':' ';')*)*
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedDefaultExpressions+=SpecificationCS ';' ('initial' UnrestrictedName? ':' ';')* (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     ownedDefaultExpressions+=SpecificationCS ';' ('initial' UnrestrictedName? ':' ';')* (ambiguity) '}' (rule end)
	 *     ownedDefaultExpressions+=SpecificationCS ';' ('initial' UnrestrictedName? ':' ';')* (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedDefaultExpressions+=SpecificationCS ';' ('initial' UnrestrictedName? ':' ';')* (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 */
	protected void emit_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('derivation' UnrestrictedName? ':' ';')*
	 *
	 * This ambiguous syntax occurs at:
	 *     default=SINGLE_QUOTED_STRING '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     name=UnrestrictedName '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ('initial' UnrestrictedName? ':' ';' (ambiguity))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ('initial' UnrestrictedName? ':' ';' (ambiguity))* '}' (rule end)
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ('initial' UnrestrictedName? ':' ';' (ambiguity))* ownedAnnotations+=AnnotationElementCS
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ('initial' UnrestrictedName? ':' ';' (ambiguity))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     ownedImplicitOpposites+=ImplicitOppositeCS ';' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     ownedType=TypedMultiplicityRefCS '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!composes' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!derived' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!ordered' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!readonly' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!resolve' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!transient' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unique' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unsettable' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!volatile' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='composes' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='derived' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='ordered' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='readonly' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='resolve' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='transient' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unique' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unsettable' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='volatile' ','? '}' '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     referredKeys+=[Property|UnrestrictedName] ';' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     referredOpposite=[Property|UnrestrictedName] '{' (ambiguity) 'initial' UnrestrictedName? ':' (';' (ambiguity) 'initial' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (
	  *         ('derivation' UnrestrictedName? ':' (';' 'derivation' UnrestrictedName? ':')*) |
	  *         (
	  *             ('derivation' UnrestrictedName? ':' (';' 'derivation' UnrestrictedName? ':')* ';')?
	  *             ('initial' UnrestrictedName? ':' ';')+
	  *             'derivation'
	  *             UnrestrictedName?
	  *             ':'
	  *             (';' 'derivation' UnrestrictedName? ':')*
	  *             (
	  *                 ';'
	  *                 ('initial' UnrestrictedName? ':' ';')+
	  *                 'derivation'
	  *                 UnrestrictedName?
	  *                 ':'
	  *                 (';' 'derivation' UnrestrictedName? ':')*
	  *             )*
	  *         )
	  *     )
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_ReferenceCS___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a___or_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a_SemicolonKeyword_7_0_1_3_4__q___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__p_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__p_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2___SemicolonKeyword_7_0_1_3_4_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a__a__(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('initial' UnrestrictedName? ':' ';' ('derivation' UnrestrictedName? ':' ';')*)*
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedDefaultExpressions+=SpecificationCS ';' ('derivation' UnrestrictedName? ':' ';')* (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     ownedDefaultExpressions+=SpecificationCS ';' ('derivation' UnrestrictedName? ':' ';')* (ambiguity) '}' (rule end)
	 *     ownedDefaultExpressions+=SpecificationCS ';' ('derivation' UnrestrictedName? ':' ';')* (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedDefaultExpressions+=SpecificationCS ';' ('derivation' UnrestrictedName? ':' ';')* (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 */
	protected void emit_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('initial' UnrestrictedName? ':' ';')*
	 *
	 * This ambiguous syntax occurs at:
	 *     default=SINGLE_QUOTED_STRING '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     name=UnrestrictedName '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ('derivation' UnrestrictedName? ':' ';' (ambiguity))* 'key' referredKeys+=[Property|UnrestrictedName]
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ('derivation' UnrestrictedName? ':' ';' (ambiguity))* '}' (rule end)
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ('derivation' UnrestrictedName? ':' ';' (ambiguity))* ownedAnnotations+=AnnotationElementCS
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ('derivation' UnrestrictedName? ':' ';' (ambiguity))* ownedImplicitOpposites+=ImplicitOppositeCS
	 *     ownedImplicitOpposites+=ImplicitOppositeCS ';' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     ownedType=TypedMultiplicityRefCS '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!composes' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!derived' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!ordered' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!readonly' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!resolve' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!transient' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unique' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unsettable' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!volatile' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='composes' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='derived' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='ordered' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='readonly' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='resolve' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='transient' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unique' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unsettable' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='volatile' ','? '}' '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     referredKeys+=[Property|UnrestrictedName] ';' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 *     referredOpposite=[Property|UnrestrictedName] '{' (ambiguity) 'derivation' UnrestrictedName? ':' (';' (ambiguity) 'derivation' UnrestrictedName? ':')* ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (
	  *         ('initial' UnrestrictedName? ':' (';' 'initial' UnrestrictedName? ':')*) |
	  *         (
	  *             ('initial' UnrestrictedName? ':' (';' 'initial' UnrestrictedName? ':')* ';')?
	  *             ('derivation' UnrestrictedName? ':' ';')+
	  *             'initial'
	  *             UnrestrictedName?
	  *             ':'
	  *             (';' 'initial' UnrestrictedName? ':')*
	  *             (
	  *                 ';'
	  *                 ('derivation' UnrestrictedName? ':' ';')+
	  *                 'initial'
	  *                 UnrestrictedName?
	  *                 ':'
	  *                 (';' 'initial' UnrestrictedName? ':')*
	  *             )*
	  *         )
	  *     )
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedDefaultExpressions+=SpecificationCS ';' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_ReferenceCS___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a___or_____InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a_SemicolonKeyword_7_0_1_2_4__q___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__p_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__p_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2___SemicolonKeyword_7_0_1_2_4_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a__a__(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')*
	 *
	 * This ambiguous syntax occurs at:
	 *     default=SINGLE_QUOTED_STRING '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     name=UnrestrictedName '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     ownedAnnotations+=AnnotationElementCS ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     ownedImplicitOpposites+=ImplicitOppositeCS ';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     ownedType=TypedMultiplicityRefCS '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!composes' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!derived' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!ordered' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!readonly' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!resolve' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!transient' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unique' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unsettable' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!volatile' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='composes' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='derived' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='ordered' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='readonly' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='resolve' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='transient' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unique' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unsettable' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='volatile' ','? '}' '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     referredKeys+=[Property|UnrestrictedName] ';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     referredOpposite=[Property|UnrestrictedName] '{' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_ReferenceCS___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (';' ('derivation' UnrestrictedName? ':' ';')* 'initial' UnrestrictedName? ':')+
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedDefaultExpressions+=SpecificationCS (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_ReferenceCS___SemicolonKeyword_7_0_1_2_4___DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4__a_InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2__p(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')*
	 *
	 * This ambiguous syntax occurs at:
	 *     default=SINGLE_QUOTED_STRING '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     name=UnrestrictedName '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     ownedAnnotations+=AnnotationElementCS ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     ownedImplicitOpposites+=ImplicitOppositeCS ';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     ownedType=TypedMultiplicityRefCS '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!composes' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!derived' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!ordered' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!readonly' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!resolve' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!transient' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unique' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!unsettable' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='!volatile' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='composes' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='derived' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='ordered' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='readonly' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='resolve' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='transient' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unique' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='unsettable' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     qualifiers+='volatile' ','? '}' '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     referredKeys+=[Property|UnrestrictedName] ';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 *     referredOpposite=[Property|UnrestrictedName] '{' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':' (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_ReferenceCS___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (';' ('initial' UnrestrictedName? ':' ';')* 'derivation' UnrestrictedName? ':')+
	 *
	 * This ambiguous syntax occurs at:
	 *     ownedDefaultExpressions+=SpecificationCS (ambiguity) ownedDefaultExpressions+=SpecificationCS
	 */
	protected void emit_ReferenceCS___SemicolonKeyword_7_0_1_3_4___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4__a_DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2__p(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     (('initial' UnrestrictedName? ':' ';') | ('derivation' UnrestrictedName? ':' ';'))*
	 *
	 * This ambiguous syntax occurs at:
	 *     default=SINGLE_QUOTED_STRING '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     default=SINGLE_QUOTED_STRING '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     default=SINGLE_QUOTED_STRING '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     name=UnrestrictedName '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     name=UnrestrictedName '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     name=UnrestrictedName '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) '}' (rule end)
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedAnnotations+=AnnotationElementCS (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     ownedImplicitOpposites+=ImplicitOppositeCS ';' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     ownedImplicitOpposites+=ImplicitOppositeCS ';' (ambiguity) '}' (rule end)
	 *     ownedImplicitOpposites+=ImplicitOppositeCS ';' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedImplicitOpposites+=ImplicitOppositeCS ';' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     ownedType=TypedMultiplicityRefCS '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     ownedType=TypedMultiplicityRefCS '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     ownedType=TypedMultiplicityRefCS '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!composes' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!composes' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!composes' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!derived' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!derived' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!derived' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!ordered' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!ordered' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!ordered' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!readonly' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!readonly' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!readonly' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!resolve' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!resolve' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!resolve' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!transient' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!transient' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!transient' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!unique' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!unique' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!unique' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!unsettable' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!unsettable' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!unsettable' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='!volatile' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='!volatile' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='!volatile' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='composes' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='composes' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='composes' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='derived' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='derived' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='derived' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='ordered' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='ordered' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='ordered' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='readonly' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='readonly' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='readonly' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='resolve' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='resolve' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='resolve' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='transient' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='transient' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='transient' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='unique' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='unique' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='unique' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='unsettable' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='unsettable' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='unsettable' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     qualifiers+='volatile' ','? '}' '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     qualifiers+='volatile' ','? '}' '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     qualifiers+='volatile' ','? '}' '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     referredKeys+=[Property|UnrestrictedName] ';' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     referredKeys+=[Property|UnrestrictedName] ';' (ambiguity) '}' (rule end)
	 *     referredKeys+=[Property|UnrestrictedName] ';' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     referredKeys+=[Property|UnrestrictedName] ';' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 *     referredOpposite=[Property|UnrestrictedName] '{' (ambiguity) 'key' referredKeys+=[Property|UnrestrictedName]
	 *     referredOpposite=[Property|UnrestrictedName] '{' (ambiguity) ownedAnnotations+=AnnotationElementCS
	 *     referredOpposite=[Property|UnrestrictedName] '{' (ambiguity) ownedImplicitOpposites+=ImplicitOppositeCS
	 */
	protected void emit_ReferenceCS_____DerivationKeyword_7_0_1_3_0_UnrestrictedNameParserRuleCall_7_0_1_3_1_q_ColonKeyword_7_0_1_3_2_SemicolonKeyword_7_0_1_3_4___or___InitialKeyword_7_0_1_2_0_UnrestrictedNameParserRuleCall_7_0_1_2_1_q_ColonKeyword_7_0_1_2_2_SemicolonKeyword_7_0_1_2_4____a(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('{' '}') | ';'
	 *
	 * This ambiguous syntax occurs at:
	 *     instanceClassName=SINGLE_QUOTED_STRING ('{' '}')? (ambiguity) (rule end)
	 *     isInterface?='interface' '}' (ambiguity) (rule end)
	 *     name=UnrestrictedName ('{' '}')? (ambiguity) (rule end)
	 *     ownedSignature=TemplateSignatureCS ('{' '}')? (ambiguity) (rule end)
	 *     ownedSuperTypes+=TypedRefCS ('{' '}')? (ambiguity) (rule end)
	 */
	protected void emit_StructuredClassCS_SemicolonKeyword_7_1_or___LeftCurlyBracketKeyword_7_0_0_RightCurlyBracketKeyword_7_0_2__(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('{' '}')?
	 *
	 * This ambiguous syntax occurs at:
	 *     instanceClassName=SINGLE_QUOTED_STRING (ambiguity) '{' ownedAnnotations+=AnnotationElementCS
	 *     instanceClassName=SINGLE_QUOTED_STRING (ambiguity) '{' ownedConstraints+=InvariantConstraintCS
	 *     instanceClassName=SINGLE_QUOTED_STRING (ambiguity) '{' ownedOperations+=OperationCS
	 *     instanceClassName=SINGLE_QUOTED_STRING (ambiguity) '{' ownedProperties+=StructuralFeatureCS
	 *     instanceClassName=SINGLE_QUOTED_STRING (ambiguity) (('{' '}') | ';') (rule end)
	 *     name=UnrestrictedName (ambiguity) '{' ownedAnnotations+=AnnotationElementCS
	 *     name=UnrestrictedName (ambiguity) '{' ownedConstraints+=InvariantConstraintCS
	 *     name=UnrestrictedName (ambiguity) '{' ownedOperations+=OperationCS
	 *     name=UnrestrictedName (ambiguity) '{' ownedProperties+=StructuralFeatureCS
	 *     name=UnrestrictedName (ambiguity) (('{' '}') | ';') (rule end)
	 *     ownedSignature=TemplateSignatureCS (ambiguity) '{' ownedAnnotations+=AnnotationElementCS
	 *     ownedSignature=TemplateSignatureCS (ambiguity) '{' ownedConstraints+=InvariantConstraintCS
	 *     ownedSignature=TemplateSignatureCS (ambiguity) '{' ownedOperations+=OperationCS
	 *     ownedSignature=TemplateSignatureCS (ambiguity) '{' ownedProperties+=StructuralFeatureCS
	 *     ownedSignature=TemplateSignatureCS (ambiguity) (('{' '}') | ';') (rule end)
	 *     ownedSuperTypes+=TypedRefCS (ambiguity) '{' ownedAnnotations+=AnnotationElementCS
	 *     ownedSuperTypes+=TypedRefCS (ambiguity) '{' ownedConstraints+=InvariantConstraintCS
	 *     ownedSuperTypes+=TypedRefCS (ambiguity) '{' ownedOperations+=OperationCS
	 *     ownedSuperTypes+=TypedRefCS (ambiguity) '{' ownedProperties+=StructuralFeatureCS
	 *     ownedSuperTypes+=TypedRefCS (ambiguity) (('{' '}') | ';') (rule end)
	 */
	protected void emit_StructuredClassCS___LeftCurlyBracketKeyword_6_0_RightCurlyBracketKeyword_6_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('module' UnrestrictedName)?
	 *
	 * This ambiguous syntax occurs at:
	 *     (rule start) (ambiguity) (rule start)
	 *     (rule start) (ambiguity) ownedImports+=ImportCS
	 *     (rule start) (ambiguity) ownedPackages+=PackageCS
	 */
	protected void emit_TopLevelCS___ModuleKeyword_1_0_UnrestrictedNameParserRuleCall_1_1__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

	/**
	 * Ambiguous syntax:
	 *     ('(' ')')?
	 *
	 * This ambiguous syntax occurs at:
	 *     name='Tuple' (ambiguity) (rule end)
	 *     name='Tuple' (ambiguity) ownedMultiplicity=MultiplicityCS
	 */
	protected void emit_TupleTypeCS___LeftParenthesisKeyword_1_0_RightParenthesisKeyword_1_2__q(EObject semanticObject, ISynNavigable transition, List<INode> nodes) {
		acceptNodes(transition, nodes);
	}

}
