/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.utilities;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UMLXMIID
extends UMLSwitch<String> {
    protected static final @NonNull Map<String, String> shortNames = new HashMap<String, String>();
    protected EcoreSwitch<String> ecoreSwitch = new EcoreSwitch<String>(){

        public String caseEAnnotation(EAnnotation object) {
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError();
            }
            StringBuilder s = new StringBuilder();
            UMLXMIID.this.appendPositionHierarchy(s, (EObject)object);
            return s.toString();
        }

        public String defaultCase(EObject object) {
            System.out.println("Unsupported UMLXMIID for '" + object.eClass().getName() + "'");
            return null;
        }
    };
    protected final @NonNull XMLResource resource;

    static {
        shortNames.put("defaultValue", "dlV");
        shortNames.put("eAnnotations", "eA");
        shortNames.put("generalization", "g");
        shortNames.put("lowerValue", "lV");
        shortNames.put("ownedComment", "oC");
        shortNames.put("ownedParameter", "oP");
        shortNames.put("ownedParameteredElement", "oPE");
        shortNames.put("ownedTemplateSignature", "oTS");
        shortNames.put("profileApplication", "pA");
        shortNames.put("upperValue", "uV");
    }

    public UMLXMIID(@NonNull XMLResource resource) {
        this.resource = resource;
    }

    protected void appendNameHierarchy(@NonNull StringBuilder s, @NonNull String prefix, @NonNull EObject object, @Nullable String name) {
        EObject container = object.eContainer();
        if (container instanceof NamedElement) {
            String id = (String)this.doSwitch(container);
            s.append(id);
            s.append(".");
        }
        s.append(prefix);
        s.append(String.valueOf(name));
    }

    protected void appendPositionHierarchy(@NonNull StringBuilder s, @NonNull EObject object) {
        EObject container = object.eContainer();
        assert (container != null);
        if (container instanceof NamedElement) {
            String id = (String)this.doSwitch(container);
            s.append(id);
            s.append(".");
        } else {
            this.appendPositionHierarchy(s, container);
            s.append(".");
        }
        EReference eContainmentFeature = object.eContainmentFeature();
        String name = eContainmentFeature.getName();
        String shortName = shortNames.get(name);
        s.append(shortName != null ? shortName : String.valueOf(name));
        if (eContainmentFeature.isMany()) {
            int index = ((List)container.eGet((EStructuralFeature)eContainmentFeature)).indexOf(object);
            s.append(index);
        }
    }

    public void assign() {
        HashMap<String, EObject> id2EObject = new HashMap<String, EObject>();
        TreeIterator tit = this.resource.getAllContents();
        while (tit.hasNext()) {
            EObject oldEObject;
            EObject eObject = (EObject)tit.next();
            String id = (String)this.doSwitch(eObject);
            if (id != null && (oldEObject = id2EObject.put(id, eObject)) != null) {
                System.out.println("Duplicate xmi:id " + id);
            }
            this.resource.setID(eObject, id);
        }
    }

    public String caseAssociation(Association object) {
        StringBuilder s;
        assert (object != null);
        String name = object.getName();
        if (name == null) {
            s = new StringBuilder();
            for (Property end : object.getMemberEnds()) {
                s.append("_");
                String endName = end.getName();
                if (endName != null) {
                    s.append(endName);
                    continue;
                }
                s.append(end.getType().getName());
            }
            name = s.toString();
        }
        s = new StringBuilder();
        this.appendNameHierarchy(s, name.startsWith("A_") ? "" : "A", (EObject)object, name);
        return s.toString();
    }

    public String caseComment(Comment object) {
        assert (object != null);
        StringBuilder s = new StringBuilder();
        this.appendPositionHierarchy(s, (EObject)object);
        return s.toString();
    }

    public String caseEnumerationLiteral(EnumerationLiteral object) {
        assert (object != null);
        StringBuilder s = new StringBuilder();
        this.appendNameHierarchy(s, "L", (EObject)object, object.getName());
        return s.toString();
    }

    public String caseOperation(Operation object) {
        assert (object != null);
        StringBuilder s = new StringBuilder();
        if (object.getOwningTemplateParameter() != null) {
            this.appendPositionHierarchy(s, (EObject)object);
        } else {
            this.appendNameHierarchy(s, "O", (EObject)object, object.getName());
            int iThis = 0;
            int iMax = 0;
            Element owner = object.getOwner();
            EList ownedOperations = null;
            if (owner instanceof Class) {
                ownedOperations = ((Class)owner).getOwnedOperations();
            } else if (owner instanceof Interface) {
                ownedOperations = ((Interface)owner).getOwnedOperations();
            }
            if (ownedOperations != null) {
                String name = object.getName();
                int i = 0;
                for (Operation op : ownedOperations) {
                    if (op == object) {
                        iThis = i;
                    }
                    if (name.equals(op.getName())) {
                        ++iMax;
                    }
                    ++i;
                }
            }
            if (iMax > 1) {
                s.append(".");
                s.append(iThis);
            }
        }
        return s.toString();
    }

    public String casePackage(Package object) {
        assert (object != null);
        StringBuilder s = new StringBuilder();
        this.appendNameHierarchy(s, "P", (EObject)object, object.getName());
        return s.toString();
    }

    public String caseParameter(Parameter object) {
        assert (object != null);
        StringBuilder s = new StringBuilder();
        this.appendNameHierarchy(s, "P", (EObject)object, object.getName());
        return s.toString();
    }

    public String caseProperty(Property object) {
        assert (object != null);
        StringBuilder s = new StringBuilder();
        this.appendNameHierarchy(s, "P", (EObject)object, object.getName());
        return s.toString();
    }

    public String caseRelationship(Relationship object) {
        assert (object != null);
        StringBuilder s = new StringBuilder();
        this.appendPositionHierarchy(s, (EObject)object);
        return s.toString();
    }

    public String caseTemplateParameter(TemplateParameter object) {
        assert (object != null);
        StringBuilder s = new StringBuilder();
        this.appendPositionHierarchy(s, (EObject)object);
        return s.toString();
    }

    public String caseTemplateSignature(TemplateSignature object) {
        assert (object != null);
        StringBuilder s = new StringBuilder();
        this.appendPositionHierarchy(s, (EObject)object);
        return s.toString();
    }

    public String caseType(Type object) {
        assert (object != null);
        StringBuilder s = new StringBuilder();
        if (object.getOwningTemplateParameter() != null) {
            this.appendPositionHierarchy(s, (EObject)object);
        } else {
            this.appendNameHierarchy(s, "T", (EObject)object, object.getName());
        }
        return s.toString();
    }

    public String caseValueSpecification(ValueSpecification object) {
        assert (object != null);
        StringBuilder s = new StringBuilder();
        this.appendPositionHierarchy(s, (EObject)object);
        return s.toString();
    }

    public String defaultCase(EObject object) {
        if (object.eClass().getEPackage() == EcorePackage.eINSTANCE) {
            return (String)this.ecoreSwitch.doSwitch(object);
        }
        if (object instanceof DynamicEObjectImpl) {
            return this.pseudoCaseDynamicEObjectImpl((DynamicEObjectImpl)object);
        }
        System.out.println("Unsupported UMLXMIID for '" + object.eClass().getName() + "'");
        return null;
    }

    protected String pseudoCaseDynamicEObjectImpl(@NonNull DynamicEObjectImpl object) {
        for (EStructuralFeature eFeature : object.eClass().getEStructuralFeatures()) {
            EObject eObject;
            if (!(eFeature instanceof EReference) || !eFeature.getName().startsWith("base_") || eFeature.isMany() || (eObject = (EObject)object.eGet(eFeature)) == null) continue;
            StringBuilder s = new StringBuilder();
            s.append("PA.");
            s.append((String)this.doSwitch(eObject));
            return s.toString();
        }
        System.out.println("Unsupported DUMLXMIID for '" + object.eClass().getName() + "'");
        return null;
    }
}

