/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.HTMLBuffer;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.SemanticException;
import org.eclipse.ocl.xtext.markup.MarkupToHTML;
import org.eclipse.ocl.xtext.markup.MarkupToString;
import org.eclipse.ocl.xtext.markup.MarkupToTree;
import org.eclipse.ocl.xtext.markup.MarkupUtils;
import org.eclipse.ocl.xtext.markupcs.Markup;
import org.eclipse.ocl.xtext.markupcs.MarkupElement;
import org.eclipse.ocl.xtext.markupcs.NewLineElement;

public class MarkupTests
extends XtextTestCase {
    @Override
    protected void setUp() throws Exception {
        TestUtil.doMarkupSetup();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected @NonNull OCLInternal createOCL() {
        return OCLInternal.newInstance((ProjectManager)OCL.NO_PROJECTS, null);
    }

    protected @NonNull Markup doDecode(@NonNull OCL ocl, @NonNull String testString) throws IOException {
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(testString, "UTF-8");
        ResourceSet resourceSet = ocl.getResourceSet();
        Resource resource = resourceSet.createResource(URI.createURI((String)"string.markupocl"));
        resource.load((InputStream)inputStream, null);
        Markup markup = (Markup)resource.getContents().get(0);
        EList parseErrors = resource.getErrors();
        StringBuilder s = null;
        for (Resource.Diagnostic parseError : parseErrors) {
            if (s == null) {
                s = new StringBuilder("Testing '" + this.toPrintable(testString) + "'");
            }
            String syntaxErrorMessage = parseError.getMessage();
            s.append("\n  " + syntaxErrorMessage);
        }
        if (s != null) {
            System.out.println(MarkupToTree.toString((MarkupElement)markup));
            MarkupTests.fail((String)s.toString());
        }
        return markup;
    }

    protected void doBadHtmlTest(@NonNull String testString, @NonNull Class<?> exceptionClass) throws Exception {
        OCLInternal ocl = this.createOCL();
        try {
            Markup markup = this.doDecode((OCL)ocl, testString);
            String testResult = MarkupToHTML.toString((EnvironmentFactoryInternal)ocl.getEnvironmentFactory(), null, (MarkupElement)markup);
            MarkupTests.fail((String)(String.valueOf(this.toPrintable(testString)) + " expected " + exceptionClass.getName()));
        }
        catch (Exception e) {
            MarkupTests.assertEquals((String)this.toPrintable(testString), exceptionClass, e.getClass());
            ocl.dispose();
        }
    }

    protected void doHtmlTest(Object context, @NonNull String expected, @NonNull String testString) throws Exception {
        OCLInternal ocl = this.createOCL();
        Markup markup = this.doDecode((OCL)ocl, testString);
        String testResult = MarkupToHTML.toString((EnvironmentFactoryInternal)ocl.getEnvironmentFactory(), (Object)context, (MarkupElement)markup);
        MarkupTests.assertEquals((String)this.toPrintable(testString), (String)expected, (String)testResult);
        ocl.dispose();
    }

    protected void doNewlineCountTest(int expectedCount, @NonNull String testString) throws IOException {
        OCLInternal ocl = this.createOCL();
        Markup markup = this.doDecode((OCL)ocl, testString);
        EList elements = markup.getElements();
        assert (elements.size() == 1);
        NewLineElement newLineElement = (NewLineElement)elements.get(0);
        assert (newLineElement != null);
        int actualCount = MarkupUtils.getNewlineCount((NewLineElement)newLineElement);
        if (expectedCount != actualCount) {
            MarkupTests.assertEquals((String)this.toPrintable(testString), (int)expectedCount, (int)actualCount);
        }
        ocl.dispose();
    }

    protected void doStringTest(@NonNull String testString) throws IOException {
        OCLInternal ocl = this.createOCL();
        Markup markup = this.doDecode((OCL)ocl, testString);
        String testResult = MarkupToString.toString((MarkupElement)markup);
        if (!testString.equals(testResult)) {
            String context = "Testing '" + this.toPrintable(testString) + "'\n";
            System.out.println(String.valueOf(context) + MarkupToTree.toString((MarkupElement)markup));
            MarkupTests.assertEquals((String)context, (String)testString, (String)testResult);
        }
        ocl.dispose();
    }

    protected String htmlEncode(@NonNull String string) {
        HTMLBuffer html = new HTMLBuffer();
        html.append(string);
        return html.toString();
    }

    protected String toPrintable(@NonNull String testString) {
        return testString.replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public void testFigures() throws Exception {
        this.doHtmlTest(null, "the <img src=\"x.png\"> title", "the figure[\"x.png\"] title");
        this.doHtmlTest(null, "the <img src=\"x.png\" alt=\"X\"> title", "the figure[\"x.png\",\"X\"] title");
        this.doHtmlTest(null, "the <img src=\"x.png\" alt=\"X\" width=\"22\"> title", "the figure[\"x.png\",\"X\",22] title");
    }

    public void testFigureRefs() throws Exception {
        this.doHtmlTest(null, "<a href=\"#FigName\"></a> <a name=\"FigName\"></a><img src=\"x.png\">", "figureRef[FigName] figure#FigName[\"x.png\"]");
        this.doBadHtmlTest("figureRef[FigName] figure#figname[\"x.png\"]", IllegalStateException.class);
    }

    public void testFonts() throws Exception {
        this.doHtmlTest(null, "a <b>c</b> d", "a b[c] d");
        this.doHtmlTest(null, "<b><i> g </i></b>", "b[e[ g ]]");
    }

    public void testFootnotes() throws Exception {
        this.doHtmlTest(null, "aa <footnote>xx\n<p>\nyy</footnote> bb", "aa footnote[xx\n\nyy] bb");
    }

    public void testHeadings() throws Exception {
        this.doHtmlTest(null, "<h1>xx</h1>", "heading[xx]");
        this.doHtmlTest(null, "<h4>xx</h4>", "heading:4[xx]");
        this.doHtmlTest(null, "<h2>xx <h3>yy</h3> zz</h2>", "heading:2[xx heading:3[yy] zz]");
    }

    public void testNewlines() throws IOException {
        this.doNewlineCountTest(1, "\r");
        this.doNewlineCountTest(1, "\n");
        this.doNewlineCountTest(1, "\n\r");
        this.doNewlineCountTest(1, "\r\n");
        this.doNewlineCountTest(2, "\n\t\r");
        this.doNewlineCountTest(2, "\r\t\n");
        this.doNewlineCountTest(2, "\n\r\n");
        this.doNewlineCountTest(2, "\r\n\r");
        this.doNewlineCountTest(2, "\n\r\n");
        this.doNewlineCountTest(2, "\r\n\r");
        this.doNewlineCountTest(2, "\n\r\n\r");
        this.doNewlineCountTest(2, "\r\n\r\n");
        this.doNewlineCountTest(2, "\n\r\n\r");
        this.doNewlineCountTest(2, "\r\n\r\n");
        this.doNewlineCountTest(2, "\n\r \n\r");
        this.doNewlineCountTest(2, "\r\n \r\n");
        this.doNewlineCountTest(2, "\n\r \n\r");
        this.doNewlineCountTest(2, "\r\n \r\n");
        this.doNewlineCountTest(3, "\n\r\n \r");
        this.doNewlineCountTest(3, "\r\n\r \n");
        this.doNewlineCountTest(3, "\n\r\n \r");
        this.doNewlineCountTest(3, "\r\n\r \n");
    }

    public void testOCLEval() throws Exception {
        this.doHtmlTest(null, "45", "oclEval[5*9]");
        this.doHtmlTest(EcorePackage.Literals.EBIG_DECIMAL, "EBigDecimal", "oclEval[self.name]");
        this.doHtmlTest(null, "true", "oclEval[null->isEmpty()]");
        this.doHtmlTest(null, "true", "oclEval[null->isEmpty()]");
    }

    public void testOCLText() throws Exception {
        this.doHtmlTest(null, "<tt>" + this.htmlEncode("null->isEmpty()") + "</tt>", "oclText[null->isEmpty()]");
        this.doBadHtmlTest("oclText[null->isBad()]", SemanticException.class);
    }

    public void testStrings() throws IOException {
        this.doStringTest("a b[c] d");
        this.doStringTest("a\rb\n\rc\t\nd");
        this.doStringTest("oclEval[a.c[4]]");
        this.doStringTest("oclEval[a.b[4]]");
        this.doStringTest("\\[1234\\]");
    }
}

