/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.utilities;

import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ThreadLocalExecutorUI
extends ThreadLocalExecutor
implements IPartListener {
    private static final @Nullable ThreadLocalExecutor NOT_A_PART_THREAD = null;
    private @Nullable ThreadLocalExecutor initPartThread = null;
    private @Nullable ThreadLocalExecutor activatedPartThread = NOT_A_PART_THREAD;
    private @Nullable ThreadLocalExecutor activePartThread = NOT_A_PART_THREAD;
    protected final @NonNull Map<@NonNull IWorkbenchPart, @NonNull ThreadLocalExecutor> part2partThread = new WeakHashMap<IWorkbenchPart, ThreadLocalExecutor>();

    public static @Nullable ThreadLocalExecutor basicGetPartThread() {
        ThreadLocalExecutor threadLocalExecutor = ThreadLocalExecutorUI.get();
        if (threadLocalExecutor instanceof ThreadLocalExecutorUI) {
            return ((ThreadLocalExecutorUI)threadLocalExecutor).activePartThread;
        }
        return null;
    }

    public static void closeEditors() {
        ThreadLocalExecutor threadLocalExecutor = ThreadLocalExecutorUI.get();
        ((ThreadLocalExecutorUI)threadLocalExecutor).localCloseEditors();
    }

    public static void init(@NonNull IWorkbenchPart initPart, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ThreadLocalExecutor.InitWrapperCallBack<?, ?> callBack) {
        ThreadLocalExecutor threadLocalExecutor = ThreadLocalExecutorUI.get();
        ((ThreadLocalExecutorUI)threadLocalExecutor).localInit(initPart, callBack);
    }

    public static void init(@NonNull ThreadLocalExecutor initPartThread, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ThreadLocalExecutor.InitWrapperCallBack<?, ?> callBack, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ThreadLocalExecutor.NeedsInit needsInit) {
        ThreadLocalExecutor threadLocalExecutor = ThreadLocalExecutorUI.get();
        threadLocalExecutor.localInit(initPartThread, callBack, needsInit);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ThreadLocalExecutor.NeedsInit needsInit(@NonNull ThreadLocalExecutor partThread) {
        ThreadLocalExecutor threadLocalExecutor = ThreadLocalExecutorUI.get();
        if (!(threadLocalExecutor instanceof ThreadLocalExecutorUI)) {
            return ThreadLocalExecutor.NeedsInit.ATTACH_FROM_PART_THREAD;
        }
        if (((ThreadLocalExecutorUI)threadLocalExecutor).activePartThread == partThread) {
            return ThreadLocalExecutor.NeedsInit.AS_IS;
        }
        return ThreadLocalExecutor.NeedsInit.WRAP_WITH_PART_THREAD;
    }

    protected @NonNull ThreadLocalExecutor createInstance() {
        IPartService partService;
        if (Display.getCurrent() == null) {
            return super.createInstance();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (partService = activeWorkbenchWindow.getPartService()) != null) {
            partService.addPartListener((IPartListener)this);
            IWorkbenchPart activePart = partService.getActivePart();
            if (activePart != null) {
                this.partActivated(activePart);
            }
        }
        return this;
    }

    protected synchronized @NonNull ThreadLocalExecutor getPartThread(@NonNull IWorkbenchPart part) {
        ThreadLocalExecutor partThread = this.part2partThread.get(part);
        if (partThread == null) {
            String threadName = "[" + Thread.currentThread().getName() + ":" + NameUtil.debugSimpleName((Object)part) + "]";
            partThread = new ThreadLocalExecutor(threadName){};
            this.part2partThread.put(part, partThread);
        }
        return partThread;
    }

    protected @NonNull String getThreadName() {
        StringBuilder s = new StringBuilder();
        if (this.activatedPartThread != null) {
            s.append(this.activatedPartThread.getName());
        } else {
            s.append("[");
            s.append(Thread.currentThread().getName());
            s.append("]");
        }
        return s.toString();
    }

    public void localAttachEnvironmentFactory(@NonNull EnvironmentFactoryInternal newEnvironmentFactory) {
        if (this.activePartThread != null) {
            this.activePartThread.localAttachEnvironmentFactory(newEnvironmentFactory);
        } else {
            super.localAttachEnvironmentFactory(newEnvironmentFactory);
        }
    }

    public @Nullable EnvironmentFactoryInternal localBasicGetEnvironmentFactory() {
        if (this.activePartThread != null) {
            return this.activePartThread.localBasicGetEnvironmentFactory();
        }
        return super.localBasicGetEnvironmentFactory();
    }

    public @Nullable Executor localBasicGetExecutor() {
        if (this.activePartThread != null) {
            return this.activePartThread.localBasicGetExecutor();
        }
        return super.localBasicGetExecutor();
    }

    public void localDetachEnvironmentFactory(@NonNull EnvironmentFactory environmentFactory) {
        if (this.activePartThread != null) {
            this.activePartThread.localDetachEnvironmentFactory(environmentFactory);
        } else {
            super.localDetachEnvironmentFactory(environmentFactory);
        }
    }

    private void localCloseEditors() {
        assert (this.initPartThread == null);
        for (IWorkbenchPart part : new ArrayList<IWorkbenchPart>(this.part2partThread.keySet())) {
            if (!(part instanceof IEditorPart)) continue;
            IEditorPart editorPart = (IEditorPart)part;
            editorPart.getSite().getPage().closeEditor(editorPart, false);
        }
    }

    public void localInit(@NonNull IWorkbenchPart initPart, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ThreadLocalExecutor.InitWrapperCallBack<?, ?> callBack) {
        ThreadLocalExecutor initPartThread = this.getPartThread(initPart);
        this.localInit(initPartThread, callBack, ThreadLocalExecutor.NeedsInit.WRAP_WITH_PART_THREAD);
    }

    public void localInit(@NonNull ThreadLocalExecutor initPartThread, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ThreadLocalExecutor.InitWrapperCallBack<?, ?> callBack, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ThreadLocalExecutor.NeedsInit needsInit) {
        if (needsInit == ThreadLocalExecutor.NeedsInit.WRAP_WITH_PART_THREAD) {
            assert (this.activePartThread == this.activatedPartThread);
            ThreadLocalExecutor savedActivePartThread = this.activePartThread;
            this.activePartThread = this.initPartThread = initPartThread;
            callBack.run();
            this.initPartThread = null;
            this.activePartThread = savedActivePartThread;
        } else {
            super.localInit(initPartThread, callBack, needsInit);
        }
    }

    public void localRemoveEnvironmentFactory() {
        if (this.activePartThread != null) {
            this.activePartThread.localRemoveEnvironmentFactory();
        } else {
            super.localRemoveEnvironmentFactory();
        }
    }

    public synchronized void localReset() {
        if (this.activePartThread != null) {
            this.activePartThread.localReset();
        } else {
            super.localReset();
        }
    }

    public void localSetExecutor(@Nullable Executor executor) {
        if (this.activePartThread != null) {
            this.activePartThread.localSetExecutor(executor);
        } else {
            super.localSetExecutor(executor);
        }
    }

    public void partActivated(IWorkbenchPart newActivePart) {
        assert (this.initPartThread == null);
        assert (newActivePart != null);
        ThreadLocalExecutor newPartThread = this.getPartThread(newActivePart);
        assert (newPartThread != null);
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " partActivated [" + Thread.currentThread().getName() + ":" + NameUtil.debugSimpleName((Object)newActivePart) + "] " + this.toString());
        }
        this.activatedPartThread = newPartThread;
        this.activePartThread = newPartThread;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        assert (this.initPartThread == null);
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " partBroughtToTop [" + Thread.currentThread().getName() + ":" + NameUtil.debugSimpleName((Object)part) + "] " + this.toString());
        }
    }

    public void partClosed(IWorkbenchPart oldOpenPart) {
        assert (this.initPartThread == null);
        assert (oldOpenPart != null);
        assert (oldOpenPart != this.activatedPartThread);
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " partClosed [" + Thread.currentThread().getName() + ":" + NameUtil.debugSimpleName((Object)oldOpenPart) + "] " + this.toString());
        }
        ThreadLocalExecutor oldPartThread = this.part2partThread.remove(oldOpenPart);
        this.activePartThread = this.activatedPartThread;
    }

    public void partDeactivated(IWorkbenchPart oldActivePart) {
        assert (this.initPartThread == null);
        assert (oldActivePart != null);
        if (this.activePartThread != NOT_A_PART_THREAD) assert (this.activePartThread == this.part2partThread.get(oldActivePart));
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " partDeactivated [" + Thread.currentThread().getName() + ":" + NameUtil.debugSimpleName((Object)oldActivePart) + "] " + this.toString());
        }
        this.activatedPartThread = NOT_A_PART_THREAD;
        this.activePartThread = NOT_A_PART_THREAD;
    }

    public void partOpened(IWorkbenchPart newOpenPart) {
        assert (newOpenPart != null);
        assert (this.initPartThread == null);
        this.getPartThread(newOpenPart);
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " partOpened [" + Thread.currentThread().getName() + ":" + NameUtil.debugSimpleName((Object)newOpenPart) + "] " + this.toString());
        }
    }

    public void setEnvironmentFactory(@Nullable EnvironmentFactoryInternal newEnvironmentFactory) {
        assert (this.initPartThread == null);
        if (this.activePartThread != null) {
            this.activePartThread.setEnvironmentFactory(newEnvironmentFactory);
        } else {
            super.setEnvironmentFactory(newEnvironmentFactory);
        }
    }
}

