/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.uml.internal.UMLForeignMethods;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLUMLUtil
extends UMLUtil {
    public static final String PLUGIN_ID = "org.eclipse.ocl.uml";

    private OCLUMLUtil() {
    }

    public static List<Reception> getAllReceptions(Class clazz) {
        BasicEList.FastCompare result = new BasicEList.FastCompare();
        for (NamedElement m : OCLUMLUtil.getInheritedMembers((Classifier)clazz)) {
            if (!(m instanceof Reception)) continue;
            result.add((Reception)m);
        }
        return result;
    }

    public static Class getMetaclass(Element element) {
        Class result = null;
        ResourceSet rset = null;
        Resource res = element.eResource();
        if (res != null) {
            rset = res.getResourceSet();
        }
        if (rset != null) {
            result = (Class)OCLUMLUtil.getClassifier((EClassifier)element.eClass(), rset);
        }
        return result;
    }

    public static Classifier getClassifier(EClassifier eclassifier, ResourceSet rset) {
        Classifier result = null;
        EPackage epackage = eclassifier.getEPackage();
        Profile profile = OCLUMLUtil.getProfile((EPackage)epackage);
        if (profile != null) {
            NamedElement ne = OCLUMLUtil.getNamedElement((ENamedElement)eclassifier);
            if (ne instanceof Classifier) {
                result = (Classifier)ne;
            }
        } else {
            Package umlPackage = null;
            if (epackage == UMLPackage.eINSTANCE) {
                umlPackage = OCLUMLUtil.getUMLMetamodel(rset);
            } else if (epackage == EcorePackage.eINSTANCE) {
                umlPackage = OCLUMLUtil.getEcoreMetamodel(rset);
            }
            if (umlPackage == null) {
                List<String> names = OCLUMLUtil.getQualifiedName(epackage);
                umlPackage = OCLUMLUtil.findPackage(names, rset);
            }
            if (umlPackage != null) {
                result = (Classifier)umlPackage.getMember(eclassifier.getName(), false, UMLPackage.Literals.CLASSIFIER);
            }
        }
        return result;
    }

    private static List<String> getQualifiedName(EPackage epackage) {
        LinkedList<String> result = new LinkedList<String>();
        while (epackage != null) {
            result.add(0, epackage.getName());
            epackage = epackage.getESuperPackage();
        }
        return result;
    }

    public static Package findPackage(List<String> packageNames, ResourceSet rset) {
        if (packageNames.isEmpty()) {
            return null;
        }
        String firstName = packageNames.get(0);
        for (Resource res : rset.getResources()) {
            for (EObject root : res.getContents()) {
                Package pkg;
                if (!(root instanceof Package) || (pkg = (Package)root).getOwner() != null || !UMLForeignMethods.isNamed(firstName, (NamedElement)pkg)) continue;
                for (String name : packageNames.subList(1, packageNames.size())) {
                    if ((pkg = UMLForeignMethods.getNestedPackage(pkg, name)) != null) continue;
                    return null;
                }
                return pkg;
            }
        }
        return null;
    }

    public static Namespace findNamespace(List<String> qualifiedName, ResourceSet rset) {
        if (qualifiedName.isEmpty()) {
            return null;
        }
        Package result = null;
        String firstName = qualifiedName.get(0);
        for (Resource res : rset.getResources()) {
            for (EObject root : res.getContents()) {
                Package ns;
                if (!(root instanceof Package) || (ns = (Package)root).getOwner() != null || !UMLForeignMethods.isNamed(firstName, (NamedElement)ns)) continue;
                for (String name : qualifiedName.subList(1, qualifiedName.size())) {
                    if ((ns = (Namespace)UMLForeignMethods.getMember((Namespace)ns, name, UMLPackage.Literals.NAMESPACE)) == null) break;
                }
                if (ns == null) continue;
                result = ns;
                break;
            }
            if (result != null) break;
        }
        return result;
    }

    public static EPackage getEPackage(Package pkg, EPackage.Registry registry) {
        String nsURI;
        EPackage result = null;
        Stereotype epkgStereo = pkg.getAppliedStereotype("Ecore::EPackage");
        if (epkgStereo != null && (nsURI = (String)pkg.getValue(epkgStereo, "nsURI")) != null) {
            result = registry.getEPackage(nsURI);
        }
        if (result == null && pkg.getQualifiedName() != null) {
            LinkedList<String> names = new LinkedList<String>();
            while (pkg != null) {
                names.add(0, pkg.getName());
                pkg = pkg.getNestingPackage();
            }
            result = OCLUMLUtil.findPackage(names, registry);
        }
        return result;
    }

    public static EClassifier getEClassifier(Classifier umlClassifier, Object element, EPackage.Registry registry) {
        EClassifier result = null;
        Package umlPackage = umlClassifier.getPackage();
        EPackage ecorePackage = null;
        if (umlPackage instanceof Profile) {
            Profile profile = (Profile)umlPackage;
            if (element instanceof Element) {
                Element umlElement = (Element)element;
                Package nesting = umlElement.getNearestPackage();
                while (nesting != null) {
                    ProfileApplication appl = nesting.getProfileApplication(profile);
                    if (appl != null) {
                        ecorePackage = appl.getAppliedDefinition();
                        break;
                    }
                    Package package_ = nesting = nesting.getOwner() == null ? null : nesting.getOwner().getNearestPackage();
                }
            }
            if (ecorePackage == null) {
                ecorePackage = profile.getDefinition();
            }
        } else if (umlPackage != null) {
            ecorePackage = OCLUMLUtil.getEPackage(umlPackage, registry);
        }
        if (ecorePackage != null) {
            result = ecorePackage.getEClassifier(UML2Util.getValidJavaIdentifier((String)umlClassifier.getName()));
        }
        return result;
    }

    protected static EPackage findPackage(List<String> packageNames, EPackage.Registry registry) {
        if (packageNames.isEmpty()) {
            return null;
        }
        String name = packageNames.get(0);
        for (Object next : registry.values()) {
            EPackage tentativeResult;
            EPackage ePackage;
            if (!(next instanceof EPackage) || (ePackage = (EPackage)next).getESuperPackage() != null || !name.equals(ePackage.getName()) || (tentativeResult = OCLUMLUtil.findNestedPackage(packageNames.subList(1, packageNames.size()), ePackage)) == null) continue;
            return tentativeResult;
        }
        EPackage result = OCLUMLUtil.findPackageByNSPrefix(packageNames, registry);
        if (result == null && registry != EPackage.Registry.INSTANCE) {
            result = OCLUMLUtil.findPackage(packageNames, EPackage.Registry.INSTANCE);
        }
        return result;
    }

    private static EPackage findNestedPackage(List<String> packageNames, EPackage superpackage) {
        if (packageNames.isEmpty()) {
            return superpackage;
        }
        String name = packageNames.get(0);
        for (EPackage next : superpackage.getESubpackages()) {
            EPackage tentativeResult;
            if (!name.equals(next.getName()) || (tentativeResult = OCLUMLUtil.findNestedPackage(packageNames.subList(1, packageNames.size()), next)) == null) continue;
            return tentativeResult;
        }
        return null;
    }

    private static EPackage findPackageByNSPrefix(List<String> packageNames, EPackage.Registry registry) {
        StringBuilder stringBuffer = new StringBuilder();
        Iterator<String> it = packageNames.iterator();
        while (it.hasNext()) {
            stringBuffer.append(it.next());
            if (!it.hasNext()) continue;
            stringBuffer.append(".");
        }
        String nsPrefix = stringBuffer.toString();
        for (Object next : registry.values()) {
            EPackage ePackage;
            if (!(next instanceof EPackage) || !nsPrefix.equals((ePackage = (EPackage)next).getNsPrefix())) continue;
            return ePackage;
        }
        return null;
    }

    public static Package getUMLMetamodel(ResourceSet resourceSet) {
        Package result = null;
        Resource res = resourceSet.getResource(URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), true);
        if (res != null) {
            result = (Package)EcoreUtil.getObjectByType((Collection)res.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        }
        return result;
    }

    static Package getEcoreMetamodel(ResourceSet resourceSet) {
        Package result = null;
        Resource res = resourceSet.getResource(URI.createURI((String)"pathmap://UML_METAMODELS/Ecore.metamodel.uml"), true);
        if (res != null) {
            result = (Package)EcoreUtil.getObjectByType((Collection)res.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        }
        return result;
    }

    private static EList<NamedElement> getInheritedMembers(Classifier classifier) {
        UniqueEList.FastCompare result = new UniqueEList.FastCompare((Collection)classifier.getMembers());
        for (Classifier parent : classifier.allParents()) {
            if (parent == classifier) continue;
            result.addAll((Collection)parent.getMembers());
        }
        result = classifier.inherit((EList)result);
        return result;
    }

    public static EList<Property> getAllAttributes(Classifier classifier) {
        EList<NamedElement> members = OCLUMLUtil.getInheritedMembers(classifier);
        BasicEList result = new BasicEList(members.size());
        for (NamedElement next : members) {
            if (!(next instanceof Property)) continue;
            result.add((Object)((Property)next));
        }
        return result;
    }

    public static boolean isNonNavigableAssocationEndOf(Property associationEnd, Classifier endClassifier) {
        boolean result;
        boolean bl = result = associationEnd.getOwningAssociation() != null;
        if (result) {
            Property otherEnd = associationEnd.getOtherEnd();
            result = otherEnd != null && otherEnd.getType() != null && endClassifier.conformsTo(otherEnd.getType());
        }
        return result;
    }

    public static EList<Operation> getAllOperations(Classifier classifier) {
        EList<NamedElement> members = OCLUMLUtil.getInheritedMembers(classifier);
        BasicEList result = new BasicEList(members.size());
        for (NamedElement next : members) {
            if (!(next instanceof Operation)) continue;
            result.add((Object)((Operation)next));
        }
        return result;
    }
}

