/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.xtext.util.Strings;

public abstract class EnumerationValue
implements Nameable {
    public static final @NonNull EnumerationValue @NonNull [] NO_ENUMERATION_VALUES = new EnumerationValue[0];
    private @Nullable Integer hashCode = null;

    protected int computeHashCode() {
        return this.getClass().hashCode();
    }

    public abstract @NonNull String getName();

    public final int hashCode() {
        Integer hashCode2 = this.hashCode;
        if (hashCode2 == null) {
            this.hashCode = hashCode2 = Integer.valueOf(this.computeHashCode());
        }
        return hashCode2;
    }

    public boolean isAny() {
        return false;
    }

    public abstract boolean isElement(@NonNull String var1);

    public boolean isNull() {
        return false;
    }

    public boolean isOthers() {
        return false;
    }

    public static class EnumerationValueAny
    extends EnumerationValue {
        public static final @NonNull EnumerationValueAny INSTANCE = new EnumerationValueAny();

        private EnumerationValueAny() {
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public @NonNull String getName() {
            return "\u00abany\u00bb";
        }

        @Override
        public boolean isAny() {
            return true;
        }

        @Override
        public boolean isElement(@NonNull String string) {
            return false;
        }

        public @NonNull String toString() {
            return this.getName();
        }
    }

    public static class EnumerationValueMultiple
    extends EnumerationValue {
        protected final @NonNull String @NonNull [] values;
        protected final @NonNull String name;

        public EnumerationValueMultiple(@NonNull List<@NonNull String> values) {
            this(values.toArray(new String[values.size()]));
        }

        public EnumerationValueMultiple(@NonNull String @NonNull [] values) {
            String castString;
            this.values = values;
            assert (values.length > 0);
            Arrays.sort(this.values);
            StringBuilder s = new StringBuilder();
            boolean isFirst = true;
            String[] stringArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!isFirst) {
                    s.append("|");
                }
                s.append(Strings.convertToJavaString((String)value));
                isFirst = false;
                ++n2;
            }
            this.name = castString = s.toString();
        }

        @Override
        public int computeHashCode() {
            int hash = super.computeHashCode();
            String[] stringArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull String value = stringArray[n2];
                hash += value.hashCode();
                ++n2;
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EnumerationValueMultiple)) {
                return false;
            }
            EnumerationValueMultiple that = (EnumerationValueMultiple)obj;
            if (this.values.length != that.values.length) {
                return false;
            }
            int i = 0;
            while (i < this.values.length) {
                if (!this.values[i].equals(that.values[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public @NonNull String getName() {
            return this.name;
        }

        public @NonNull String @NonNull [] getValues() {
            return this.values;
        }

        @Override
        public boolean isElement(@NonNull String string) {
            String[] stringArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull String value = stringArray[n2];
                if (value.equals(string)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public @NonNull String toString() {
            StringBuilder s = new StringBuilder();
            s.append("'");
            boolean isFirst = true;
            String[] stringArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull String value = stringArray[n2];
                if (!isFirst) {
                    s.append("|");
                }
                s.append(Strings.convertToJavaString((String)value));
                isFirst = false;
                ++n2;
            }
            s.append("'");
            @NonNull String castString = s.toString();
            return castString;
        }
    }

    public static class EnumerationValueNull
    extends EnumerationValue {
        public static final @NonNull EnumerationValueNull INSTANCE = new EnumerationValueNull();

        private EnumerationValueNull() {
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public @NonNull String getName() {
            return "\u00abnull\u00bb";
        }

        @Override
        public boolean isElement(@NonNull String string) {
            return false;
        }

        @Override
        public boolean isNull() {
            return true;
        }

        public @NonNull String toString() {
            return this.getName();
        }
    }

    public static class EnumerationValueOthers
    extends EnumerationValue {
        public static final @NonNull EnumerationValueOthers INSTANCE = new EnumerationValueOthers();

        private EnumerationValueOthers() {
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public @NonNull String getName() {
            return "\u00abothers\u00bb";
        }

        @Override
        public boolean isElement(@NonNull String string) {
            return false;
        }

        @Override
        public boolean isOthers() {
            return true;
        }

        public @NonNull String toString() {
            return this.getName();
        }
    }

    public static class EnumerationValueSingle
    extends EnumerationValue {
        protected final @NonNull String value;

        public EnumerationValueSingle(@NonNull String value) {
            this.value = value;
        }

        @Override
        public int computeHashCode() {
            return super.computeHashCode() + this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EnumerationValueSingle)) {
                return false;
            }
            return this.value.equals(((EnumerationValueSingle)obj).value);
        }

        @Override
        public @NonNull String getName() {
            return this.value;
        }

        @Override
        public boolean isElement(@NonNull String string) {
            return this.value.equals(string);
        }

        public @NonNull String toString() {
            return "'" + Strings.convertToJavaString((String)this.value) + "'";
        }
    }
}

