/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.xtext.base.serializer.CustomSegmentSupport;
import org.eclipse.ocl.xtext.base.serializer.PostCommentSerializationSegment;
import org.eclipse.ocl.xtext.base.serializer.PreCommentSerializationSegment;
import org.eclipse.ocl.xtext.base.serializer.SerializationBuilder;
import org.eclipse.ocl.xtext.base.serializer.SerializationRule;
import org.eclipse.ocl.xtext.base.serializer.SerializationStep;
import org.eclipse.ocl.xtext.base.serializer.UserElementFormatter;
import org.eclipse.ocl.xtext.base.serializer.UserElementSerializer;
import org.eclipse.xtext.nodemodel.INode;

public abstract class SerializationSegment {
    public static final @NonNull SerializationSegment HALF_NEW_LINE = new SpacingSerializationSegment(SerializationBuilder.HALF_NEW_LINE);
    public static final @NonNull SerializationSegment NEW_LINE = new SpacingSerializationSegment(SerializationBuilder.NEW_LINE);
    public static final @NonNull SerializationSegment NO_NEW_LINE = new SpacingSerializationSegment(SerializationBuilder.NO_NEW_LINE);
    public static final @NonNull SerializationSegment NO_SPACE = new SpacingSerializationSegment(SerializationBuilder.NO_SPACE);
    public static final @NonNull SerializationSegment POP = new ControlSerializationSegment(SerializationBuilder.POP);
    public static final @NonNull SerializationSegment POST_COMMENT = new PostCommentSerializationSegment();
    public static final @NonNull SerializationSegment PRE_COMMENT = new PreCommentSerializationSegment();
    public static final @NonNull SerializationSegment PUSH = new ControlSerializationSegment(SerializationBuilder.PUSH);
    public static final @NonNull SerializationSegment PUSH_NEXT = new ControlSerializationSegment(SerializationBuilder.PUSH_NEXT);
    public static final @NonNull SerializationSegment SOFT_NEW_LINE = new SpacingSerializationSegment(SerializationBuilder.SOFT_NEW_LINE);
    public static final @NonNull SerializationSegment SOFT_SPACE = new SpacingSerializationSegment(SerializationBuilder.SOFT_SPACE);
    public static final @NonNull SerializationSegment VALUE = new ValueSerializationSegment();
    public static final @NonNull SerializationSegment WRAP_ANCHOR = new ControlSerializationSegment(SerializationBuilder.WRAP_ANCHOR);
    public static final @NonNull SerializationSegment WRAP_BEGIN_ALL = new ControlSerializationSegment(SerializationBuilder.WRAP_BEGIN_ALL);
    public static final @NonNull SerializationSegment WRAP_BEGIN_SOME = new ControlSerializationSegment(SerializationBuilder.WRAP_BEGIN_SOME);
    public static final @NonNull SerializationSegment WRAP_END = new ControlSerializationSegment(SerializationBuilder.WRAP_END);
    public static final @NonNull SerializationSegment WRAP_HERE = new ControlSerializationSegment(SerializationBuilder.WRAP_HERE);
    public static final @NonNull SerializationSegment @NonNull [] VALUE_SEGMENTS_ARRAY = new SerializationSegment[]{VALUE};
    public static final @NonNull List<@NonNull SerializationSegment> VALUE_SEGMENTS_LIST = Lists.newArrayList((Object[])new SerializationSegment[]{VALUE});
    private static final @NonNull Map<@NonNull String, @NonNull UserSerializationSegment> string2segment = new HashMap<String, UserSerializationSegment>();

    public static final @NonNull SerializationSegment getString(@NonNull String string) {
        UserSerializationSegment stringSerializationSegment = string2segment.get(string);
        if (stringSerializationSegment == null) {
            stringSerializationSegment = new UserSerializationSegment(string);
            string2segment.put(string, stringSerializationSegment);
        }
        return stringSerializationSegment;
    }

    public abstract void format(@NonNull UserElementFormatter var1, @NonNull SerializationBuilder var2);

    public boolean isControl() {
        return false;
    }

    public boolean isValue() {
        return false;
    }

    public abstract void serialize(int var1, @NonNull UserElementSerializer var2, @NonNull SerializationBuilder var3);

    public @NonNull String toCommentString() {
        return this.toString();
    }

    public abstract @NonNull String toString();

    public static class ControlSerializationSegment
    extends StringSerializationSegment {
        public ControlSerializationSegment(@NonNull String string) {
            super(string);
        }

        @Override
        public boolean isControl() {
            return true;
        }
    }

    public static class CustomSerializationSegment
    extends SerializationSegment {
        private @Nullable String supportClassName;
        private @Nullable Class<?> supportClass;
        private @Nullable CustomSegmentSupport supportInstance = null;

        public CustomSerializationSegment(@NonNull String supportClassName) {
            this.supportClassName = supportClassName;
            this.supportClass = null;
            this.supportInstance = null;
        }

        public CustomSerializationSegment(@NonNull Class<?> supportClass) {
            this.supportClassName = null;
            this.supportClass = supportClass;
            this.supportInstance = null;
        }

        public @NonNull String getSupportClassName() {
            if (this.supportClassName != null) {
                return this.supportClassName;
            }
            assert (this.supportClass != null);
            @NonNull String castName = this.supportClass.getName();
            return castName;
        }

        @Override
        public void format(@NonNull UserElementFormatter formatter, @NonNull SerializationBuilder serializationBuilder) {
            CustomSegmentSupport supportInstance2 = this.getSupportInstance(formatter.getElement());
            if (supportInstance2 == null) {
                serializationBuilder.appendError("\n\n\u00abmissing " + this.getSupportClassName() + "\u00bb\n\n");
            } else {
                supportInstance2.format(formatter, serializationBuilder);
            }
        }

        protected CustomSegmentSupport getSupportInstance(@NonNull EObject eObject) {
            CustomSegmentSupport supportInstance2 = this.supportInstance;
            if (supportInstance2 == null) {
                if (this.supportClass == null && this.supportClassName != null) {
                    ClassLoader classLoader = eObject.getClass().getClassLoader();
                    try {
                        this.supportClass = classLoader.loadClass(this.supportClassName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (this.supportClass != null) {
                    try {
                        this.supportInstance = supportInstance2 = (CustomSegmentSupport)this.supportClass.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                        // empty catch block
                    }
                }
            }
            return supportInstance2;
        }

        @Override
        public void serialize(int serializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            CustomSegmentSupport supportInstance2 = this.getSupportInstance(serializer.getElement());
            if (supportInstance2 == null) {
                serializationBuilder.appendError("\n\n\u00abmissing " + this.getSupportClassName() + "\u00bb\n\n");
            } else {
                supportInstance2.serialize(serializationStepIndex, serializer, serializationBuilder);
            }
        }

        @Override
        public @NonNull String toString() {
            if (this.supportClass == PreCommentSerializationSegment.class) {
                return "pre-comment";
            }
            if (this.supportClass == PostCommentSerializationSegment.class) {
                return "post-comment";
            }
            return this.getSupportClassName();
        }
    }

    public static class SpacingSerializationSegment
    extends StringSerializationSegment {
        public SpacingSerializationSegment(@NonNull String string) {
            super(string);
        }
    }

    public static abstract class StringSerializationSegment
    extends SerializationSegment {
        protected final @NonNull String string;

        protected StringSerializationSegment(@NonNull String string) {
            this.string = string;
        }

        public @NonNull String getString() {
            return this.string;
        }

        @Override
        public void format(@NonNull UserElementFormatter formatter, @NonNull SerializationBuilder serializationBuilder) {
            serializationBuilder.append(this.string);
        }

        @Override
        public void serialize(int serializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            serializationBuilder.append(this.string);
        }

        @Override
        public @NonNull String toString() {
            return this.string;
        }
    }

    public static class UserSerializationSegment
    extends StringSerializationSegment {
        public UserSerializationSegment(@NonNull String string) {
            super(string);
        }

        @Override
        public @NonNull String toCommentString() {
            StringBuilder s = new StringBuilder();
            int i = 0;
            while (i < this.string.length()) {
                if (i > 0) {
                    s.append(" ");
                }
                char c = this.string.charAt(i);
                s.append(c);
                ++i;
            }
            return s.toString();
        }
    }

    public static class ValueSerializationSegment
    extends SerializationSegment {
        @Override
        public void format(@NonNull UserElementFormatter formatter, @NonNull SerializationBuilder serializationBuilder) {
            INode node = formatter.getNode();
            String text = node.getText();
            serializationBuilder.append(text);
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public void serialize(int serializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            SerializationRule serializationRule = serializer.getSerializationRule();
            SerializationStep serializationStep = serializationRule.getSerializationSteps()[serializationStepIndex];
            serializationStep.serializeInnerValue(serializationStepIndex, serializer, serializationBuilder);
        }

        @Override
        public @NonNull String toString() {
            return SerializationBuilder.VALUE;
        }
    }
}

