/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.AbstractSingletonScope;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.SingletonScope;
import org.eclipse.ocl.pivot.ids.TemplateableTypeId;
import org.eclipse.ocl.pivot.internal.ids.GeneralizedNestedTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.SpecializedClassIdImpl;

public class GeneralizedClassIdImpl
extends GeneralizedNestedTypeIdImpl
implements ClassId {
    private static int computeHashCode(@NonNull ElementId parentId, int templateParameters, @NonNull String name) {
        return IdHash.createChildHash(parentId, name) + 7 * templateParameters;
    }

    public GeneralizedClassIdImpl(@NonNull PackageId parentId, int templateParameters, @NonNull String name) {
        super(GeneralizedClassIdImpl.computeHashCode(parentId, templateParameters, name), parentId, templateParameters, name);
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitClassId(this);
    }

    @Override
    protected @NonNull TemplateableTypeId createSpecializedId(@NonNull BindingsId templateBindings) {
        return new SpecializedClassIdImpl(this, templateBindings);
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return "Class";
    }

    public static class ClassIdSingletonScope
    extends AbstractSingletonScope<ClassId, ClassIdValue> {
        public @NonNull ClassId getSingleton(@NonNull PackageId packageId, @NonNull String name, int templateParameters) {
            return this.getSingletonFor(new ClassIdValue(packageId, name, templateParameters));
        }
    }

    private static class ClassIdValue
    extends SingletonScope.AbstractKeyAndValue<ClassId> {
        private @NonNull PackageId packageId;
        private @NonNull String name;
        private int templateParameters;

        private ClassIdValue(@NonNull PackageId packageId, @NonNull String name, int templateParameters) {
            super(GeneralizedClassIdImpl.computeHashCode(packageId, templateParameters, name));
            this.packageId = packageId;
            this.name = name;
            this.templateParameters = templateParameters;
        }

        @Override
        public @NonNull ClassId createSingleton() {
            return new GeneralizedClassIdImpl(this.packageId, this.templateParameters, this.name);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that instanceof GeneralizedClassIdImpl) {
                GeneralizedClassIdImpl singleton = (GeneralizedClassIdImpl)that;
                return this.name.equals(singleton.getName()) && this.templateParameters == singleton.getTemplateParameters();
            }
            return false;
        }
    }
}

