/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.library.executor.AbstractReflectiveInheritanceType;
import org.eclipse.ocl.pivot.internal.library.executor.DomainProperties;
import org.eclipse.ocl.pivot.internal.library.executor.DomainReflectiveFragment;
import org.eclipse.ocl.pivot.internal.library.executor.DomainReflectivePackage;
import org.eclipse.ocl.pivot.types.AbstractFragment;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class DomainReflectiveType
extends AbstractReflectiveInheritanceType {
    protected final @NonNull DomainReflectivePackage evaluationPackage;
    protected final @NonNull Class domainClass;
    private DomainProperties allProperties;

    public DomainReflectiveType(@NonNull DomainReflectivePackage evaluationPackage, @NonNull Class domainClass) {
        super(ClassUtil.nonNullModel(domainClass.getName()), DomainReflectiveType.computeFlags(domainClass));
        this.evaluationPackage = evaluationPackage;
        this.domainClass = domainClass;
    }

    @Override
    protected @NonNull AbstractFragment createFragment(@NonNull CompleteInheritance baseInheritance) {
        return new DomainReflectiveFragment(this, baseInheritance);
    }

    @Override
    public @NonNull Type getCommonType(@NonNull IdResolver idResolver, @NonNull Type type) {
        if (this == type) {
            return this.getPivotClass();
        }
        DomainReflectiveType firstInheritance = this;
        CompleteInheritance secondInheritance = type.getInheritance(idResolver.getStandardLibrary());
        CompleteInheritance commonInheritance = firstInheritance.getCommonInheritance(secondInheritance);
        return commonInheritance.getPivotClass();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Iterable<@NonNull ? extends CompleteInheritance> getInitialSuperInheritances() {
        List<@NonNull Class> superClasses = ClassUtil.nullFree(this.domainClass.getSuperClasses());
        final StandardLibrary standardLibrary = this.evaluationPackage.getStandardLibrary();
        if (Iterables.isEmpty(superClasses)) {
            return Collections.singletonList(standardLibrary.getOclAnyType().getInheritance(standardLibrary));
        }
        return Iterables.transform(superClasses, (Function)new Function<Class, CompleteInheritance>(){

            public @NonNull CompleteInheritance apply(@NonNull Class asClass) {
                return asClass.getInheritance(standardLibrary);
            }
        });
    }

    @Override
    public @NonNull List<Class> getSuperClasses() {
        return this.domainClass.getSuperClasses();
    }

    @Override
    public @Nullable Operation getMemberOperation(@NonNull OperationId operationId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Property getMemberProperty(@NonNull String name) {
        DomainProperties allProperties2 = this.allProperties;
        if (allProperties2 == null) {
            this.allProperties = allProperties2 = new DomainProperties(this);
        }
        return allProperties2.getMemberProperty(name);
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return this.domainClass.getMetaTypeName();
    }

    @Override
    public @NonNull List<Constraint> getOwnedInvariants() {
        return this.domainClass.getOwnedInvariants();
    }

    @Override
    public @NonNull List<Operation> getOwnedOperations() {
        return this.domainClass.getOwnedOperations();
    }

    @Override
    public @NonNull List<Property> getOwnedProperties() {
        return this.domainClass.getOwnedProperties();
    }

    @Override
    public @NonNull List<Constraint> getOwnedConstraints() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Package getOwningPackage() {
        return this.evaluationPackage;
    }

    @Override
    public @NonNull Class getPivotClass() {
        return this.domainClass;
    }

    @Override
    public @NonNull TypeId getTypeId() {
        return this.domainClass.getTypeId();
    }

    @Override
    public @NonNull TemplateParameters getTypeParameters() {
        return this.domainClass.getTypeParameters();
    }

    @Override
    public boolean isOrdered() {
        return this.domainClass.isOrdered();
    }

    @Override
    public boolean isUnique() {
        return this.domainClass.isUnique();
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.evaluationPackage)) + "::" + String.valueOf(this.name);
    }
}

