/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints.operations;

import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.types.constraints.AdviceConstraint;
import org.eclipse.papyrus.infra.emf.types.constraints.CompositeConstraint;
import org.eclipse.papyrus.infra.emf.types.constraints.operations.AdviceConstraintOperations;

public class CompositeConstraintOperations
extends AdviceConstraintOperations {
    protected CompositeConstraintOperations() {
    }

    public static boolean approveRequest(CompositeConstraint compositeConstraint, IEditCommandRequest request) {
        boolean result;
        block0 : switch (compositeConstraint.getOperator()) {
            case AND: {
                result = false;
                for (AdviceConstraint next : compositeConstraint.getConstraints()) {
                    result = next.approveRequest(request);
                    if (!result) break block0;
                }
                break;
            }
            case OR: {
                result = false;
                for (AdviceConstraint next : compositeConstraint.getConstraints()) {
                    result = next.approveRequest(request);
                    if (result) break block0;
                }
                break;
            }
            case XOR: {
                int count = 0;
                for (AdviceConstraint next : compositeConstraint.getConstraints()) {
                    count += next.approveRequest(request) ? 1 : 0;
                }
                result = count == 1;
                break;
            }
            case NOT: {
                result = true;
                for (AdviceConstraint next : compositeConstraint.getConstraints()) {
                    result = next.approveRequest(request);
                    if (!result) break block0;
                }
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }
}

