/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Borland) - [243151] explicit source/target for links
 *  							- #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.editpolicies;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import xpt.Common_qvto;
import xpt.GenModelUtils_qvto;

@Singleton
@SuppressWarnings("all")
public class LinkUtils_qvto {
  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private GenModelUtils_qvto _genModelUtils_qvto;

  public boolean isTypeLink(final GenLink link) {
    return this._common_qvto.oclIsKindOf(link.getModelFacet(), TypeLinkModelFacet.class);
  }

  public boolean isRefLink(final GenLink link) {
    return this._common_qvto.oclIsKindOf(link.getModelFacet(), FeatureLinkModelFacet.class);
  }

  public boolean canBeSource(final GenLink link, final GenLinkEnd linkEnd) {
    return link.getSources().contains(linkEnd);
  }

  public boolean canBeTarget(final GenLink link, final GenLinkEnd linkEnd) {
    return link.getTargets().contains(linkEnd);
  }

  public boolean canBeContainer(final GenLink link, final GenClass metaClass) {
    return ((link.getModelFacet() != null) && this.isCompatible(this.getContainerClass(link.getModelFacet()), metaClass));
  }

  private GenClass _getContainerClass(final LinkModelFacet facet) {
    return null;
  }

  private GenClass _getContainerClass(final TypeLinkModelFacet facet) {
    return facet.getChildMetaFeature().getGenClass();
  }

  private GenClass _getContainerClass(final FeatureLinkModelFacet facet) {
    return facet.getSourceType();
  }

  private boolean isCompatible(final GenClass desiredType, final GenClass actualClass) {
    return ((null != desiredType) && this._genModelUtils_qvto.isSuperTypeOf(desiredType, actualClass));
  }

  @XbaseGenerated
  private GenClass getContainerClass(final LinkModelFacet facet) {
    if (facet instanceof FeatureLinkModelFacet) {
      return _getContainerClass((FeatureLinkModelFacet)facet);
    } else if (facet instanceof TypeLinkModelFacet) {
      return _getContainerClass((TypeLinkModelFacet)facet);
    } else if (facet != null) {
      return _getContainerClass(facet);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(facet).toString());
    }
  }
}
