/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.nebula.widgets.richtext.ScalingHelper;
import org.eclipse.nebula.widgets.richtext.painter.AlignmentStyle;
import org.eclipse.nebula.widgets.richtext.painter.DefaultEntityReplacer;
import org.eclipse.nebula.widgets.richtext.painter.EntityReplacer;
import org.eclipse.nebula.widgets.richtext.painter.LinePainter;
import org.eclipse.nebula.widgets.richtext.painter.ResourceHelper;
import org.eclipse.nebula.widgets.richtext.painter.SpanElement;
import org.eclipse.nebula.widgets.richtext.painter.TagProcessingState;
import org.eclipse.nebula.widgets.richtext.painter.instructions.BoldPaintInstruction;
import org.eclipse.nebula.widgets.richtext.painter.instructions.FontMetricsProvider;
import org.eclipse.nebula.widgets.richtext.painter.instructions.ItalicPaintInstruction;
import org.eclipse.nebula.widgets.richtext.painter.instructions.ListInstruction;
import org.eclipse.nebula.widgets.richtext.painter.instructions.NewLineInstruction;
import org.eclipse.nebula.widgets.richtext.painter.instructions.PaintInstruction;
import org.eclipse.nebula.widgets.richtext.painter.instructions.ParagraphInstruction;
import org.eclipse.nebula.widgets.richtext.painter.instructions.ResetFontPaintInstruction;
import org.eclipse.nebula.widgets.richtext.painter.instructions.ResetParagraphInstruction;
import org.eclipse.nebula.widgets.richtext.painter.instructions.ResetSpanStylePaintInstruction;
import org.eclipse.nebula.widgets.richtext.painter.instructions.SpanStylePaintInstruction;
import org.eclipse.nebula.widgets.richtext.painter.instructions.TextPaintInstruction;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class RichTextPainter {
    public static final String TAG_SPAN = "span";
    public static final String TAG_STRONG = "strong";
    public static final String TAG_BOLD = "b";
    public static final String TAG_EM = "em";
    public static final String TAG_UNDERLINE = "u";
    public static final String TAG_STRIKETHROUGH = "s";
    public static final String TAG_PARAGRAPH = "p";
    public static final String TAG_UNORDERED_LIST = "ul";
    public static final String TAG_ORDERED_LIST = "ol";
    public static final String TAG_LIST_ITEM = "li";
    public static final String TAG_BR = "br";
    public static final String ATTRIBUTE_STYLE = "style";
    public static final String ATTRIBUTE_STYLE_COLOR = "color";
    public static final String ATTRIBUTE_STYLE_BACKGROUND_COLOR = "background-color";
    public static final String ATTRIBUTE_STYLE_FONT_SIZE = "font-size";
    public static final String ATTRIBUTE_STYLE_FONT_FAMILY = "font-family";
    public static final String ATTRIBUTE_PARAGRAPH_MARGIN_LEFT = "margin-left";
    public static final String ATTRIBUTE_PARAGRAPH_TEXT_ALIGN = "text-align";
    public static final String ATTRIBUTE_PARAGRAPH_TEXT_ALIGN_VALUE_RIGHT = "right";
    public static final String CONTROL_CHARACTER_REGEX = "\\n\\r|\\r\\n|\\n|\\r|\\t";
    public static final String FAKE_ROOT_TAG_START = "<root>";
    public static final String FAKE_ROOT_TAG_END = "</root>";
    public static final String[] BULLETS = new String[]{"\u2022", " \u25e6", "\u25aa"};
    public static final String SPACE = "\u00a0";
    private int paragraphSpace = 5;
    private boolean wordWrap;
    private final Point preferredSize = new Point(0, 0);
    XMLInputFactory factory = XMLInputFactory.newInstance();
    private EntityReplacer entityReplacer;
    private String wordSplitRegex;

    public RichTextPainter() {
        this(false);
    }

    public RichTextPainter(boolean wordWrap) {
        this.factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        this.entityReplacer = new DefaultEntityReplacer();
        this.wordSplitRegex = "\\s";
        this.wordWrap = wordWrap;
    }

    public void preCalculate(String html, GC gc, Rectangle bounds, boolean calculateWithWrapping) {
        boolean original = this.wordWrap;
        this.wordWrap = calculateWithWrapping;
        this.paintHTML(html, gc, bounds, false);
        this.wordWrap = original;
    }

    public void paintHTML(String html, GC gc, Rectangle bounds) {
        this.paintHTML(html, gc, bounds, true);
    }

    protected void paintHTML(String html, GC gc, Rectangle bounds, boolean render) {
        ArrayList<LinePainter> lines;
        TagProcessingState state;
        block40: {
            state = new TagProcessingState();
            state.setStartingPoint(bounds.x, bounds.y);
            state.setRendering(render);
            LinkedList<SpanElement> spanStack = new LinkedList<SpanElement>();
            lines = new ArrayList<LinePainter>();
            Object cleanedHtml = html.replaceAll(CONTROL_CHARACTER_REGEX, "");
            cleanedHtml = FAKE_ROOT_TAG_START + (String)cleanedHtml + FAKE_ROOT_TAG_END;
            gc.setAntialias(-1);
            gc.setTextAntialias(-1);
            XMLEventReader parser = null;
            int availableWidth = bounds.width;
            LinkedList<Integer> listIndentation = new LinkedList<Integer>();
            boolean listOpened = false;
            try {
                try {
                    parser = this.factory.createXMLEventReader(new StringReader((String)cleanedHtml));
                    LinePainter currentLine = null;
                    block18: while (parser.hasNext()) {
                        XMLEvent event = parser.nextEvent();
                        switch (event.getEventType()) {
                            case 8: {
                                parser.close();
                                break;
                            }
                            case 1: {
                                StartElement element = event.asStartElement();
                                String elementString = element.getName().getLocalPart();
                                if (TAG_PARAGRAPH.equals(elementString)) {
                                    currentLine = this.createNewLine(lines);
                                    AlignmentStyle alignment = this.handleAlignmentConfiguration(element);
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new ParagraphInstruction(alignment, this.getParagraphSpace(), state));
                                    availableWidth -= alignment.marginLeft;
                                    break;
                                }
                                if (TAG_BR.equals(elementString)) {
                                    currentLine = this.createNewLine(lines);
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new NewLineInstruction(state));
                                    break;
                                }
                                if (TAG_SPAN.equals(elementString)) {
                                    PaintInstruction styleInstruction = this.handleStyleConfiguration(element, spanStack, state);
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, styleInstruction);
                                    break;
                                }
                                if (TAG_STRONG.equals(elementString) || TAG_BOLD.equals(elementString)) {
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new BoldPaintInstruction(state));
                                    break;
                                }
                                if (TAG_EM.equals(elementString)) {
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new ItalicPaintInstruction(state));
                                    break;
                                }
                                if (TAG_UNDERLINE.equals(elementString)) {
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new PaintInstruction(){

                                        @Override
                                        public void paint(GC gc, Rectangle area) {
                                            state.setUnderlineActive(true);
                                        }
                                    });
                                    break;
                                }
                                if (TAG_STRIKETHROUGH.equals(elementString)) {
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new PaintInstruction(){

                                        @Override
                                        public void paint(GC gc, Rectangle area) {
                                            state.setStrikethroughActive(true);
                                        }
                                    });
                                    break;
                                }
                                if (TAG_UNORDERED_LIST.equals(elementString) || TAG_ORDERED_LIST.equals(elementString)) {
                                    int indent = this.calculateListIndentation(gc);
                                    availableWidth -= indent;
                                    listIndentation.add(indent);
                                    listOpened = true;
                                    AlignmentStyle alignment = this.handleAlignmentConfiguration(element);
                                    boolean isOrderedList = TAG_ORDERED_LIST.equals(elementString);
                                    currentLine = this.createNewLine(lines);
                                    currentLine = this.addInstruction(gc, availableWidth -= alignment.marginLeft, lines, currentLine, state, new ListInstruction(indent, isOrderedList, alignment, this.getParagraphSpace(), state));
                                    PaintInstruction styleInstruction = this.handleStyleConfiguration(element, spanStack, state);
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, styleInstruction);
                                    break;
                                }
                                if (!TAG_LIST_ITEM.equals(elementString)) break;
                                if (!listOpened) {
                                    currentLine = this.createNewLine(lines);
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new NewLineInstruction(state));
                                } else {
                                    listOpened = false;
                                }
                                final AlignmentStyle alignment = this.handleAlignmentConfiguration(element);
                                currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new PaintInstruction(){

                                    @Override
                                    public void paint(GC gc, Rectangle area) {
                                        state.resetX();
                                        String bullet = RichTextPainter.this.getBulletCharacter(state.getListDepth()) + RichTextPainter.SPACE;
                                        if (state.isOrderedList()) {
                                            bullet = String.valueOf(state.getCurrentListNumber()) + ". ";
                                        }
                                        int extend = gc.textExtent((String)bullet).x;
                                        gc.drawText(bullet, state.getPointer().x - extend, state.getPointer().y, state.hasPreviousBgColor());
                                        state.setTextAlignment(alignment.alignment);
                                        state.calculateX(area.width);
                                    }
                                });
                                break;
                            }
                            case 2: {
                                String endElementString = event.asEndElement().getName().getLocalPart();
                                if (TAG_PARAGRAPH.equals(endElementString)) {
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new ResetParagraphInstruction(this.getParagraphSpace(), state));
                                    availableWidth = bounds.width;
                                    break;
                                }
                                if (TAG_SPAN.equals(endElementString)) {
                                    SpanElement span = (SpanElement)spanStack.pollLast();
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new ResetSpanStylePaintInstruction(state, span));
                                    break;
                                }
                                if (TAG_STRONG.equals(endElementString) || TAG_BOLD.equals(endElementString) || TAG_EM.equals(endElementString)) {
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new ResetFontPaintInstruction(state));
                                    break;
                                }
                                if (TAG_UNDERLINE.equals(endElementString)) {
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new PaintInstruction(){

                                        @Override
                                        public void paint(GC gc, Rectangle area) {
                                            state.setUnderlineActive(false);
                                        }
                                    });
                                    break;
                                }
                                if (TAG_STRIKETHROUGH.equals(endElementString)) {
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new PaintInstruction(){

                                        @Override
                                        public void paint(GC gc, Rectangle area) {
                                            state.setStrikethroughActive(false);
                                        }
                                    });
                                    break;
                                }
                                if (TAG_LIST_ITEM.equals(endElementString)) {
                                    currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new PaintInstruction(){

                                        @Override
                                        public void paint(GC gc, Rectangle area) {
                                            state.increaseCurrentListNumber();
                                            state.setTextAlignment(TagProcessingState.TextAlignment.LEFT);
                                        }
                                    });
                                    break;
                                }
                                if (!TAG_ORDERED_LIST.equals(endElementString) && !TAG_UNORDERED_LIST.equals(endElementString)) continue block18;
                                currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new PaintInstruction(){

                                    @Override
                                    public void paint(GC gc, Rectangle area) {
                                        state.resetListConfiguration();
                                        if (state.getListDepth() == 0) {
                                            state.setMarginLeft(0);
                                            state.increaseY(state.getCurrentLineHeight());
                                            state.increaseY(RichTextPainter.this.getParagraphSpace());
                                        }
                                        state.resetX();
                                        state.setTextAlignment(TagProcessingState.TextAlignment.LEFT);
                                    }
                                });
                                availableWidth += ((Integer)listIndentation.pollLast()).intValue();
                                currentLine = null;
                                break;
                            }
                            case 4: {
                                Characters characters = event.asCharacters();
                                String text = characters.getData();
                                currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new TextPaintInstruction(state, text));
                                break;
                            }
                            case 9: {
                                String value = this.entityReplacer.getEntityReferenceValue((EntityReference)event);
                                if (value == null) break;
                                currentLine = this.addInstruction(gc, availableWidth, lines, currentLine, state, new TextPaintInstruction(state, value));
                                break;
                            }
                            case 10: {
                                break;
                            }
                        }
                    }
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (XMLStreamException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block40;
                }
            }
            catch (Throwable throwable) {
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (XMLStreamException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
        }
        state.setLineIterator(lines.iterator());
        this.preferredSize.x = bounds.width;
        this.preferredSize.y = 0;
        for (LinePainter painter : lines) {
            painter.paint(gc, bounds);
            this.preferredSize.x = Math.max(this.preferredSize.x, painter.getContentWidth());
            this.preferredSize.y += painter.getLineHeight();
        }
        this.preferredSize.y += 2 * state.getParagraphCount() * this.getParagraphSpace();
    }

    private LinePainter addInstruction(GC gc, int availableWidth, Collection<LinePainter> lines, LinePainter currentLine, final TagProcessingState state, PaintInstruction instruction) {
        if (instruction instanceof FontMetricsProvider) {
            ((FontMetricsProvider)((Object)instruction)).getFontMetrics(gc);
        }
        if (currentLine == null) {
            currentLine = this.createNewLine(lines);
            currentLine.addInstruction(new PaintInstruction(){

                @Override
                public void paint(GC gc, Rectangle area) {
                    state.activateNextLine();
                    state.increaseY(RichTextPainter.this.getParagraphSpace());
                    state.increaseParagraphCount();
                }
            });
        }
        LinePainter lineToUse = currentLine;
        if (instruction instanceof TextPaintInstruction) {
            TextPaintInstruction txtInstr = (TextPaintInstruction)instruction;
            int textLength = txtInstr.getTextLength(gc);
            int trimmedTextLength = txtInstr.getTrimmedTextLength(gc);
            gc.setFont(gc.getFont());
            if (currentLine.getContentWidth() + textLength > availableWidth && this.wordWrap) {
                LinkedList<String> wordsToProcess = new LinkedList<String>(Arrays.asList(txtInstr.getText().split("(?<=" + this.wordSplitRegex + ")")));
                Object subString = "";
                int subStringLength = 0;
                while (!wordsToProcess.isEmpty()) {
                    String word = (String)wordsToProcess.pollFirst();
                    int wordLength = gc.textExtent((String)word).x;
                    if (lineToUse.getContentWidth() + (subStringLength += wordLength) > availableWidth) {
                        boolean newLine = true;
                        if (!((String)subString).trim().isEmpty()) {
                            subString = ResourceHelper.rtrim((String)subString);
                            txtInstr = new TextPaintInstruction(state, (String)subString);
                            textLength = txtInstr.getTextLength(gc);
                            trimmedTextLength = txtInstr.getTrimmedTextLength(gc);
                            lineToUse.addInstruction(txtInstr);
                            lineToUse.increaseContentWidth(textLength);
                            lineToUse.increaseTrimmedContentWidth(trimmedTextLength);
                        } else if (lineToUse.getContentWidth() == 0) {
                            newLine = false;
                        }
                        subString = word;
                        subStringLength = wordLength;
                        if (!newLine) continue;
                        lineToUse = this.createNewLine(lines);
                        lineToUse.addInstruction(new NewLineInstruction(state));
                        continue;
                    }
                    subString = (String)subString + word;
                }
                if (!((String)subString).trim().isEmpty()) {
                    txtInstr = new TextPaintInstruction(state, (String)subString);
                    textLength = txtInstr.getTextLength(gc);
                    trimmedTextLength = txtInstr.getTrimmedTextLength(gc);
                    instruction = txtInstr;
                }
            }
            lineToUse.addInstruction(instruction);
            lineToUse.increaseContentWidth(textLength);
            lineToUse.increaseTrimmedContentWidth(trimmedTextLength);
        } else {
            lineToUse.addInstruction(instruction);
        }
        return lineToUse;
    }

    private LinePainter createNewLine(Collection<LinePainter> lines) {
        LinePainter currentLine = new LinePainter();
        lines.add(currentLine);
        return currentLine;
    }

    private AlignmentStyle handleAlignmentConfiguration(StartElement element) {
        AlignmentStyle result = new AlignmentStyle();
        Iterator<Attribute> attributes = element.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!ATTRIBUTE_STYLE.equals(attribute.getName().toString())) continue;
            Map<String, String> styleProperties = this.getStyleProperties(attribute.getValue().toString());
            for (Map.Entry<String, String> entry : styleProperties.entrySet()) {
                if (ATTRIBUTE_PARAGRAPH_MARGIN_LEFT.equals(entry.getKey())) {
                    String pixelValue = entry.getValue().replace("px", "");
                    try {
                        int pixel;
                        result.marginLeft = pixel = Integer.valueOf(pixelValue.trim()).intValue();
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!ATTRIBUTE_PARAGRAPH_TEXT_ALIGN.equals(entry.getKey())) continue;
                try {
                    TagProcessingState.TextAlignment alignment;
                    result.alignment = alignment = TagProcessingState.TextAlignment.valueOf(entry.getValue().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private PaintInstruction handleStyleConfiguration(StartElement element, Deque<SpanElement> spanStack, TagProcessingState state) {
        SpanElement span = new SpanElement();
        SpanStylePaintInstruction styleInstruction = new SpanStylePaintInstruction(state);
        Iterator<Attribute> attributes = element.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!ATTRIBUTE_STYLE.equals(attribute.getName().toString())) continue;
            Map<String, String> styleProperties = this.getStyleProperties(attribute.getValue().toString());
            for (Map.Entry<String, String> entry : styleProperties.entrySet()) {
                if (ATTRIBUTE_STYLE_COLOR.equals(entry.getKey())) {
                    span.types.add(SpanElement.SpanType.COLOR);
                    styleInstruction.setForegroundColor(ResourceHelper.getColor(entry.getValue()));
                    continue;
                }
                if (ATTRIBUTE_STYLE_BACKGROUND_COLOR.equals(entry.getKey())) {
                    span.types.add(SpanElement.SpanType.BG_COLOR);
                    styleInstruction.setBackgroundColor(ResourceHelper.getColor(entry.getValue()));
                    continue;
                }
                if (ATTRIBUTE_STYLE_FONT_SIZE.equals(entry.getKey())) {
                    span.types.add(SpanElement.SpanType.FONT);
                    String pixelValue = entry.getValue().replace("px", "");
                    try {
                        int pixel = Integer.valueOf(pixelValue.trim());
                        int pointSize = 72 * ScalingHelper.convertHorizontalPixelToDpi(pixel) / Display.getDefault().getDPI().x;
                        styleInstruction.setFontSize(pointSize);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!ATTRIBUTE_STYLE_FONT_FAMILY.equals(entry.getKey())) continue;
                span.types.add(SpanElement.SpanType.FONT);
                styleInstruction.setFontType(entry.getValue().split(",")[0]);
            }
        }
        spanStack.add(span);
        return styleInstruction;
    }

    private Map<String, String> getStyleProperties(String styleString) {
        String[] configurations;
        HashMap<String, String> result = new HashMap<String, String>();
        String[] stringArray = configurations = styleString.split(";");
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            String config = stringArray[n2];
            String[] keyValuePair = config.split(":");
            result.put(keyValuePair[0].trim(), keyValuePair[1].trim());
            ++n2;
        }
        return result;
    }

    protected int calculateListIndentation(GC gc) {
        return gc.textExtent((String)"000. ").x;
    }

    protected String getBulletCharacter(int listDepth) {
        if (listDepth >= BULLETS.length) {
            return BULLETS[BULLETS.length - 1];
        }
        return BULLETS[listDepth - 1];
    }

    public void setEntityReplacer(EntityReplacer entityReplacer) {
        this.entityReplacer = entityReplacer;
    }

    public Point getPreferredSize() {
        return this.preferredSize;
    }

    public int getParagraphSpace() {
        return ScalingHelper.convertVerticalPixelToDpi(this.paragraphSpace);
    }

    public void setParagraphSpace(int paragraphSpace) {
        this.paragraphSpace = paragraphSpace;
    }

    public void setWordSplitRegex(String wordSplitRegex) {
        this.wordSplitRegex = wordSplitRegex;
    }
}

