/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.examples.jet.article2.ui;

import org.eclipse.emf.examples.jet.article2.model.Attribute;
import org.eclipse.emf.examples.jet.article2.model.Instance;
import org.eclipse.emf.examples.jet.article2.ui.WizardMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditInstanceDialog
extends Dialog {
    private Button mCheckboxDefault = null;
    private Text mTextName = null;
    private Text[] mTextAttributeValues = null;
    private Instance mInstance = null;
    private Attribute[] mAttributes = new Attribute[0];
    private String mTitle = "Edit Instance";

    public EditInstanceDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void okPressed() {
        if (this.mCheckboxDefault.getSelection()) {
            this.getInstance().setDefault();
        } else if (this.getInstance().getType().getDefaultInstance() == this.getInstance()) {
            this.getInstance().getType().setDefaultInstance(null);
        }
        this.getInstance().setName(this.mTextName.getText());
        int i = 0;
        while (i < this.mAttributes.length) {
            String name = this.mAttributes[i].getName();
            String value = this.mTextAttributeValues[i].getText();
            this.getInstance().getValues().put(name, value);
            ++i;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        Composite panel = new Composite(result, 0);
        panel.setLayout((Layout)new GridLayout(2, false));
        panel.setLayoutData((Object)new GridData(1808));
        Label name = new Label(panel, 0);
        name.setText(WizardMessages.getString("NewEnumWizPageInst.col.Name"));
        this.mTextName = new Text(panel, 2052);
        this.mTextName.setLayoutData((Object)new GridData(768));
        this.mTextAttributeValues = new Text[this.mAttributes.length];
        int i = 0;
        while (i < this.mAttributes.length) {
            Label label = new Label(panel, 0);
            Object[] attr = new String[]{this.mAttributes[i].getType(), this.mAttributes[i].getName()};
            label.setText(WizardMessages.getFormattedString("EditInstanceDialog.attribute.Value", attr));
            this.mTextAttributeValues[i] = new Text(panel, 2052);
            this.mTextAttributeValues[i].setLayoutData((Object)new GridData(768));
            ++i;
        }
        Label defaultInstance = new Label(panel, 0);
        defaultInstance.setText(WizardMessages.getString("NewEnumWizPageInst.col.Default"));
        this.mCheckboxDefault = new Button(panel, 32);
        this.initWidgetValues();
        this.hookListeners();
        this.mTextName.forceFocus();
        return result;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.validateInput();
        return result;
    }

    private void initWidgetValues() {
        if (this.getInstance() == null) {
            throw new IllegalStateException("Instance not set; cannot initialize");
        }
        this.mCheckboxDefault.setSelection(this.getInstance().isDefault());
        this.mTextName.setText(this.getInstance().getName());
        int i = 0;
        while (i < this.mTextAttributeValues.length) {
            String value = this.getInstance().getAttributeValue(this.getAttributes()[i]);
            value = value == null ? "" : value;
            this.mTextAttributeValues[i].setText(value);
            ++i;
        }
    }

    private void hookListeners() {
        this.mTextName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditInstanceDialog.this.validateInput();
            }
        });
        int i = 0;
        while (i < this.mTextAttributeValues.length) {
            this.mTextAttributeValues[i].addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EditInstanceDialog.this.validateInput();
                }
            });
            ++i;
        }
    }

    private void validateInput() {
        boolean hasName = this.mTextName.getText().trim().length() > 0;
        boolean hasAllValues = true;
        int i = 0;
        while (i < this.mTextAttributeValues.length) {
            boolean hasValue = this.mTextAttributeValues[i].getText().trim().length() > 0;
            hasAllValues &= hasValue;
            ++i;
        }
        boolean enabled = hasName && hasAllValues;
        this.getButton(0).setEnabled(enabled);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getTitle());
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public Instance getInstance() {
        return this.mInstance;
    }

    public void setInstance(Instance instance) {
        this.mInstance = instance;
    }

    public Attribute[] getAttributes() {
        return this.mAttributes;
    }

    public void setAttributes(Attribute[] attributes) {
        if (attributes == null) {
            attributes = new Attribute[]{};
        }
        this.mAttributes = attributes;
    }
}

