/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.examples.jet.article2.model;

import java.util.Iterator;
import java.util.Properties;
import org.eclipse.emf.examples.jet.article2.model.Attribute;
import org.eclipse.emf.examples.jet.article2.model.NameUtil;
import org.eclipse.emf.examples.jet.article2.model.TypesafeEnum;

public class Instance {
    private TypesafeEnum mType = null;
    private String mName = "";
    private Properties mValues = new Properties();

    public Instance() {
    }

    public Instance(String name) {
        this.mName = name;
    }

    public Instance(String name, Properties values) {
        this.mName = name;
        this.mValues = values;
    }

    public String keyDescription() {
        this.assertTypeNotNull();
        StringBuffer result = new StringBuffer();
        Iterator<Attribute> i = this.mType.keyAttributes();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            result.append(attribute.getCappedName());
            result.append(" = ");
            result.append(this.getAttributeValue(attribute));
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public String constructorValues() {
        this.assertTypeNotNull();
        StringBuffer result = new StringBuffer();
        Iterator<Attribute> i = this.getType().attributes();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            result.append(this.getAttributeValue(attribute));
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public String getCappedName() {
        return NameUtil.constantToJavaClassName(this.getName());
    }

    public String getName() {
        return this.mName;
    }

    public Properties getValues() {
        return this.mValues;
    }

    public String getAttributeValue(Attribute attribute) {
        return this.getAttributeValue(attribute.getName());
    }

    public String getAttributeValue(String attributeName) {
        return this.mValues.getProperty(attributeName);
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setValues(Properties values) {
        this.mValues = values;
    }

    public TypesafeEnum getType() {
        return this.mType;
    }

    void setType(TypesafeEnum type) {
        this.mType = type;
    }

    public boolean isDefault() {
        this.assertTypeNotNull();
        return this.getType().getDefaultInstance() == this;
    }

    public void setDefault() {
        this.assertTypeNotNull();
        this.getType().setDefaultInstance(this);
    }

    private void assertTypeNotNull() {
        if (this.getType() == null) {
            throw new IllegalStateException("Type is null. This instance has not been added to a type yet.");
        }
    }
}

