/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.bigmde2016.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Families.FamiliesFactory;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Families.Family;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Families.Member;

public class FamiliesGenerator {
    public static @NonNull List<@NonNull ? extends EObject> createFamiliesModel(int nFamilies, int nMembersPerFamily) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ArrayList<Family> families = new ArrayList<Family>(nFamilies);
        ArrayList<Member> sons = new ArrayList<Member>();
        ArrayList<Member> daughters = new ArrayList<Member>();
        int membersToGo = nFamilies * (nMembersPerFamily - 2);
        int f = 0;
        while (f < nFamilies) {
            Family family = FamiliesFactory.eINSTANCE.createFamily();
            families.add(family);
            family.setLastName("family" + f);
            int familiesToGo = nFamilies - f;
            Member father = FamiliesFactory.eINSTANCE.createMember();
            father.setFirstName("father" + f);
            family.setFather(father);
            Member mother = FamiliesFactory.eINSTANCE.createMember();
            mother.setFirstName("mother" + f);
            family.setMother(mother);
            int nMembers = familiesToGo <= 1 ? membersToGo : 2 * random.nextInt(membersToGo + 1) / familiesToGo;
            int m = 0;
            while (m < nMembers) {
                Member member = FamiliesFactory.eINSTANCE.createMember();
                if (random.nextBoolean()) {
                    family.getSons().add((Object)member);
                } else {
                    family.getDaughters().add((Object)member);
                }
                member.setFirstName("member" + --membersToGo);
                ++m;
            }
            sons.addAll((Collection<Member>)family.getSons());
            daughters.addAll((Collection<Member>)family.getDaughters());
            ++f;
        }
        assert (2 * families.size() + sons.size() + daughters.size() == nFamilies * nMembersPerFamily);
        return families;
    }

    public static void garbageCollect() throws InterruptedException {
        int y = 0;
        while (y < 5) {
            System.gc();
            Thread.sleep(100L);
            ++y;
        }
    }
}

