/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ContainmentAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.InheritanceAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.TransformationAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.analysis.DomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcore.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class DatumCaches {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull RootDomainUsageAnalysis domainUsageAnalysis;
    protected final @NonNull ContainmentAnalysis containmentAnalysis;
    protected final @NonNull CompleteModel completeModel;
    private @NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull CompleteClass, @NonNull ClassDatum>> typedModel2completeClass2classDatum = new HashMap<TypedModel, Map<CompleteClass, ClassDatum>>();
    private @NonNull Map<@NonNull ClassDatum, @NonNull Map<@NonNull Property, @NonNull PropertyDatum>> classDatum2property2propertyDatum = new HashMap<ClassDatum, Map<Property, PropertyDatum>>();

    protected DatumCaches(@NonNull ScheduleManager scheduleManager) {
        this.scheduleManager = scheduleManager;
        this.domainUsageAnalysis = scheduleManager.getDomainUsageAnalysis();
        EnvironmentFactory environmentFactory = scheduleManager.getEnvironmentFactory();
        this.containmentAnalysis = new ContainmentAnalysis(environmentFactory);
        this.completeModel = environmentFactory.getCompleteModel();
    }

    private @NonNull Set<@NonNull PropertyDatum> analyseOclContainerCall(@NonNull TypedModel typedModel, @NonNull CompleteClass context) {
        InheritanceAnalysis inheritanceAnalysis = this.containmentAnalysis.getInheritanceAnalysis();
        HashSet<@NonNull PropertyDatum> result = new HashSet<PropertyDatum>();
        for (CompleteClass parentClass : this.containmentAnalysis.getContainerClasses(context)) {
            for (Property prop : parentClass.getProperties(FeatureFilter.SELECT_NON_STATIC)) {
                CompleteClass elementClass;
                Set<CompleteClass> allSuperAndSubClasses;
                if (!prop.isIsComposite() || !(allSuperAndSubClasses = inheritanceAnalysis.getAllSuperAndSelfAndSubClasses(context)).contains(elementClass = this.getElementClass((TypedElement)prop))) continue;
                result.add(this.getPropertyDatum(typedModel, parentClass, prop));
            }
        }
        return result;
    }

    protected abstract @Nullable RuleRegion analyzeRule(@NonNull RuleAnalysis var1);

    public void analyzeTransformation(@NonNull TransformationAnalysis transformationAnalysis) {
        for (Rule rule : QVTbaseUtil.getOwnedRules((Transformation)transformationAnalysis.getTransformation())) {
            this.analyzeRule(transformationAnalysis.getRuleAnalysis(rule));
        }
    }

    private boolean assertValidTypedModel(@NonNull TypedModel typedModel, @NonNull CompleteClass completeClass) {
        @NonNull Class aType = completeClass.getPrimaryClass();
        Type elementType = QVTbaseUtil.getElementalType((Type)aType);
        if (elementType instanceof DataType ? !$assertionsDisabled && typedModel != this.domainUsageAnalysis.getPrimitiveTypeModel() : !$assertionsDisabled && typedModel == null) {
            throw new AssertionError();
        }
        return true;
    }

    private @NonNull Set<@NonNull CompleteClass> computeContexts(@NonNull OCLExpression oclExp, @NonNull Map<@NonNull Variable, @NonNull Set<@NonNull CompleteClass>> variable2BoundContext) {
        HashSet<@NonNull CompleteClass> result = new HashSet<CompleteClass>();
        if (oclExp instanceof VariableExp) {
            VariableExp varExp = (VariableExp)oclExp;
            Set<@NonNull CompleteClass> context = variable2BoundContext.get(varExp.getReferredVariable());
            if (context != null) {
                result.addAll(context);
            } else {
                result.add(this.completeModel.getCompleteClass(QVTbaseUtil.getType((TypedElement)varExp)));
            }
        } else if (oclExp instanceof CallExp) {
            CallExp callExp = (CallExp)oclExp;
            if (callExp instanceof OperationCallExp && this.isOclContainerOp(QVTbaseUtil.getReferredOperation((CallExp)callExp))) {
                OCLExpression ownedSource = QVTbaseUtil.getOwnedSource((CallExp)callExp);
                for (CompleteClass oclContainerOpContext : this.computeContexts(ownedSource, variable2BoundContext)) {
                    Iterables.addAll(result, this.containmentAnalysis.getContainerClasses(oclContainerOpContext));
                }
            } else {
                result.add(this.completeModel.getCompleteClass(QVTbaseUtil.getType((TypedElement)callExp)));
            }
        } else if (oclExp instanceof ShadowExp) {
            result.add(this.completeModel.getCompleteClass(QVTbaseUtil.getType((TypedElement)oclExp)));
        } else {
            throw new IllegalStateException("OCLExpression has not been considered yet");
        }
        return result;
    }

    public @NonNull Iterable<@NonNull PropertyDatum> getAllPropertyDatums(@NonNull ClassDatum classDatum) {
        return this.getAllPropertyDatumsInternal(new HashSet<ClassDatum>(), new HashSet<PropertyDatum>(), classDatum);
    }

    private @NonNull Iterable<@NonNull PropertyDatum> getAllPropertyDatumsInternal(@NonNull Set<@NonNull ClassDatum> classDatums, @NonNull Set<@NonNull PropertyDatum> propertyDatums, @NonNull ClassDatum cDatum) {
        if (classDatums.add(cDatum)) {
            Iterables.addAll(propertyDatums, (Iterable)QVTscheduleUtil.getOwnedPropertyDatums((ClassDatum)cDatum));
        }
        for (ClassDatum superClassDatum : this.scheduleManager.getSuperClassDatums(cDatum)) {
            if (superClassDatum == cDatum) continue;
            this.getAllPropertyDatumsInternal(classDatums, propertyDatums, superClassDatum);
        }
        return propertyDatums;
    }

    public @NonNull ClassDatum getClassDatum(@NonNull TypedModel typedModel, @NonNull Class asClass) {
        CompleteClass completeClass = this.completeModel.getCompleteClass((Type)asClass);
        return this.getClassDatum(typedModel, completeClass);
    }

    public @NonNull ClassDatum getClassDatum(@NonNull TypedModel typedModel, @NonNull CompleteClass completeClass) {
        ClassDatum classDatum;
        assert (this.assertValidTypedModel(typedModel, completeClass));
        Map<@NonNull CompleteClass, @NonNull ClassDatum> completeClass2classDatums = this.typedModel2completeClass2classDatum.get(typedModel);
        if (completeClass2classDatums == null) {
            completeClass2classDatums = new HashMap<CompleteClass, ClassDatum>();
            this.typedModel2completeClass2classDatum.put(typedModel, completeClass2classDatums);
        }
        if ((classDatum = completeClass2classDatums.get(completeClass)) == null) {
            classDatum = QVTscheduleFactory.eINSTANCE.createClassDatum();
            classDatum.setOwningScheduleModel(this.scheduleManager.getScheduleModel());
            classDatum.setCompleteClass(completeClass);
            classDatum.setReferredClass(completeClass.getPrimaryClass());
            classDatum.setName(completeClass.getPrimaryClass().getName());
            classDatum.setReferredTypedModel(typedModel);
            @NonNull Class aClass = completeClass.getPrimaryClass();
            boolean cfr_ignored_0 = aClass instanceof DataType;
            completeClass2classDatums.put(completeClass, classDatum);
        }
        return classDatum;
    }

    private @NonNull Set<@NonNull CompleteClass> getComputedContexts(@NonNull CallExp callExp, @NonNull Map<@NonNull Variable, @NonNull Set<@NonNull CompleteClass>> variable2BoundContext) {
        OCLExpression source = QVTbaseUtil.getOwnedSource((CallExp)callExp);
        return this.computeContexts(source, variable2BoundContext);
    }

    public @NonNull ContainmentAnalysis getContainmentAnalysis() {
        return this.containmentAnalysis;
    }

    protected @NonNull CompleteClass getElementClass(@NonNull TypedElement typedElement) {
        Type type = QVTbaseUtil.getElementalType((Type)QVTbaseUtil.getType((TypedElement)typedElement));
        return this.completeModel.getCompleteClass(type);
    }

    protected @NonNull Set<@NonNull PropertyDatum> getOperationPropertyDatums(@NonNull OperationCallExp opCall, @NonNull CompleteClass context, @NonNull Map<@NonNull CompleteClass, @NonNull Set<@NonNull Operation>> type2VisitedOps, @NonNull Map<@NonNull Variable, @NonNull Set<@NonNull CompleteClass>> variable2BoundContext) {
        Set<@NonNull Operation> visitedOps = type2VisitedOps.get(context);
        if (visitedOps == null) {
            visitedOps = new HashSet<Operation>();
            type2VisitedOps.put(context, visitedOps);
        }
        HashSet<@NonNull PropertyDatum> result = new HashSet<PropertyDatum>();
        Operation op = QVTbaseUtil.getReferredOperation((CallExp)opCall);
        if (!visitedOps.contains(op)) {
            visitedOps.add(op);
            if (this.isOclContainerOp(op)) {
                for (TypedModel typedModel : this.getTypedModels((Element)context.getPrimaryClass())) {
                    for (CompleteClass newContext : this.getComputedContexts((CallExp)opCall, variable2BoundContext)) {
                        result.addAll(this.analyseOclContainerCall(typedModel, newContext));
                    }
                }
            } else {
                result.addAll(this.getOperationPropertyDatums(op, context, type2VisitedOps));
            }
        }
        return result;
    }

    private @NonNull Set<@NonNull PropertyDatum> getOperationPropertyDatums(@NonNull Operation operation, @NonNull CompleteClass context, @NonNull Map<@NonNull CompleteClass, @NonNull Set<@NonNull Operation>> type2VisitedOps) {
        ExpressionInOCL expInOCL;
        HashSet<@NonNull PropertyDatum> result = new HashSet<PropertyDatum>();
        LanguageExpression langExp = operation.getBodyExpression();
        if (langExp instanceof ExpressionInOCL && (expInOCL = (ExpressionInOCL)langExp).getOwnedBody() != null) {
            HashMap<@NonNull Variable, @NonNull Set<@NonNull CompleteClass>> variable2BoundContext = new HashMap<Variable, Set<CompleteClass>>();
            HashSet<@NonNull CompleteClass> boundContexts = new HashSet<CompleteClass>();
            boundContexts.add(context);
            Variable ownedContext = expInOCL.getOwnedContext();
            if (ownedContext != null) {
                variable2BoundContext.put(ownedContext, boundContexts);
            }
            for (EObject eObject : new TreeIterable((EObject)expInOCL, true)) {
                if (eObject instanceof LetExp) {
                    this.updateVariableBindings((LetExp)eObject, variable2BoundContext);
                    continue;
                }
                if (eObject instanceof NavigationCallExp) {
                    NavigationCallExp navCallExp = (NavigationCallExp)eObject;
                    Property property = QVTbaseUtil.getReferredProperty((NavigationCallExp)navCallExp);
                    OCLExpression ownedSource = QVTbaseUtil.getOwnedSource((CallExp)navCallExp);
                    TypedModel typedModel = this.getTypedModel((Element)ownedSource);
                    for (CompleteClass newContext : this.getComputedContexts((CallExp)navCallExp, variable2BoundContext)) {
                        PropertyDatum propertyDatum = this.getPropertyDatum(typedModel, newContext, property);
                        result.add(propertyDatum);
                    }
                    continue;
                }
                if (!(eObject instanceof OperationCallExp)) continue;
                OperationCallExp opCallExp = (OperationCallExp)eObject;
                for (CompleteClass newContext : this.getComputedContexts((CallExp)opCallExp, variable2BoundContext)) {
                    result.addAll(this.getOperationPropertyDatums(opCallExp, newContext, type2VisitedOps, variable2BoundContext));
                }
            }
        }
        return result;
    }

    protected @NonNull PropertyDatum getPropertyDatum(@NonNull TypedModel typedModel, @NonNull Class context, @NonNull Property property) {
        CompleteClass completeClass = this.completeModel.getCompleteClass((Type)context);
        return this.getPropertyDatum(typedModel, completeClass, property);
    }

    protected @NonNull PropertyDatum getPropertyDatum(@NonNull TypedModel typedModel, @NonNull CompleteClass completeClass, @NonNull Property property) {
        ClassDatum classDatum = this.getClassDatum(typedModel, completeClass);
        return this.getPropertyDatum(classDatum, property);
    }

    public @NonNull PropertyDatum getPropertyDatum(@NonNull ClassDatum classDatum, @NonNull Property property) {
        PropertyDatum cachedPropertyDatum;
        Iterable<@NonNull PropertyDatum> allPropertyDatums = this.getAllPropertyDatums(classDatum);
        Map<@NonNull Property, @NonNull PropertyDatum> property2propertyDatum = this.classDatum2property2propertyDatum.get(classDatum);
        if (property2propertyDatum == null) {
            property2propertyDatum = new HashMap<Property, PropertyDatum>();
            this.classDatum2property2propertyDatum.put(classDatum, property2propertyDatum);
        }
        if ((cachedPropertyDatum = property2propertyDatum.get(property)) != null) {
            return cachedPropertyDatum;
        }
        for (PropertyDatum propertyDatum : allPropertyDatums) {
            if (!propertyDatum.getReferredProperty().equals(property)) continue;
            return propertyDatum;
        }
        TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
        CompleteClass targetCompleteClass = classDatum.getCompleteClass();
        Class owningClass = QVTbaseUtil.getOwningClass((Property)property);
        CompleteClass hostCompleteClass = this.completeModel.getCompleteClass((Type)owningClass);
        PropertyDatum propertyDatum = QVTscheduleFactory.eINSTANCE.createPropertyDatum();
        propertyDatum.setReferredTypedModel(typedModel);
        propertyDatum.setReferredProperty(property);
        propertyDatum.setName(property.getName());
        propertyDatum.setOwningClassDatum(classDatum);
        assert (targetCompleteClass.conformsTo(hostCompleteClass));
        for (CompleteClass superCompleteClass : targetCompleteClass.getSuperCompleteClasses()) {
            if (!superCompleteClass.conformsTo(hostCompleteClass)) continue;
            PropertyDatum superPropDatum = this.getPropertyDatum(typedModel, superCompleteClass, property);
            propertyDatum.getSuperPropertyDatums().add((Object)superPropDatum);
        }
        PropertyDatum oldPropertyDatum = property2propertyDatum.put(property, propertyDatum);
        assert (oldPropertyDatum == null);
        return propertyDatum;
    }

    public @NonNull PropertyDatum getSuccessPropertyDatum(@NonNull Property successProperty) {
        Class owningClass = QVTbaseUtil.getOwningClass((Property)successProperty);
        TypedModel typedModel = this.getTypedModel((Element)owningClass);
        return this.getPropertyDatum(typedModel, owningClass, successProperty);
    }

    protected @NonNull TypedModel getTypedModel(@NonNull Element element) {
        DomainUsage domainUsage = this.getUsage(element);
        if (domainUsage == null) {
            this.getUsage(element);
            throw new IllegalStateException("No DomainUsage for " + element);
        }
        Iterator<TypedModel> typedModels = this.getTypedModels(element).iterator();
        if (!typedModels.hasNext()) {
            throw new IllegalStateException("No TypedModel for " + element);
        }
        @NonNull TypedModel typedModel = typedModels.next();
        if (typedModels.hasNext()) {
            this.getUsage(element);
            throw new IllegalStateException("Ambiguous TypedModel: " + domainUsage + " for " + element);
        }
        return typedModel;
    }

    private @NonNull Iterable<@NonNull TypedModel> getTypedModels(@NonNull Element element) {
        DomainUsage domainUsage = this.getUsage(element);
        if (domainUsage == null) {
            this.getUsage(element);
            throw new IllegalStateException("No DomainUsage for " + element);
        }
        return domainUsage.getTypedModels();
    }

    protected @Nullable DomainUsage getUsage(@NonNull Element element) {
        Operation operation = QVTbaseUtil.getContainingOperation((EObject)element);
        if (operation != null) {
            DomainUsageAnalysis analysis = this.domainUsageAnalysis.getAnalysis(operation);
            return analysis.getUsage(element);
        }
        return this.domainUsageAnalysis.getUsage(element);
    }

    private boolean isOclContainerOp(@NonNull Operation operation) {
        return operation.getOperationId() == this.domainUsageAnalysis.getOclContainerId();
    }

    private void updateVariableBindings(@NonNull LetExp letExp, @NonNull Map<@NonNull Variable, @NonNull Set<@NonNull CompleteClass>> variable2BoundContext) {
        Variable variable = QVTbaseUtil.getOwnedVariable((LetExp)letExp);
        variable2BoundContext.put(variable, this.computeContexts(QVTbaseUtil.getOwnedInit((Variable)variable), variable2BoundContext));
    }
}

