/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.internal.qvt.oml.ast.env.BasicTypeResolverImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOTypeResolver;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEnvironmentBase;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.HiddenElementAdapter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.MessageType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtTypeResolverImpl
implements QVTOTypeResolver {
    private BasicTypeResolverImpl fDelegate;
    private QvtEnvironmentBase fOwner;
    private boolean fdefinesOclAnyFeatures;
    private Map<EClassifier, List<ImperativeOperation>> fCtx2OperationMap;
    private Set<EClassifier> fAdditionalTypes;
    private Resource fResource;

    QvtTypeResolverImpl(QvtEnvironmentBase owningEnv, Resource resource) {
        if (owningEnv == null) {
            throw new IllegalArgumentException();
        }
        this.fOwner = owningEnv;
        this.fdefinesOclAnyFeatures = false;
        this.fResource = resource;
    }

    protected BasicTypeResolverImpl getDelegate() {
        if (this.fDelegate == null) {
            this.fDelegate = this.createDelegate();
        }
        return this.fDelegate;
    }

    protected BasicTypeResolverImpl createDelegate() {
        return new BasicTypeResolverImpl(this.getOwner(), this.fResource);
    }

    QvtEnvironmentBase getOwner() {
        return this.fOwner;
    }

    @Override
    public ListType resolveListType(EClassifier elementType) {
        return this.getDelegate().resolveListType(elementType);
    }

    @Override
    public DictionaryType resolveDictionaryType(EClassifier keyType, EClassifier elementType) {
        return this.getDelegate().resolveDictionaryType(keyType, elementType);
    }

    public void collectAdditionalOperationsInTypeHierarchy(EClassifier type, boolean subTypesOnly, Collection<EOperation> result) {
        if (this.fAdditionalTypes != null) {
            for (EClassifier nextType : this.fAdditionalTypes) {
                boolean isPartOfHierarchy;
                boolean bl = isPartOfHierarchy = TypeUtil.getRelationship((Environment)this.fOwner, (Object)type, (Object)nextType) == 4;
                if (type == nextType || !isPartOfHierarchy) continue;
                this.getLocalAdditionalOperations(nextType, result);
            }
        }
        for (QvtEnvironmentBase nextImportEnv : this.fOwner.getImportsByExtends()) {
            nextImportEnv.getQVTTypeResolver().collectAdditionalOperationsInTypeHierarchy(type, subTypesOnly, result);
        }
        for (QvtEnvironmentBase nextImportEnv : this.fOwner.getImportsByAccess()) {
            nextImportEnv.getQVTTypeResolver().collectAdditionalOperationsInTypeHierarchy(type, subTypesOnly, result);
        }
    }

    public List<EStructuralFeature> getAdditionalAttributes(EClassifier owner) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        this.getLocalAdditionalAttributes(owner, result);
        for (QvtEnvironmentBase nextExtendedModule : this.fOwner.getAllExtendedModules()) {
            nextExtendedModule.getQVTTypeResolver().getLocalAdditionalAttributes(owner, result);
        }
        for (QvtEnvironmentBase nextImport : this.fOwner.getImportsByAccess()) {
            Module importedModule = nextImport.getModuleContextType();
            if (!(importedModule instanceof Library)) continue;
            nextImport.getQVTTypeResolver().getLocalAdditionalAttributes(owner, result);
        }
        return result;
    }

    protected void getLocalAdditionalAttributes(EClassifier owner, List<EStructuralFeature> result) {
        this.extractIntermediateProperties(owner, result);
        result.addAll(this.getDelegate().getAdditionalAttributes(owner));
    }

    public List<EOperation> getAdditionalOperations(EClassifier owner) {
        ArrayList<EOperation> result = new ArrayList<EOperation>();
        this.getLocalAdditionalOperations(owner, result);
        for (QvtEnvironmentBase nextSiblingEnv : this.fOwner.getAllExtendedModules()) {
            nextSiblingEnv.getQVTTypeResolver().getLocalAdditionalOperations(owner, result);
        }
        for (QvtEnvironmentBase nextSiblingEnv : this.fOwner.getImportsByAccess()) {
            Module importedModule = nextSiblingEnv.getModuleContextType();
            if (!(importedModule instanceof Library)) continue;
            nextSiblingEnv.getQVTTypeResolver().getLocalAdditionalOperations(owner, result);
        }
        return result;
    }

    private void extractContextualOperations(EClassifier context, Collection<EOperation> result) {
        if (this.fCtx2OperationMap == null) {
            return;
        }
        List<ImperativeOperation> operList = this.fCtx2OperationMap.get(context);
        if (operList != null) {
            result.addAll(operList);
            return;
        }
        for (EClassifier ctx : this.fCtx2OperationMap.keySet()) {
            if (!TypeUtil.exactTypeMatch((Environment)this.fOwner, (Object)ctx, (Object)context) || (operList = this.fCtx2OperationMap.get(ctx)) == null) continue;
            result.addAll(operList);
            return;
        }
    }

    private void extractIntermediateProperties(EClassifier context, Collection<EStructuralFeature> result) {
        if (context instanceof EClass) {
            Module moduleType = this.fOwner.getModuleContextType();
            if (moduleType == null) {
                return;
            }
            for (EStructuralFeature property : moduleType.getEStructuralFeatures()) {
                ContextualProperty ctxProperty;
                EClass nextContext;
                if (!(property instanceof ContextualProperty) || HiddenElementAdapter.isMarkedAsHidden((EObject)property) || (nextContext = (ctxProperty = (ContextualProperty)property).getContext()) == null || nextContext != context) continue;
                result.add(ctxProperty);
            }
        }
    }

    protected void getLocalAdditionalOperations(EClassifier owner, Collection<EOperation> result) {
        this.extractContextualOperations(owner, result);
        boolean isCollectionTypeOwner = owner instanceof org.eclipse.ocl.types.CollectionType;
        if (this.fdefinesOclAnyFeatures && !isCollectionTypeOwner && !(owner instanceof TupleType)) {
            this.extractContextualOperations((EClassifier)this.fOwner.getOCLStandardLibrary().getOclAny(), result);
        }
        result.addAll(this.getDelegate().getAdditionalOperations(owner));
        if (this.fdefinesOclAnyFeatures && !isCollectionTypeOwner && !(owner instanceof TupleType)) {
            result.addAll(this.getDelegate().getAdditionalOperations((EClassifier)this.fOwner.getOCLStandardLibrary().getOclAny()));
        }
        if (owner == this.fOwner.getOCLStandardLibrary().getInteger()) {
            EClassifier oclReal = (EClassifier)this.fOwner.getOCLStandardLibrary().getReal();
            this.getLocalAdditionalOperations(oclReal, result);
        } else if (isCollectionTypeOwner) {
            this.getLocalCollectionAdditionalOperations((CollectionType)owner, result, false);
        }
    }

    public Resource getResource() {
        if (this.fResource != null) {
            return this.fResource;
        }
        return this.getDelegate().getResource();
    }

    public EClassifier resolve(EClassifier type) {
        return this.getDelegate().resolve(type);
    }

    public EStructuralFeature resolveAdditionalAttribute(EClassifier owner, EStructuralFeature property) {
        return (EStructuralFeature)this.getDelegate().resolveAdditionalAttribute(owner, property);
    }

    public EOperation resolveAdditionalOperation(EClassifier owner, EOperation operation) {
        if (!this.fdefinesOclAnyFeatures && owner == this.fOwner.getOCLStandardLibrary().getOclAny()) {
            this.fdefinesOclAnyFeatures = true;
        }
        if (operation instanceof ImperativeOperation) {
            List<ImperativeOperation> operList;
            if (this.fCtx2OperationMap == null) {
                this.fCtx2OperationMap = new LinkedHashMap<EClassifier, List<ImperativeOperation>>();
            }
            if ((operList = this.fCtx2OperationMap.get(owner)) == null) {
                operList = new ArrayList<ImperativeOperation>();
                this.fCtx2OperationMap.put(owner, operList);
            }
            this.addAdditionalType(owner);
            operList.add((ImperativeOperation)operation);
            return operation;
        }
        EOperation resolve = (EOperation)this.getDelegate().resolveAdditionalOperation(owner, operation);
        if (resolve != null) {
            this.addAdditionalType(owner);
        }
        return resolve;
    }

    public org.eclipse.ocl.types.CollectionType<EClassifier, EOperation> resolveCollectionType(CollectionKind kind, EClassifier elementType) {
        return this.getDelegate().resolveCollectionType(kind, elementType);
    }

    public MessageType<EClassifier, EOperation, EStructuralFeature> resolveOperationMessageType(EOperation operation) {
        return this.getDelegate().resolveOperationMessageType(operation);
    }

    public MessageType<EClassifier, EOperation, EStructuralFeature> resolveSignalMessageType(EClassifier signal) {
        return this.getDelegate().resolveSignalMessageType(signal);
    }

    public TupleType<EOperation, EStructuralFeature> resolveTupleType(EList<? extends TypedElement<EClassifier>> parts) {
        return this.getDelegate().resolveTupleType(parts);
    }

    public TypeType<EClassifier, EOperation> resolveTypeType(EClassifier type) {
        return this.getDelegate().resolveTypeType(type);
    }

    UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> uml() {
        return this.fOwner.getUMLReflection();
    }

    private void addAdditionalType(EClassifier type) {
        if (this.fAdditionalTypes == null) {
            this.fAdditionalTypes = new LinkedHashSet<EClassifier>();
        }
        this.fAdditionalTypes.add(type);
    }

    void getLocalCollectionAdditionalOperations(CollectionType collectionType, Collection<EOperation> result, boolean includeSuperTypes) {
        if (this.fAdditionalTypes == null) {
            return;
        }
        for (EClassifier nextType : this.fAdditionalTypes) {
            boolean isMatchingType;
            if (!(nextType instanceof CollectionType)) continue;
            boolean bl = isMatchingType = includeSuperTypes ? TypeUtil.compatibleTypeMatch((Environment)this.fOwner, (Object)collectionType, (Object)nextType) : TypeUtil.exactTypeMatch((Environment)this.fOwner, (Object)collectionType, (Object)nextType);
            if (!isMatchingType) continue;
            this.extractContextualOperations(nextType, result);
            result.addAll(this.fDelegate.getAllCompatibleAdditionalOperations((CollectionType)nextType));
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.fOwner.toString();
    }
}

