/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.ActionMessages;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.BracketInserter;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.FoldingStructureUpdater;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.IQVTReconcilingListener;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.OverrideIndicatorManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.ProblemUpdater;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtConfiguration;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtDocumentProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditorSelectionChangedListener;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtPairMatcher;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtReconciler;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.actions.OpenDeclarationAction;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.QVTColorManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.SemanticHighlightingManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineContentProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineInput;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineLabelProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineNodeSelector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineSelectionListener;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilder;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.project.builder.WorkspaceUnitResolver;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class QvtEditor
extends TextEditor
implements IQVTReconcilingListener {
    public static final String ID = "org.eclipse.m2m.qvt.oml.editor.ui.QvtEditor";
    public static final String MATCHING_BRACKETS = "matchingBrackets";
    public static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColors";
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    private static final String QVT_EDITOR_UI_CONTEXT = "org.eclipse.m2m.qvt.oml.editor.ui.context";
    private static final String ID_PACKAGES = "org.eclipse.jdt.ui.PackageExplorer";
    private ProjectionSupport myProjectionSupport;
    private ContentOutlinePage myOutlinePage;
    private TreeViewer myTreeViewer;
    private QVTColorManager myColorManager;
    private QvtPairMatcher myBracketMatcher = new QvtPairMatcher(BRACKETS);
    private QvtEditorSelectionChangedListener mySelectionChangedListener;
    private QvtOutlineSelectionListener myOutlineSelectionListener;
    private QvtOutlineNodeSelector myOutlineSelector;
    private BracketInserter myBracketInserter;
    private ASTProvider fASTProvider;
    private UnitProxy fUnitProxy;
    private Object fASTProviderLock = new Object();
    private QvtReconciler fReconciler;
    private OverrideIndicatorManager fOverrideIndicatorManager;
    private FoldingStructureUpdater fFoldingUpdater;
    private List<IQVTReconcilingListener> fReconcileListeners = new LinkedList<IQVTReconcilingListener>();
    private QVTOBuilder.BuildListener myBuildListener = new QVTOBuilder.BuildListener(){

        public void buildPerformed() {
        }
    };

    public QvtEditor() {
        this.setRulerContextMenuId("#QvtoEditorRulerContext");
        this.setEditorContextMenuId("#QvtoEditorContext");
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{QVT_EDITOR_UI_CONTEXT});
    }

    public void dispose() {
        if (this.myBracketMatcher != null) {
            this.myBracketMatcher.dispose();
            this.myBracketMatcher = null;
        }
        if (this.myColorManager != null) {
            this.myColorManager.dispose();
            this.myColorManager = null;
        }
        if (this.mySelectionChangedListener != null) {
            this.mySelectionChangedListener.uninstall();
            this.mySelectionChangedListener = null;
        }
        if (this.myBuildListener != null) {
            QVTOBuilder.removeBuildListener((QVTOBuilder.BuildListener)this.myBuildListener);
            this.myBuildListener = null;
        }
        if (this.fASTProvider != null) {
            this.fASTProvider.dispose();
        }
        super.dispose();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.fUnitProxy = WorkspaceUnitResolver.getUnit((IFile)fileInput.getFile());
        }
        if (QvtEditor.isEditingInQVTSourceContainer(input)) {
            this.installProblemUpdater();
        }
        this.installOverrideIndicator();
    }

    protected void installProblemUpdater() {
        IAnnotationModel annotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel != null) {
            this.addReconcilingListener(new ProblemUpdater(annotationModel));
        }
    }

    protected void installOverrideIndicator() {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (model != null) {
            this.fOverrideIndicatorManager = new OverrideIndicatorManager(model);
            this.addReconcilingListener(this.fOverrideIndicatorManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aboutToBeReconciled() {
        IQVTReconcilingListener[] listeners = null;
        List<IQVTReconcilingListener> list = this.fReconcileListeners;
        synchronized (list) {
            listeners = this.fReconcileListeners.toArray(new IQVTReconcilingListener[this.fReconcileListeners.size()]);
        }
        IQVTReconcilingListener[] iQVTReconcilingListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IQVTReconcilingListener listener = iQVTReconcilingListenerArray[n2];
            listener.aboutToBeReconciled();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconciled(CompiledUnit unit, IProgressMonitor monitor) {
        IQVTReconcilingListener[] listeners = null;
        List<IQVTReconcilingListener> list = this.fReconcileListeners;
        synchronized (list) {
            listeners = this.fReconcileListeners.toArray(new IQVTReconcilingListener[this.fReconcileListeners.size()]);
        }
        IQVTReconcilingListener[] iQVTReconcilingListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IQVTReconcilingListener listener = iQVTReconcilingListenerArray[n2];
            if (monitor != null && monitor.isCanceled()) break;
            listener.reconciled(unit, monitor);
            ++n2;
        }
        if (monitor != null && !monitor.isCanceled()) {
            this.refresh(unit);
        }
    }

    public UnitProxy getUnit() {
        return this.fUnitProxy;
    }

    public void doSave(IProgressMonitor progress) {
        super.doSave(progress);
        CompiledUnit unit = ((QvtDocumentProvider)this.getDocumentProvider()).getCompiledModule();
        if (unit != null) {
            this.refresh(unit);
        }
    }

    void selectionChanged(TextSelection selection) {
        if (this.myTreeViewer != null && !this.myTreeViewer.getControl().isDisposed()) {
            this.myTreeViewer.removeSelectionChangedListener((ISelectionChangedListener)this.myOutlineSelectionListener);
            try {
                if (this.isOutlineVisible()) {
                    this.myOutlineSelector.selectCorrespondingNode(selection);
                }
            }
            catch (RuntimeException e) {
                Activator.log(e);
            }
            this.myTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this.myOutlineSelectionListener);
        }
        this.updateStatusLine();
    }

    protected void updateStatusLine() {
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            return this.myOutlinePage;
        }
        if (IShowInTargetList.class.equals((Object)required)) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.navigator.ProjectExplorer", QvtEditor.ID_PACKAGES};
                }
            };
        }
        if (UnitProxy.class.equals((Object)required)) {
            return this.getUnit();
        }
        return super.getAdapter(required);
    }

    public void forceReconciling() {
        SrcViewer srcViewer = (SrcViewer)this.getSourceViewer();
        IReconciler reconciler = srcViewer.getReconciler();
        if (reconciler instanceof QvtReconciler) {
            QvtReconciler qvtReconciler = (QvtReconciler)reconciler;
            qvtReconciler.doForceReconciling();
            return;
        }
        if (this.fReconciler != null) {
            this.fReconciler.doForceReconciling();
        }
    }

    public ISourceViewer getSourceViewerOpened() {
        return this.getSourceViewer();
    }

    public QvtDocumentProvider getQVTDocumentProvider() {
        return (QvtDocumentProvider)this.getDocumentProvider();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setDocumentProvider((IDocumentProvider)new QvtDocumentProvider());
        this.setPreferenceStore(this.createCombinedPreferenceStore(null));
        this.myColorManager = new QVTColorManager(this.getPreferenceStore(), Activator.getDefault().getColorManager());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new QvtConfiguration((ITextEditor)this, this.myColorManager, this.getPreferenceStore()));
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            if (this.myColorManager != null) {
                this.myColorManager.propertyChange(event);
                this.getSourceViewer().invalidateTextPresentation();
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    public void createPartControl(Composite parent) {
        ProjectionViewer projectionSourceViewer;
        IDocument document;
        super.createPartControl(parent);
        this.myOutlinePage = new ContentOutlinePage(){

            public void createControl(Composite parent) {
                super.createControl(parent);
                QvtEditor.this.myTreeViewer = this.getTreeViewer();
                QvtEditor.this.myTreeViewer.setContentProvider((IContentProvider)new QvtOutlineContentProvider());
                QvtEditor.this.myTreeViewer.setLabelProvider((IBaseLabelProvider)new QvtOutlineLabelProvider());
                QvtEditor.this.myOutlineSelectionListener = new QvtOutlineSelectionListener(QvtEditor.this.getSourceViewerOpened());
                QvtEditor.this.myTreeViewer.addSelectionChangedListener((ISelectionChangedListener)QvtEditor.this.myOutlineSelectionListener);
                QvtEditor.this.myTreeViewer.addDoubleClickListener((IDoubleClickListener)QvtEditor.this.myOutlineSelectionListener);
                QvtEditor.this.myOutlineSelector = new QvtOutlineNodeSelector(QvtEditor.this.myTreeViewer);
                QvtEditor.this.myTreeViewer.setInput((Object)new QvtOutlineInput());
                QvtEditor.this.myTreeViewer.getControl().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        QvtEditor.this.myTreeViewer.removeSelectionChangedListener((ISelectionChangedListener)QvtEditor.this.myOutlineSelectionListener);
                        QvtEditor.this.myTreeViewer.removeDoubleClickListener((IDoubleClickListener)QvtEditor.this.myOutlineSelectionListener);
                        QvtEditor.this.myTreeViewer = null;
                        QvtEditor.this.myOutlineSelectionListener = null;
                        QvtEditor.this.myOutlineSelector = null;
                    }
                });
            }
        };
        this.mySelectionChangedListener = new QvtEditorSelectionChangedListener(this);
        this.mySelectionChangedListener.install();
        this.myProjectionSupport = new ProjectionSupport(this.getProjectionSourceViewer(), this.getAnnotationAccess(), this.getSharedColors());
        this.myProjectionSupport.install();
        this.getProjectionSourceViewer().doOperation(19);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            if (this.myBracketInserter == null) {
                this.myBracketInserter = new BracketInserter(this.getSourceViewer());
            }
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.myBracketInserter);
        }
        this.initASTProvider();
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider != null && (document = documentProvider.getDocument((Object)this.getEditorInput())) != null && (projectionSourceViewer = this.getProjectionSourceViewer()) != null) {
            this.fFoldingUpdater = new FoldingStructureUpdater(projectionSourceViewer);
            this.addReconcilingListener(this.fFoldingUpdater);
        }
        new SemanticHighlightingManager().install(this, (SrcViewer)sourceViewer, this.myColorManager, this.getPreferenceStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initASTProvider() {
        Object object = this.fASTProviderLock;
        synchronized (object) {
            this.fASTProvider = new ASTProvider();
            this.addReconcilingListener(this.fASTProvider);
            this.fASTProviderLock.notifyAll();
        }
    }

    private ProjectionViewer getProjectionSourceViewer() {
        return (ProjectionViewer)this.getSourceViewer();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            super.init(site, input);
        }
        catch (PartInitException e) {
            Logger.getLogger().log(Logger.SEVERE, "Failed to initialize QVT editor", e);
            throw e;
        }
    }

    public int getTabWidth() {
        return this.getSourceViewerConfiguration().getTabWidth(this.getSourceViewer());
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.myBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void createActions() {
        super.createActions();
        Object action = new ContentAssistAction(ActionMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        action = new OpenDeclarationAction(ActionMessages.getResourceBundle(), "OpenDeclaration.", (ITextEditor)this);
        this.setAction(action.getActionDefinitionId(), (IAction)action);
    }

    private void refresh(final CompiledUnit unit) {
        IWorkbenchPartSite s = this.getSite();
        if (s == null) {
            return;
        }
        if (s.getShell() == null || s.getShell().isDisposed() || s.getShell().getDisplay() == null || s.getShell().getDisplay().isDisposed()) {
            return;
        }
        s.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (QvtEditor.this.myTreeViewer != null && !QvtEditor.this.myTreeViewer.getControl().isDisposed() && unit != null) {
                    QvtOutlineInput input = (QvtOutlineInput)QvtEditor.this.myTreeViewer.getInput();
                    input.compilationUnitUpdated(unit);
                    QvtEditor.this.myTreeViewer.refresh();
                    if (QvtEditor.this.getSelectionProvider() != null) {
                        QvtEditor.this.selectionChanged((TextSelection)QvtEditor.this.getSelectionProvider().getSelection());
                    }
                }
            }
        });
    }

    public IAnnotationModel getAnnotationModel() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        return sourceViewer != null ? sourceViewer.getAnnotationModel() : null;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        SrcViewer viewer = new SrcViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public QvtConfiguration getQvtConfiguration() {
        return (QvtConfiguration)this.getSourceViewerConfiguration();
    }

    public ISourceViewer getEditorSourceViewer() {
        return this.getSourceViewer();
    }

    public CompiledUnit getValidCompiledModule(long timeoutInMilisec) {
        return this.fASTProvider.getValidCompiledModule(timeoutInMilisec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    IQVTReconcilingListener getReconcilingListener() {
        Object object = this.fASTProviderLock;
        synchronized (object) {
            while (true) {
                if (this.fASTProvider != null) {
                    return this.fASTProvider;
                }
                try {
                    this.fASTProviderLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReconcilingListener(IQVTReconcilingListener listener) {
        List<IQVTReconcilingListener> list = this.fReconcileListeners;
        synchronized (list) {
            this.fReconcileListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeReconcilingListener(IQVTReconcilingListener listener) {
        List<IQVTReconcilingListener> list = this.fReconcileListeners;
        synchronized (list) {
            return this.fReconcileListeners.remove(listener);
        }
    }

    private static boolean isEditingInQVTSourceContainer(IEditorInput editorInput) {
        if (!(editorInput instanceof IFileEditorInput)) {
            return false;
        }
        IFile file = ((IFileEditorInput)editorInput).getFile();
        if (file != null && file.exists()) {
            try {
                IContainer srcContainer = QVTOBuilderConfig.getConfig((IProject)file.getProject()).getSourceContainer();
                if (srcContainer.exists()) {
                    IPath editedPath = file.getFullPath();
                    IPath srcPath = srcContainer.getFullPath();
                    return srcPath.isPrefixOf(editedPath);
                }
            }
            catch (CoreException e) {
                QvtPlugin.getDefault().log((Object)e.getStatus());
            }
        }
        return false;
    }

    private boolean isOutlineVisible() {
        IViewPart findView;
        if (this.getSite() == null) {
            return false;
        }
        return this.getSite().getPage() != null && (findView = this.getSite().getPage().findView("org.eclipse.ui.views.ContentOutline")) != null && findView.getViewSite().getPage().isPartVisible((IWorkbenchPart)findView);
    }

    private IPreferenceStore createCombinedPreferenceStore(IEditorInput input) {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(3);
        stores.add(Activator.getDefault().getPreferenceStore());
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    private class ASTProvider
    implements IQVTReconcilingListener {
        private IDocumentListener fDocListener;
        private boolean fNeedsReconciling = true;
        private long fModifyTimeStamp = 0L;
        private long fStartReconcileTimeStamp = 0L;
        private Object fLock = new Object();

        public ASTProvider() {
            IDocument doc = this.getDoc();
            if (doc == null) {
                throw new IllegalStateException("Editor source viewer document must be available");
            }
            this.fDocListener = new IDocumentListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void documentAboutToBeChanged(DocumentEvent event) {
                    Object object = ASTProvider.this.fLock;
                    synchronized (object) {
                        ASTProvider.this.fNeedsReconciling = true;
                        ASTProvider.this.fModifyTimeStamp = event.fModificationStamp;
                    }
                }

                public void documentChanged(DocumentEvent event) {
                }
            };
            doc.addDocumentListener(this.fDocListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public CompiledUnit getValidCompiledModule(long timeoutInMilisec) {
            QvtDocumentProvider documentProvider = (QvtDocumentProvider)QvtEditor.this.getDocumentProvider();
            Object object = this.fLock;
            synchronized (object) {
                while (this.fNeedsReconciling) {
                    try {
                        this.fLock.wait(timeoutInMilisec);
                        if (!this.fNeedsReconciling) continue;
                        return null;
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                }
                return documentProvider.getCompiledModule();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void aboutToBeReconciled() {
            Object object = this.fLock;
            synchronized (object) {
                this.fStartReconcileTimeStamp = this.fModifyTimeStamp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reconciled(CompiledUnit unit, IProgressMonitor monitor) {
            Object object = this.fLock;
            synchronized (object) {
                if (this.fModifyTimeStamp == this.fStartReconcileTimeStamp) {
                    this.fNeedsReconciling = false;
                }
                this.fLock.notifyAll();
            }
        }

        private IDocument getDoc() {
            ISourceViewer viewer = QvtEditor.this.getEditorSourceViewer();
            if (viewer != null) {
                return viewer.getDocument();
            }
            return null;
        }

        void dispose() {
            IDocument doc = this.getDoc();
            if (doc != null) {
                doc.removeDocumentListener(this.fDocListener);
            }
        }
    }

    public static class SrcViewer
    extends ProjectionViewer {
        public SrcViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        }

        IReconciler getReconciler() {
            return this.fReconciler;
        }

        public void prependTextPresentationListener(ITextPresentationListener listener) {
            if (this.fTextPresentationListeners == null) {
                this.fTextPresentationListeners = new ArrayList();
            }
            this.fTextPresentationListeners.remove(listener);
            this.fTextPresentationListeners.add(0, listener);
        }
    }
}

