/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.QvtElementProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.QvtOutlineInformationControl;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class QvtoQuickOutlineHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        return this.run();
    }

    public Object run() {
        QvtEditor qvtEditor = this.getActiveEditor();
        if (qvtEditor != null) {
            IInformationPresenter outlinePresenter = this.getOutlinePresenter(qvtEditor);
            outlinePresenter.install((ITextViewer)qvtEditor.getEditorSourceViewer());
            outlinePresenter.showInformation();
        }
        return null;
    }

    public IInformationPresenter getOutlinePresenter(QvtEditor qvtEditor) {
        InformationPresenter presenter = new InformationPresenter(this.getOutlinePresenterControlCreator(qvtEditor));
        presenter.setDocumentPartitioning(qvtEditor.getQvtConfiguration().getConfiguredDocumentPartitioning(qvtEditor.getEditorSourceViewer()));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        QvtElementProvider provider = new QvtElementProvider();
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(final QvtEditor qvtEditor) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                QvtOutlineInformationControl qvtOutlineInformationControl = new QvtOutlineInformationControl(qvtEditor.getEditorSite().getShell(), shellStyle, treeStyle, "org.eclipse.m2m.qvt.oml.editor.ui.show.outline", qvtEditor, qvtEditor.getEditorSourceViewer());
                return qvtOutlineInformationControl;
            }
        };
    }

    private QvtEditor getActiveEditor() {
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) instanceof QvtEditor) {
            return (QvtEditor)editor;
        }
        return null;
    }
}

