/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.adapter;

import com.google.common.base.Joiner;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.generator.LanguageConfig;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.adapter.NamingAdapter;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.DefaultGeneratorModule;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.XtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.model.project.StandardProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.XtextProjectConfig;

@Deprecated(forRemoval=true)
public class Generator2AdapterSetup {
    private LanguageConfig languageConfig;
    private XpandExecutionContext xpandContext;
    private Naming naming;
    private Injector injector;
    private Module additionalGeneratorBindings = it -> {};
    private Module additionalLanguageBindings = it -> {};

    public Generator2AdapterSetup(LanguageConfig languageConfig, XpandExecutionContext xpandContext, Naming naming) {
        this.languageConfig = languageConfig;
        this.xpandContext = xpandContext;
        this.naming = naming;
    }

    public Injector getInjector() {
        if (this.injector == null) {
            this.injector = this.createInjector();
        }
        return this.injector;
    }

    private Injector createInjector() {
        DefaultGeneratorModule generatorModule = new DefaultGeneratorModule(){

            public void configure(Binder binder) {
                super.configure(binder);
                binder.install(Generator2AdapterSetup.this.additionalGeneratorBindings);
            }
        };
        generatorModule.setProject(this.createProjectConfig());
        generatorModule.setCode(this.createCodeConfig());
        Injector generatorInjector = Guice.createInjector((Module[])new Module[]{generatorModule});
        generatorModule.getProject().initialize(generatorInjector);
        generatorModule.getCode().initialize(generatorInjector);
        final IXtextGeneratorLanguage language = this.createLanguage(generatorInjector);
        Module languageModule = new Module(){

            public void configure(Binder binder) {
                binder.bind(IXtextGeneratorLanguage.class).toInstance((Object)language);
                binder.bind(Grammar.class).toInstance((Object)language.getGrammar());
                binder.bind(XtextGeneratorNaming.class).toInstance((Object)new NamingAdapter(Generator2AdapterSetup.this.naming));
                binder.install(Generator2AdapterSetup.this.additionalLanguageBindings);
            }
        };
        return generatorInjector.createChildInjector(new Module[]{languageModule});
    }

    private XtextProjectConfig createProjectConfig() {
        StandardProjectConfig cfg = new StandardProjectConfig();
        cfg.setCreateEclipseMetaData(true);
        cfg.setBaseName(this.naming.getProjectNameRt());
        String runtimeRoot = this.xpandContext.getOutput().getOutlet("PLUGIN").getPath();
        int projectNameIndex = runtimeRoot.lastIndexOf(cfg.getBaseName());
        if (projectNameIndex >= 0) {
            cfg.setRootPath(runtimeRoot.substring(0, projectNameIndex));
        } else {
            cfg.setRootPath(runtimeRoot);
        }
        cfg.getRuntime().setName(cfg.getBaseName());
        cfg.getRuntime().setRoot(runtimeRoot);
        cfg.getRuntime().setSrc(this.xpandContext.getOutput().getOutlet("SRC").getPath());
        cfg.getRuntime().setSrcGen(this.xpandContext.getOutput().getOutlet("SRC_GEN").getPath());
        cfg.getRuntime().setEcoreModel(this.xpandContext.getOutput().getOutlet("MODEL").getPath());
        cfg.getEclipsePlugin().setEnabled(true);
        cfg.getEclipsePlugin().setName(this.naming.getProjectNameUi());
        cfg.getEclipsePlugin().setRoot(this.xpandContext.getOutput().getOutlet("PLUGIN_UI").getPath());
        cfg.getEclipsePlugin().setSrc(this.xpandContext.getOutput().getOutlet("SRC_UI").getPath());
        cfg.getEclipsePlugin().setSrcGen(this.xpandContext.getOutput().getOutlet("SRC_GEN_UI").getPath());
        cfg.getGenericIde().setEnabled(true);
        cfg.getGenericIde().setName(this.naming.getProjectNameIde());
        cfg.getGenericIde().setRoot(this.xpandContext.getOutput().getOutlet("PLUGIN_IDE").getPath());
        cfg.getGenericIde().setSrc(this.xpandContext.getOutput().getOutlet("SRC_IDE").getPath());
        cfg.getGenericIde().setSrcGen(this.xpandContext.getOutput().getOutlet("SRC_GEN_IDE").getPath());
        return cfg;
    }

    private CodeConfig createCodeConfig() {
        CodeConfig codeConfig = new CodeConfig();
        codeConfig.setLineDelimiter(this.naming.getLineDelimiter());
        codeConfig.setFileHeader(this.naming.fileHeader());
        return codeConfig;
    }

    private IXtextGeneratorLanguage createLanguage(Injector generatorInjector) {
        XtextGeneratorLanguage xtextGeneratorLanguage = new XtextGeneratorLanguage();
        xtextGeneratorLanguage.setGrammarUri(this.languageConfig.getGrammar().eResource().getURI().toString());
        xtextGeneratorLanguage.setResourceSet(this.languageConfig.getGrammar().eResource().getResourceSet());
        xtextGeneratorLanguage.setFileExtensions(Joiner.on((char)',').join(this.languageConfig.getFileExtensions(this.languageConfig.getGrammar())));
        generatorInjector.injectMembers((Object)xtextGeneratorLanguage);
        xtextGeneratorLanguage.initialize(this.languageConfig.getGrammar());
        return xtextGeneratorLanguage;
    }

    public void setAdditionalGeneratorBindings(Module additionalGeneratorBindings) {
        this.additionalGeneratorBindings = additionalGeneratorBindings;
    }

    public void setAdditionalLanguageBindings(Module additionalLanguageBindings) {
        this.additionalLanguageBindings = additionalLanguageBindings;
    }
}

