/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model.project;

import com.google.inject.Injector;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.model.ManifestAccess;
import org.eclipse.xtext.xtext.generator.model.PluginXmlAccess;
import org.eclipse.xtext.xtext.generator.model.project.IBundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.SubProjectConfig;

public class BundleProjectConfig
extends SubProjectConfig
implements IBundleProjectConfig {
    private ManifestAccess manifest;
    private PluginXmlAccess pluginXml;

    @Override
    public void initialize(Injector injector) {
        super.initialize(injector);
        if (this.manifest != null) {
            this.manifest.initialize(injector);
        }
        if (this.pluginXml != null) {
            this.pluginXml.initialize(injector);
        }
    }

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.manifest != null && this.getMetaInf() == null) {
            issues.addError("The 'metaInf' outlet must be configured for projects with a manifest", this);
        }
        if (this.pluginXml != null && this.getRoot() == null) {
            issues.addError("The 'root' outlet must be configured for projects with a plugin.xml", this);
        }
    }

    @Override
    public ManifestAccess getManifest() {
        return this.manifest;
    }

    public void setManifest(ManifestAccess manifest) {
        this.manifest = manifest;
    }

    @Override
    public PluginXmlAccess getPluginXml() {
        return this.pluginXml;
    }

    public void setPluginXml(PluginXmlAccess pluginXml) {
        this.pluginXml = pluginXml;
    }
}

