/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.debug;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneManager;

@Singleton
public class XbaseDetailPanePrioritizer {
    private static final Logger logger = Logger.getLogger(XbaseDetailPanePrioritizer.class);
    private static final String JDT_STANDARD_PANE = "org.eclipse.jdt.debug.ui.DETAIL_PANE_STANDARD";
    private Map<Set<String>, String> preferences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prioritizeXbaseOverJdt() {
        if (this.preferences == null) {
            XbaseDetailPanePrioritizer xbaseDetailPanePrioritizer = this;
            synchronized (xbaseDetailPanePrioritizer) {
                if (this.preferences == null) {
                    this.loadPreferredDetailsAreas();
                    HashSet xbaseAndJdt = Sets.newHashSet((Object[])new String[]{"org.eclipse.xtext.xbase.debug.DetailPane", JDT_STANDARD_PANE});
                    if (!this.preferences.containsKey(xbaseAndJdt)) {
                        this.preferences.put(xbaseAndJdt, "org.eclipse.xtext.xbase.debug.DetailPane");
                    }
                    this.storePreferredDetailsAreas();
                }
            }
        }
    }

    private void loadPreferredDetailsAreas() {
        this.preferences = Maps.newHashMap();
        String preferenceValue = DebugUIPlugin.getDefault().getPluginPreferences().getString("preferredDetailPanes");
        StringTokenizer entryTokenizer = new StringTokenizer(preferenceValue, "|");
        while (entryTokenizer.hasMoreTokens()) {
            String token = entryTokenizer.nextToken();
            int valueStart = token.indexOf(58);
            StringTokenizer keyTokenizer = new StringTokenizer(token.substring(0, valueStart), ",");
            HashSet keys = Sets.newHashSet();
            while (keyTokenizer.hasMoreTokens()) {
                keys.add(keyTokenizer.nextToken());
            }
            this.preferences.put(keys, token.substring(valueStart + 1));
        }
    }

    private void storePreferredDetailsAreas() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<Set<String>, String> entry : this.preferences.entrySet()) {
            for (String currentID : entry.getKey()) {
                buffer.append(currentID);
                buffer.append(',');
            }
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.append(':');
            buffer.append(entry.getValue());
            buffer.append('|');
        }
        DebugUIPlugin.getDefault().getPluginPreferences().setValue("preferredDetailPanes", buffer.toString());
        this.updateDetailPanemanager();
    }

    private void updateDetailPanemanager() {
        try {
            Field preferredDetailAreasField = DetailPaneManager.class.getDeclaredField("fPreferredDetailPanes");
            preferredDetailAreasField.setAccessible(true);
            preferredDetailAreasField.set(DetailPaneManager.getDefault(), this.preferences);
        }
        catch (Exception e) {
            logger.debug((Object)"Could not update detail pane manager", (Throwable)e);
        }
    }
}

