/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.inject.Inject;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.macro.file.FileLocations;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class FileLocationsImpl
implements FileLocations {
    @Inject
    @Accessors
    private IProjectConfigProvider projectInformationProvider;
    @Inject
    @Accessors
    private IContextualOutputConfigurationProvider outputConfigurationProvider;
    @Accessors
    private Resource context;

    protected IProjectConfig getProjectConfig(Path path) {
        String firstSegment = (String)path.getSegments().get(0);
        IProjectConfig projectConfig = this.projectInformationProvider.getProjectConfig(this.context.getResourceSet());
        if (projectConfig == null || !Objects.equals(projectConfig.getName(), firstSegment)) {
            throw new IllegalArgumentException("The project '" + firstSegment + "' has not been configured.");
        }
        return projectConfig;
    }

    public Path getSourceFolder(Path path) {
        Functions.Function1 _function = sourceFolder -> path.startsWith(sourceFolder);
        return (Path)IterableExtensions.findFirst(this.getProjectSourceFolders(path), (Functions.Function1)_function);
    }

    public Path getTargetFolder(Path path) {
        Path _xblockexpression = null;
        Path projectFolder = this.getProjectFolder(path);
        if (projectFolder == null) {
            return null;
        }
        OutputConfiguration outputConfiguration = (OutputConfiguration)IterableExtensions.head((Iterable)this.outputConfigurationProvider.getOutputConfigurations(this.context));
        Path sourceFolder = this.getSourceFolder(path);
        String _xifexpression = null;
        if (sourceFolder == null) {
            _xifexpression = outputConfiguration.getOutputDirectory();
        } else {
            String _xblockexpression_1 = null;
            String projectRelativeSourceFolder = IterableExtensions.join((Iterable)IterableExtensions.tail((Iterable)sourceFolder.getSegments()), (CharSequence)"/");
            _xifexpression = _xblockexpression_1 = outputConfiguration.getOutputDirectory(projectRelativeSourceFolder);
        }
        String outputFolder = _xifexpression;
        _xblockexpression = projectFolder.append(outputFolder);
        return _xblockexpression;
    }

    public Path getProjectFolder(Path path) {
        IProjectConfig config = this.getProjectConfig(path);
        return Path.ROOT.append(config.getName());
    }

    public Set<Path> getProjectSourceFolders(Path path) {
        Functions.Function1 _function = it -> this.getProjectFolder(path).append(it.getName());
        return IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)this.getProjectConfig(path).getSourceFolders(), (Functions.Function1)_function));
    }

    @Pure
    public IProjectConfigProvider getProjectInformationProvider() {
        return this.projectInformationProvider;
    }

    public void setProjectInformationProvider(IProjectConfigProvider projectInformationProvider) {
        this.projectInformationProvider = projectInformationProvider;
    }

    @Pure
    public IContextualOutputConfigurationProvider getOutputConfigurationProvider() {
        return this.outputConfigurationProvider;
    }

    public void setOutputConfigurationProvider(IContextualOutputConfigurationProvider outputConfigurationProvider) {
        this.outputConfigurationProvider = outputConfigurationProvider;
    }

    @Pure
    public Resource getContext() {
        return this.context;
    }

    public void setContext(Resource context) {
        this.context = context;
    }
}

