/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.common.outline;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.common.outline.IXtendOutlineContext;
import org.eclipse.xtend.ide.common.outline.IXtendOutlineNodeBuilder;
import org.eclipse.xtend.ide.common.outline.IXtendOutlineTreeBuilder;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeature;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedField;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public abstract class AbstractXtendOutlineTreeBuilder
implements IXtendOutlineTreeBuilder {
    @Inject
    @Extension
    private JvmTypeExtensions _jvmTypeExtensions;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    @Extension
    protected IXtendJvmAssociations _iXtendJvmAssociations;
    @Extension
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    protected IXtendOutlineNodeBuilder xtendOutlineNodeBuilder;

    protected void _build(Void modelElement, IXtendOutlineContext context) {
    }

    protected void _build(EObject modelElement, IXtendOutlineContext context) {
        Consumer<EObject> _function = it -> this.xtendOutlineNodeBuilder.buildEObjectNode((EObject)it, context);
        modelElement.eContents().forEach(_function);
    }

    protected void buildPackageAndImportSection(XtendFile xtendFile, IXtendOutlineContext context) {
        boolean _tripleNotEquals;
        String _package = xtendFile.getPackage();
        boolean bl = _tripleNotEquals = _package != null;
        if (_tripleNotEquals) {
            this.xtendOutlineNodeBuilder.buildPackageNode(xtendFile, context);
        }
        if (xtendFile.getImportSection() != null && !xtendFile.getImportSection().getImportDeclarations().isEmpty()) {
            this.xtendOutlineNodeBuilder.buildImportSectionNode(xtendFile, context);
        }
    }

    protected void buildInheritedMembers(JvmDeclaredType inferredType, IXtendOutlineContext context) {
        ResourceSet _resourceSet = inferredType.eResource().getResourceSet();
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, _resourceSet);
        LightweightTypeReference typeReference = owner.toLightweightTypeReference((JvmType)inferredType);
        List superTypes = typeReference.getAllSuperTypes();
        IXtendOutlineContext superTypeContext = context;
        for (LightweightTypeReference superTypeRef : superTypes) {
            superTypeContext = superTypeContext.increaseInheritanceDepth();
            ResolvedFeatures resolvedFeatures = new ResolvedFeatures(superTypeRef);
            List _declaredFields = resolvedFeatures.getDeclaredFields();
            for (IResolvedField jvmField : _declaredFields) {
                boolean _not;
                boolean _skipFeature = this.skipFeature((JvmFeature)jvmField.getDeclaration());
                boolean bl = _not = !_skipFeature;
                if (!_not) continue;
                this.xtendOutlineNodeBuilder.buildResolvedFeatureNode(inferredType, (IResolvedFeature)jvmField, superTypeContext);
            }
            List _declaredConstructors = resolvedFeatures.getDeclaredConstructors();
            for (IResolvedConstructor constructor : _declaredConstructors) {
                boolean _not_1;
                boolean _skipFeature_1 = this.skipFeature((JvmFeature)constructor.getDeclaration());
                boolean bl = _not_1 = !_skipFeature_1;
                if (!_not_1) continue;
                this.xtendOutlineNodeBuilder.buildResolvedFeatureNode(inferredType, (IResolvedFeature)constructor, superTypeContext);
            }
            List _declaredOperations = resolvedFeatures.getDeclaredOperations();
            for (IResolvedOperation operation : _declaredOperations) {
                if (this.skipFeature((JvmFeature)operation.getDeclaration()) || superTypeContext.isProcessed((JvmMember)operation.getDeclaration())) continue;
                this.xtendOutlineNodeBuilder.buildResolvedFeatureNode(inferredType, (IResolvedFeature)operation, superTypeContext);
            }
            JvmType declaredType = superTypeRef.getType();
            if (!(declaredType instanceof JvmDeclaredType)) continue;
            IXtendOutlineContext nestedTypeContext = superTypeContext.hideInherited();
            Consumer<JvmDeclaredType> _function = it -> this.buildJvmType((JvmDeclaredType)it, nestedTypeContext);
            Iterables.filter((Iterable)((JvmDeclaredType)declaredType).getMembers(), JvmDeclaredType.class).forEach(_function);
        }
    }

    protected boolean skipFeature(JvmFeature feature) {
        boolean _xifexpression = false;
        if (feature instanceof JvmConstructor) {
            _xifexpression = ((JvmConstructor)feature).getDeclaringType().isLocal() || this._jvmTypeExtensions.isSingleSyntheticDefaultConstructor((JvmConstructor)feature);
        }
        return _xifexpression;
    }

    protected void buildJvmType(JvmDeclaredType typeElement, IXtendOutlineContext context) {
        boolean _not;
        IXtendOutlineContext jvmTypeContext = this.xtendOutlineNodeBuilder.buildXtendNode((EObject)typeElement, context);
        boolean _isProcessed = jvmTypeContext.isProcessed((JvmMember)typeElement);
        boolean bl = _not = !_isProcessed;
        if (_not) {
            jvmTypeContext.markAsProcessed((JvmMember)typeElement);
            this.buildMembers(typeElement, typeElement, jvmTypeContext);
        }
    }

    protected void buildMembers(JvmDeclaredType inferredType, JvmDeclaredType baseType, @Extension IXtendOutlineContext context) {
        EList _members = inferredType.getMembers();
        for (JvmMember member : _members) {
            boolean _not;
            boolean _isProcessed = context.isProcessed(member);
            boolean bl = _not = !_isProcessed;
            if (!_not) continue;
            if (member instanceof JvmDeclaredType) {
                boolean _isShowInherited = context.isShowInherited();
                if (_isShowInherited) {
                    IXtendOutlineContext typeContext = context.newContext();
                    EObject sourceElement = this._iXtendJvmAssociations.getPrimarySourceElement((EObject)member);
                    if (sourceElement instanceof XtendTypeDeclaration) {
                        this.buildType(sourceElement, typeContext);
                    } else {
                        this.buildJvmType((JvmDeclaredType)member, typeContext);
                    }
                } else {
                    this.buildJvmType((JvmDeclaredType)member, context);
                }
            } else if (member instanceof JvmFeature) {
                boolean _not_1;
                boolean _skipFeature = this.skipFeature((JvmFeature)member);
                boolean bl2 = _not_1 = !_skipFeature;
                if (_not_1) {
                    IXtendOutlineContext featureContext = this.buildFeature(baseType, (JvmFeature)member, (EObject)member, context);
                    Consumer<JvmGenericType> _function = it -> this.buildJvmType((JvmDeclaredType)it, featureContext.newContext());
                    ((JvmFeature)member).getLocalClasses().forEach(_function);
                }
            }
            context.markAsProcessed(member);
        }
        boolean _isShowInherited_1 = context.isShowInherited();
        if (_isShowInherited_1) {
            this.buildInheritedMembers(inferredType, context);
        }
    }

    protected IXtendOutlineContext buildFeature(JvmDeclaredType inferredType, JvmFeature jvmFeature, EObject semanticFeature, IXtendOutlineContext context) {
        boolean _not;
        IXtendOutlineContext _xifexpression = null;
        boolean _isSynthetic = this._jvmTypeExtensions.isSynthetic((JvmIdentifiableElement)jvmFeature);
        boolean bl = _not = !_isSynthetic;
        if (_not) {
            _xifexpression = this.xtendOutlineNodeBuilder.buildFeatureNode(inferredType, semanticFeature, context);
        }
        return _xifexpression;
    }

    protected abstract void buildType(EObject var1, IXtendOutlineContext var2);

    @Override
    @XbaseGenerated
    public void build(EObject modelElement, IXtendOutlineContext context) {
        if (modelElement != null) {
            this._build(modelElement, context);
            return;
        }
        if (modelElement == null) {
            this._build((Void)null, context);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(modelElement, context).toString());
    }

    public void setXtendOutlineNodeBuilder(IXtendOutlineNodeBuilder xtendOutlineNodeBuilder) {
        this.xtendOutlineNodeBuilder = xtendOutlineNodeBuilder;
    }
}

