/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.formatting;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.formatting.ILineSeparatorInformation;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.RuntimeIOException;

public class PreferenceStoreWhitespaceInformationProvider
implements IWhitespaceInformationProvider {
    @Inject
    private IIndentationInformation indentInfo;
    @Inject
    private ILineSeparatorInformation lineSeparatorInformation;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private IWorkspace workspace;

    public IIndentationInformation getIndentationInformation(URI uri) {
        return this.indentInfo;
    }

    public ILineSeparatorInformation getLineSeparatorInformation(URI uri) {
        if (uri == null) {
            return this.lineSeparatorInformation;
        }
        final String lineSeparator = this.getLineSeparatorPreference(uri);
        return new ILineSeparatorInformation(){

            public String getLineSeparator() {
                return lineSeparator;
            }
        };
    }

    protected String getLineSeparatorPreference(URI uri) {
        String result;
        IFile file;
        String delimiter;
        if (uri.isPlatformResource() && (delimiter = this.senseLineDelimiter(file = this.workspace.getRoot().getFile((IPath)new Path(uri.toPlatformString(true))))) != null) {
            return delimiter;
        }
        IProject project = null;
        if (uri.isPlatformResource()) {
            project = this.workspace.getRoot().getProject(uri.segment(1));
        } else {
            Iterator<Pair<IStorage, IProject>> iterator = this.storage2UriMapper.getStorages(uri).iterator();
            if (iterator.hasNext()) {
                Pair<IStorage, IProject> storage = iterator.next();
                project = (IProject)storage.getSecond();
            }
        }
        if (project != null && (result = this.getLineSeparatorPreference((IScopeContext)new ProjectScope(project))) != null) {
            return result;
        }
        result = this.getLineSeparatorPreference(InstanceScope.INSTANCE);
        if (result != null) {
            return result;
        }
        return System.getProperty("line.separator");
    }

    private String senseLineDelimiter(IFile file) {
        if (file.exists()) {
            InputStream content = null;
            try {
                int read;
                content = file.getContents();
                InputStreamReader reader = new InputStreamReader(content, file.getCharset());
                boolean rFound = false;
                while ((read = ((Reader)reader).read()) != -1) {
                    char c = (char)read;
                    if (c == '\n') {
                        if (rFound) {
                            return "\r\n";
                        }
                        return "\n";
                    }
                    if (rFound) {
                        return "\r";
                    }
                    if (c != '\r') continue;
                    rFound = true;
                }
                if (rFound) {
                    return "\r";
                }
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() != 368) {
                    throw new RuntimeIOException((Throwable)e);
                }
            }
            catch (Exception e) {
                throw new RuntimeIOException((Throwable)e);
            }
            finally {
                try {
                    if (content != null) {
                        content.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeIOException((Throwable)e);
                }
            }
        }
        return null;
    }

    protected String getLineSeparatorPreference(IScopeContext scopeContext) {
        String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, new IScopeContext[]{scopeContext});
        return lineDelimiter;
    }
}

