/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.workspace;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.ui.workspace.EclipseProjectConfigProvider;
import org.eclipse.xtext.ui.workspace.EclipseWorkspaceConfig;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.workspace.IWorkspaceConfig;

public class EclipseProjectConfig
implements IProjectConfig {
    private final IProject project;
    private final EclipseProjectConfigProvider projectConfigProvider;

    public EclipseProjectConfig(IProject project, EclipseProjectConfigProvider projectConfigProvider) {
        this.project = project;
        this.projectConfigProvider = projectConfigProvider;
    }

    public String getName() {
        return this.project.getName();
    }

    public URI getPath() {
        return URI.createPlatformResourceURI((String)("/" + this.getName() + "/"), (boolean)true);
    }

    public Set<? extends ISourceFolder> getSourceFolders() {
        return Collections.emptySet();
    }

    public ISourceFolder findSourceFolderContaining(URI member) {
        Optional<ISourceFolder> srcFolder = this.getSourceFolders().stream().filter(folder -> folder.contains(member)).findFirst();
        return srcFolder.isPresent() ? srcFolder.get() : null;
    }

    public IWorkspaceConfig getWorkspaceConfig() {
        return new EclipseWorkspaceConfig(this.project.getWorkspace().getRoot(), this.projectConfigProvider);
    }

    public String toString() {
        return this.project.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.project == null ? 0 : this.project.hashCode());
        return prime * result + (this.projectConfigProvider == null ? 0 : this.projectConfigProvider.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EclipseProjectConfig other = (EclipseProjectConfig)obj;
        if (this.project == null ? other.project != null : !this.project.equals((Object)other.project)) {
            return false;
        }
        return !(this.projectConfigProvider == null ? other.projectConfigProvider != null : !this.projectConfigProvider.equals(other.projectConfigProvider));
    }

    public IProject getProject() {
        return this.project;
    }

    public EclipseProjectConfigProvider getProjectConfigProvider() {
        return this.projectConfigProvider;
    }
}

