/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.navigation;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.common.types.ui.navigation.LinkToOrigin;
import org.eclipse.xtext.common.types.ui.navigation.LinkToOriginProvider;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class LinkToOriginDetector
extends AbstractHyperlinkDetector {
    @Inject
    private Provider<LinkToOrigin> hyperlinkProvider;
    @Inject
    private ITraceForStorageProvider traceInformation;
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        try {
            IJavaElement[] javaElements;
            ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
            if (textEditor == null) {
            }
            IEditorInput editorInput = textEditor.getEditorInput();
            if (editorInput == null) {
            }
            IJavaElement adaptedJavaElement = (IJavaElement)Platform.getAdapterManager().getAdapter((Object)editorInput, IJavaElement.class);
            if (adaptedJavaElement == null) {
            }
            ICompilationUnit compilationUnit = (ICompilationUnit)adaptedJavaElement.getAncestor(5);
            if (compilationUnit == null) {
            }
            IRegion selectedWord = JavaWordFinder.findWord((IDocument)textViewer.getDocument(), (int)region.getOffset());
            IJavaElement[] iJavaElementArray = javaElements = compilationUnit.codeSelect(selectedWord.getOffset(), selectedWord.getLength());
            int n = javaElements.length;
            int n2 = 0;
            while (n2 < n) {
                IMember selectedMember;
                IResource resource;
                boolean provideHyperlinkOnReferences;
                IJavaElement javaElement = iJavaElementArray[n2];
                boolean bl = provideHyperlinkOnReferences = !this.is_ORG_ECLIPSE_UI_IDE_3_8_Enabled() || compilationUnit.equals(((IMember)javaElement).getCompilationUnit());
                if (javaElement instanceof IMember && provideHyperlinkOnReferences && (resource = (selectedMember = (IMember)javaElement).getResource()) instanceof IFile) {
                    ITrace traceToSource = this.traceInformation.getTraceToSource((IStorage)resource);
                    if (traceToSource == null) {
                    }
                    Iterable sourceInformation = traceToSource.getAllAssociatedLocations((ITextRegion)new TextRegion(selectedWord.getOffset(), selectedWord.getLength()));
                    ArrayList sourceInformationAsList = Lists.newArrayList((Iterable)sourceInformation);
                    if (!canShowMultipleHyperlinks && sourceInformationAsList.size() > 1) {
                    }
                    ArrayList result = Lists.newArrayListWithCapacity((int)sourceInformationAsList.size());
                    for (ILocationInResource source : sourceInformationAsList) {
                        IResourceServiceProvider serviceProvider;
                        block26: {
                            URI resourceURI = source.getAbsoluteResourceURI();
                            if (resourceURI == null) continue;
                            serviceProvider = this.serviceProviderRegistry.getResourceServiceProvider(resourceURI);
                            if (serviceProvider != null) break block26;
                        }
                        try {
                            LinkToOriginProvider provider = (LinkToOriginProvider)serviceProvider.get(LinkToOriginProvider.class);
                            LinkToOrigin hyperlink = provider.createLinkToOrigin(source, selectedWord, selectedMember, compilationUnit, result);
                            if (hyperlink == null) continue;
                            result.add(hyperlink);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if (result.isEmpty()) {
                    }
                    return result.toArray(new IHyperlink[result.size()]);
                }
                ++n2;
            }
        }
        finally {
            return null;
        }
    }

    private boolean is_ORG_ECLIPSE_UI_IDE_3_8_Enabled() {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.eclipse.ui.ide.IDE");
            return clazz != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

