/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.selection;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.reconstr.ICommentAssociater;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.selection.AstSelectionAction;
import org.eclipse.xtext.ui.editor.selection.AstSelectionMessages;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstSelectionProvider {
    public static final String SELECT_ENCLOSING = "org.eclipse.xtext.ui.editor.select.enclosing";
    public static final String SELECT_NEXT = "org.eclipse.xtext.ui.editor.select.next";
    public static final String SELECT_PREVIOUS = "org.eclipse.xtext.ui.editor.select.previous";
    public static final String SELECT_LAST = "org.eclipse.xtext.ui.editor.select.last";
    @Inject
    private ILocationInFileProvider locationProvider;
    @Inject
    private ICommentAssociater commentAssociater;
    private Stack<ITextRegion> selectionHistory = new Stack();

    public ITextRegion selectLast(XtextResource resource, ITextRegion currentEditorSelection) {
        if (this.selectionHistory.isEmpty()) {
            return ITextRegion.EMPTY_REGION;
        }
        if (!currentEditorSelection.equals(this.selectionHistory.pop())) {
            this.selectionHistory.clear();
            return ITextRegion.EMPTY_REGION;
        }
        return this.selectionHistory.isEmpty() ? ITextRegion.EMPTY_REGION : this.selectionHistory.peek();
    }

    public ITextRegion selectEnclosing(XtextResource resource, ITextRegion currentEditorSelection) {
        Pair<EObject, EObject> currentlySelected = this.getSelectedAstElements(resource, currentEditorSelection);
        if (currentlySelected == null) {
            IParseResult parseResult = resource.getParseResult();
            if (parseResult != null) {
                int offset;
                ICompositeNode rootNode = parseResult.getRootNode();
                ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)(offset = this.getSelectionOffset(rootNode, currentEditorSelection)));
                ITextRegion fineGrainedRegion = this.computeInitialFineGrainedSelection((INode)node, currentEditorSelection);
                if (fineGrainedRegion != null) {
                    this.selectionHistory.clear();
                    this.register(currentEditorSelection);
                    return this.register(fineGrainedRegion);
                }
                EObject eObject = this.findSemanticObjectFor((INode)node);
                return this.register(this.getTextRegion(eObject));
            }
        } else {
            EObject first = (EObject)currentlySelected.getFirst();
            if (first.eContainer() != null) {
                return this.register(this.getTextRegion(first.eContainer()));
            }
        }
        return ITextRegion.EMPTY_REGION;
    }

    public ITextRegion selectNext(XtextResource resource, ITextRegion currentEditorSelection) {
        Pair<EObject, EObject> currentlySelected = this.getSelectedAstElements(resource, currentEditorSelection);
        if (currentlySelected == null) {
            return this.selectEnclosing(resource, currentEditorSelection);
        }
        EObject second = (EObject)currentlySelected.getSecond();
        EObject nextSibling = EcoreUtil2.getNextSibling((EObject)second);
        if (nextSibling != null) {
            return this.register(this.getRegion((Pair<EObject, EObject>)Tuples.create((Object)((EObject)currentlySelected.getFirst()), (Object)nextSibling)));
        }
        if (second.eContainer() == null) {
            return ITextRegion.EMPTY_REGION;
        }
        return this.register(this.getRegion((Pair<EObject, EObject>)Tuples.create((Object)second.eContainer(), (Object)second.eContainer())));
    }

    public ITextRegion selectPrevious(XtextResource resource, ITextRegion currentEditorSelection) {
        Pair<EObject, EObject> currentlySelected = this.getSelectedAstElements(resource, currentEditorSelection);
        if (currentlySelected == null) {
            return this.selectEnclosing(resource, currentEditorSelection);
        }
        EObject first = (EObject)currentlySelected.getFirst();
        EObject previousSibling = EcoreUtil2.getPreviousSibling((EObject)first);
        if (previousSibling != null) {
            return this.register(this.getRegion((Pair<EObject, EObject>)Tuples.create((Object)previousSibling, (Object)((EObject)currentlySelected.getSecond()))));
        }
        if (first.eContainer() == null) {
            return ITextRegion.EMPTY_REGION;
        }
        return this.register(this.getRegion((Pair<EObject, EObject>)Tuples.create((Object)first.eContainer(), (Object)first.eContainer())));
    }

    protected Pair<EObject, EObject> getSelectedAstElements(XtextResource resource, ITextRegion currentSelection) {
        EObject eObject = this.getEObjectAtOffset(resource, currentSelection);
        while (eObject != null) {
            Pair<EObject, EObject> result = this.internalGetSelectedAstElements(eObject, currentSelection);
            if (result != null) {
                return result;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    protected Pair<EObject, EObject> internalGetSelectedAstElements(EObject eObject, ITextRegion currentSelection) {
        ITextRegion textRegion = this.getTextRegion(eObject);
        while (textRegion.getOffset() == currentSelection.getOffset()) {
            EObject container = eObject.eContainer();
            if (container != null) {
                for (EObject obj : container.eContents()) {
                    ITextRegion region = this.getTextRegion(obj);
                    if (this.getEndOffset(region) != this.getEndOffset(currentSelection)) continue;
                    Pair<EObject, EObject> parentMatch = this.internalGetSelectedAstElements(eObject.eContainer(), currentSelection);
                    if (parentMatch != null) {
                        return parentMatch;
                    }
                    return Tuples.create((Object)eObject, (Object)obj);
                }
            } else {
                if (textRegion.equals(currentSelection)) {
                    return Tuples.create((Object)eObject, (Object)eObject);
                }
                return null;
            }
            eObject = container;
            textRegion = this.getTextRegion(eObject);
        }
        return null;
    }

    protected ITextRegion getRegion(Pair<EObject, EObject> selection) {
        ITextRegion firstRegion = this.getTextRegion((EObject)selection.getFirst());
        if (selection.getFirst() == selection.getSecond()) {
            return firstRegion;
        }
        ITextRegion secondRegion = this.getTextRegion((EObject)selection.getSecond());
        return new TextRegion(firstRegion.getOffset(), this.getEndOffset(secondRegion) - firstRegion.getOffset());
    }

    protected ITextRegion computeInitialFineGrainedSelection(INode node, ITextRegion currentEditorSelection) {
        if (node.getText().trim().length() > 0 && currentEditorSelection.getOffset() >= node.getOffset() && this.getEndOffset(currentEditorSelection) < node.getOffset() + node.getLength()) {
            return new TextRegion(node.getOffset(), node.getLength());
        }
        return null;
    }

    protected EObject findSemanticObjectFor(INode node) {
        Map semanticEObjects;
        if (node instanceof ILeafNode && ((ILeafNode)node).isHidden() && (semanticEObjects = this.commentAssociater.associateCommentsWithSemanticEObjects(null, Collections.singleton(node.getRootNode()))).containsKey(node)) {
            return (EObject)semanticEObjects.get(node);
        }
        return NodeModelUtils.findActualSemanticObjectFor((INode)node);
    }

    protected EObject getEObjectAtOffset(XtextResource resource, ITextRegion currentEditorSelection) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            ICompositeNode rootNode = parseResult.getRootNode();
            ILeafNode nodeAtOffset = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)currentEditorSelection.getOffset());
            return this.findSemanticObjectFor((INode)nodeAtOffset);
        }
        return null;
    }

    public void initialize(XtextEditor xtextEditor) {
        AstSelectionAction enclosingSelectionAction = new AstSelectionAction(AstSelectionMessages.AstSelectEnclosing_label, xtextEditor){

            protected ITextRegion internalSelect(XtextResource xtextResource, ITextRegion textRegion) {
                return AstSelectionProvider.this.selectEnclosing(xtextResource, textRegion);
            }
        };
        enclosingSelectionAction.setToolTipText(AstSelectionMessages.AstSelectEnclosing_tooltip);
        enclosingSelectionAction.setDescription(AstSelectionMessages.AstSelectEnclosing_description);
        this.setAction(xtextEditor, (IAction)enclosingSelectionAction, SELECT_ENCLOSING);
        AstSelectionAction previousSelectionAction = new AstSelectionAction(AstSelectionMessages.AstSelectPrevious_label, xtextEditor){

            protected ITextRegion internalSelect(XtextResource xtextResource, ITextRegion textRegion) {
                return AstSelectionProvider.this.selectPrevious(xtextResource, textRegion);
            }
        };
        previousSelectionAction.setToolTipText(AstSelectionMessages.AstSelectPrevious_tooltip);
        previousSelectionAction.setDescription(AstSelectionMessages.AstSelectPrevious_description);
        this.setAction(xtextEditor, (IAction)previousSelectionAction, SELECT_PREVIOUS);
        AstSelectionAction nextSelectionAction = new AstSelectionAction(AstSelectionMessages.AstSelectNext_label, xtextEditor){

            protected ITextRegion internalSelect(XtextResource xtextResource, ITextRegion textRegion) {
                return AstSelectionProvider.this.selectNext(xtextResource, textRegion);
            }
        };
        nextSelectionAction.setActionDefinitionId(SELECT_NEXT);
        nextSelectionAction.setToolTipText(AstSelectionMessages.AstSelectNext_tooltip);
        nextSelectionAction.setDescription(AstSelectionMessages.AstSelectNext_description);
        this.setAction(xtextEditor, (IAction)nextSelectionAction, SELECT_NEXT);
        AstSelectionAction lastSelectionAction = new AstSelectionAction(AstSelectionMessages.AstSelectLast_label, xtextEditor){

            protected ITextRegion internalSelect(XtextResource xtextResource, ITextRegion textRegion) {
                return AstSelectionProvider.this.selectLast(xtextResource, textRegion);
            }
        };
        nextSelectionAction.setActionDefinitionId(SELECT_NEXT);
        nextSelectionAction.setToolTipText(AstSelectionMessages.AstSelectLast_tooltip);
        nextSelectionAction.setDescription(AstSelectionMessages.AstSelectLast_description);
        this.setAction(xtextEditor, (IAction)lastSelectionAction, SELECT_LAST);
    }

    protected void setAction(XtextEditor xtextEditor, IAction action, String actionDefinitionId) {
        action.setActionDefinitionId(actionDefinitionId);
        xtextEditor.setAction(actionDefinitionId, action);
    }

    protected ITextRegion register(ITextRegion textRegion) {
        if (this.selectionHistory.isEmpty() || !this.selectionHistory.peek().equals(textRegion)) {
            this.selectionHistory.push(textRegion);
        }
        return textRegion;
    }

    protected ITextRegion getTextRegion(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        IParseResult parseResult = ((XtextResource)eObject.eResource()).getParseResult();
        if (parseResult == null) {
            return null;
        }
        ICompositeNode rootNode = parseResult.getRootNode();
        Map comments = this.commentAssociater.associateCommentsWithSemanticEObjects(eObject, Collections.singleton(rootNode));
        ITextRegion result = this.locationProvider.getFullTextRegion(eObject);
        int start = result.getOffset();
        int end = result.getOffset() + result.getLength();
        for (Map.Entry entry : comments.entrySet()) {
            if (entry.getValue() != eObject) continue;
            ILeafNode node = (ILeafNode)entry.getKey();
            if (node.getTotalOffset() < start) {
                start = node.getTotalOffset();
            }
            if (node.getTotalEndOffset() <= end) continue;
            end = node.getTotalEndOffset();
        }
        return new TextRegion(start, end - start);
    }

    protected int getEndOffset(ITextRegion region) {
        return region.getOffset() + region.getLength();
    }

    protected int getSelectionOffset(ICompositeNode rootNode, ITextRegion region) {
        boolean selectionAtEndOfText = rootNode.getTotalEndOffset() == this.getEndOffset(region);
        return selectionAtEndOfText && region.getOffset() > 0 ? region.getOffset() - 1 : region.getOffset();
    }
}

