/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.findrefs;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.findrefs.DefaultReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendReferenceFinder
extends DefaultReferenceFinder
implements IReferenceFinder {
    private IQualifiedNameConverter nameConverter;

    @Inject
    public XtendReferenceFinder(IResourceDescriptions indexData, IResourceServiceProvider.Registry serviceProviderRegistry, IQualifiedNameConverter nameConverter) {
        super(indexData, serviceProviderRegistry);
        this.nameConverter = nameConverter;
    }

    public void findReferences(final Set<URI> targetURIs, final IResourceDescription resourceDescription, final IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor, IReferenceFinder.ILocalResourceAccess localResourceAccess) {
        Functions.Function1<URI, Boolean> _function_1;
        Functions.Function1<URI, URI> _function = new Functions.Function1<URI, URI>(){

            public URI apply(URI it) {
                URI _trimFragment = it.trimFragment();
                return _trimFragment;
            }
        };
        Iterable _map = IterableExtensions.map(targetURIs, (Functions.Function1)_function);
        boolean _exists = IterableExtensions.exists((Iterable)_map, (Functions.Function1)(_function_1 = new Functions.Function1<URI, Boolean>(){

            public Boolean apply(URI it) {
                URI _uRI = resourceDescription.getURI();
                boolean _equals = Objects.equal((Object)it, (Object)_uRI);
                return _equals;
            }
        }));
        if (_exists) {
            return;
        }
        final HashSet names = CollectionLiterals.newHashSet((Object[])new QualifiedName[0]);
        for (final URI uri : targetURIs) {
            IUnitOfWork<Boolean, ResourceSet> _function_2 = new IUnitOfWork<Boolean, ResourceSet>(){

                public Boolean exec(ResourceSet it) throws Exception {
                    boolean _notEquals;
                    Boolean _xblockexpression = null;
                    EObject _eObject = it.getEObject(uri, true);
                    JvmType obj = (JvmType)EcoreUtil2.getContainerOfType((EObject)_eObject, JvmType.class);
                    Boolean _xifexpression = null;
                    boolean bl = _notEquals = !Objects.equal((Object)obj, null);
                    if (_notEquals) {
                        String _identifier = obj.getIdentifier();
                        QualifiedName _qualifiedName = XtendReferenceFinder.this.nameConverter.toQualifiedName(_identifier);
                        QualifiedName _lowerCase = _qualifiedName.toLowerCase();
                        boolean _add = names.add(_lowerCase);
                        _xifexpression = _add;
                    }
                    _xblockexpression = _xifexpression;
                    return _xblockexpression;
                }
            };
            localResourceAccess.readOnly(uri, (IUnitOfWork)_function_2);
        }
        Iterable _importedNames = resourceDescription.getImportedNames();
        final Set importedNames = IterableExtensions.toSet((Iterable)_importedNames);
        Functions.Function1<QualifiedName, Boolean> _function_3 = new Functions.Function1<QualifiedName, Boolean>(){

            public Boolean apply(QualifiedName it) {
                boolean _contains = importedNames.contains(it);
                return _contains;
            }
        };
        boolean _exists_1 = IterableExtensions.exists((Iterable)names, (Functions.Function1)_function_3);
        if (_exists_1) {
            URI _uRI = resourceDescription.getURI();
            IUnitOfWork<Object, ResourceSet> _function_4 = new IUnitOfWork<Object, ResourceSet>(){

                public Object exec(ResourceSet resourceSet) throws Exception {
                    URI _uRI = resourceDescription.getURI();
                    Resource _resource = resourceSet.getResource(_uRI, true);
                    IAcceptor<IReferenceDescription> _function = new IAcceptor<IReferenceDescription>(){

                        public void accept(IReferenceDescription it) {
                            acceptor.accept((Object)it);
                        }
                    };
                    XtendReferenceFinder.this.findLocalReferencesInResource(targetURIs, _resource, (IAcceptor)_function);
                    return null;
                }
            };
            localResourceAccess.readOnly(_uRI, (IUnitOfWork)_function_4);
        }
    }

    protected void findLocalReferencesFromElement(Set<URI> targetURISet, EObject sourceCandidate, Resource localResource, IAcceptor<IReferenceDescription> acceptor, URI currentExportedContainerURI, Map<EObject, URI> exportedElementsMap) {
        XAbstractFeatureCall _xAbstractFeatureCall;
        boolean _isPackageFragment;
        boolean _matched = false;
        if (!_matched && sourceCandidate instanceof XAbstractFeatureCall && (_isPackageFragment = (_xAbstractFeatureCall = (XAbstractFeatureCall)sourceCandidate).isPackageFragment())) {
            _matched = true;
            return;
        }
        super.findLocalReferencesFromElement(targetURISet, sourceCandidate, localResource, acceptor, currentExportedContainerURI, exportedElementsMap);
    }
}

