/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.RuleNames;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.CompositeGeneratorFragment2;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.ImplicitFragment;
import org.eclipse.xtext.xtext.generator.XtextGeneratorResourceSetInitializer;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.StandaloneSetupAccess;
import org.eclipse.xtext.xtext.generator.model.project.IRuntimeProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;

@Log
public class XtextGeneratorLanguage
extends CompositeGeneratorFragment2
implements IXtextGeneratorLanguage {
    private String grammarUri;
    private String name;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private Boolean generateXtendStubs;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private Grammar grammar;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private RuleNames ruleNames;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private List<String> fileExtensions;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private List<String> referencedResources = CollectionLiterals.newArrayList((Object[])new String[0]);
    @Accessors
    private ResourceSet resourceSet;
    @Accessors
    private Module guiceModule = new Module(){

        public void configure(Binder it) {
        }
    };
    @Accessors
    private final StandaloneSetupAccess runtimeGenSetup = new StandaloneSetupAccess();
    @Accessors
    private final GuiceModuleAccess runtimeGenModule = new GuiceModuleAccess();
    @Accessors
    private final GuiceModuleAccess eclipsePluginGenModule = new GuiceModuleAccess();
    @Accessors
    private final GuiceModuleAccess ideaGenModule = new GuiceModuleAccess();
    @Accessors
    private final GuiceModuleAccess webGenModule = new GuiceModuleAccess();
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private IXtextProjectConfig projectConfig;
    @Inject
    private CodeConfig codeConfig;
    @Inject
    private XtextGeneratorResourceSetInitializer resourceSetInitializer;
    private static final Logger LOG = Logger.getLogger(XtextGeneratorLanguage.class);

    public void setGrammarUri(String uri) {
        this.grammarUri = uri;
    }

    public String getGrammarUri() {
        String _elvis = null;
        if (this.grammarUri != null) {
            _elvis = this.grammarUri;
        } else {
            String _string;
            IRuntimeProjectConfig _runtime = this.projectConfig.getRuntime();
            IXtextGeneratorFileSystemAccess _src = _runtime.getSrc();
            String _path = _src.getPath();
            String _replace = this.name.replace(".", "/");
            String _plus = String.valueOf(_replace) + ".xtext";
            File _file = new File(_path, _plus);
            java.net.URI _uRI = _file.toURI();
            _elvis = _string = _uRI.toString();
        }
        return _elvis;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFileExtensions(String fileExtensions) {
        List _list;
        String _trim = fileExtensions.trim();
        String[] _split = _trim.split("\\s*,\\s*");
        this.fileExtensions = _list = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)));
    }

    public void addReferencedResource(String referencedResource) {
        this.referencedResources.add(referencedResource);
    }

    @Override
    public List<String> getFileExtensions() {
        boolean _isEmpty;
        boolean _or = false;
        _or = this.fileExtensions == null ? true : (_isEmpty = this.fileExtensions.isEmpty());
        if (_or) {
            String _simpleName = GrammarUtil.getSimpleName((Grammar)this.grammar);
            String _lowerCase = _simpleName.toLowerCase();
            this.setFileExtensions(_lowerCase);
            LOG.info((Object)("No explicit fileExtensions configured. Using '*." + this.fileExtensions + "'."));
        }
        return this.fileExtensions;
    }

    @Override
    public boolean isGenerateXtendStubs() {
        boolean _xifexpression = false;
        boolean _notEquals = !Objects.equal((Object)this.generateXtendStubs, null);
        _xifexpression = _notEquals ? this.generateXtendStubs.booleanValue() : this.codeConfig.isPreferXtendStubs();
        return _xifexpression;
    }

    @Override
    public void initialize(Injector injector) {
        boolean _not_1;
        String _grammarUri;
        boolean _equals;
        EList _errors;
        String _plus_1;
        String _plus;
        boolean _isEmpty_1;
        EList _contents;
        boolean _not;
        List<IXtextGeneratorFragment> _fragments = this.getFragments();
        List<? extends IXtextGeneratorFragment> _implicitFragments = this.getImplicitFragments();
        _fragments.addAll(0, _implicitFragments);
        injector.injectMembers(XtextGeneratorLanguage.class);
        if (this.resourceSet == null) {
            ResourceSet _get;
            this.resourceSet = _get = (ResourceSet)this.resourceSetProvider.get();
        }
        this.resourceSetInitializer.initialize(this.resourceSet, this.referencedResources);
        EList _resources = this.resourceSet.getResources();
        boolean _isEmpty = _resources.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.installIndex();
            int i = 0;
            EList _resources_1 = this.resourceSet.getResources();
            int size = _resources_1.size();
            boolean _while = i < size;
            while (_while) {
                EList _resources_2 = this.resourceSet.getResources();
                Resource res = (Resource)_resources_2.get(i);
                _contents = res.getContents();
                _isEmpty_1 = _contents.isEmpty();
                if (_isEmpty_1) {
                    URI _uRI = res.getURI();
                    _plus = "Error loading '" + _uRI;
                    _plus_1 = String.valueOf(_plus) + "'";
                    LOG.error((Object)_plus_1);
                } else {
                    boolean _not_12;
                    _errors = res.getErrors();
                    boolean _isEmpty_2 = _errors.isEmpty();
                    boolean bl2 = _not_12 = !_isEmpty_2;
                    if (_not_12) {
                        URI _uRI_1 = res.getURI();
                        String _plus_2 = "Error loading '" + _uRI_1;
                        String _plus_3 = String.valueOf(_plus_2) + "':\n";
                        Joiner _on = Joiner.on((String)"\n");
                        EList _errors_1 = res.getErrors();
                        String _join = _on.join((Iterable)_errors_1);
                        String _plus_4 = String.valueOf(_plus_3) + _join;
                        LOG.error((Object)_plus_4);
                    }
                }
                boolean bl3 = _while = ++i < size;
            }
            EcoreUtil.resolveAll((ResourceSet)this.resourceSet);
        }
        if (_equals = Objects.equal((Object)(_grammarUri = this.getGrammarUri()), null)) {
            throw new IllegalStateException("No grammarUri or language name given");
        }
        String _grammarUri_1 = this.getGrammarUri();
        URI _createURI = URI.createURI((String)_grammarUri_1);
        Resource _resource = this.resourceSet.getResource(_createURI, true);
        XtextResource resource = (XtextResource)_resource;
        _contents = resource.getContents();
        _isEmpty_1 = _contents.isEmpty();
        if (_isEmpty_1) {
            String _grammarUri_2 = this.getGrammarUri();
            _plus = "Couldn't load grammar for '" + _grammarUri_2;
            _plus_1 = String.valueOf(_plus) + "'.";
            throw new IllegalArgumentException(_plus_1);
        }
        _errors = resource.getErrors();
        boolean _isEmpty_2 = _errors.isEmpty();
        boolean bl4 = _not_1 = !_isEmpty_2;
        if (_not_1) {
            EList _errors_1 = resource.getErrors();
            LOG.error((Object)_errors_1);
            String _grammarUri_3 = this.getGrammarUri();
            String _plus_2 = "Problem parsing '" + _grammarUri_3;
            String _plus_3 = String.valueOf(_plus_2) + "':\n";
            Joiner _on = Joiner.on((String)"\n");
            EList _errors_2 = resource.getErrors();
            String _join = _on.join((Iterable)_errors_2);
            String _plus_4 = String.valueOf(_plus_3) + _join;
            throw new IllegalStateException(_plus_4);
        }
        EList _contents_1 = resource.getContents();
        EObject _get_1 = (EObject)_contents_1.get(0);
        Grammar grammar = (Grammar)_get_1;
        this.validateGrammar(grammar);
        this.initialize(grammar);
        super.initialize(injector);
    }

    protected List<? extends IXtextGeneratorFragment> getImplicitFragments() {
        ArrayList _xblockexpression = null;
        ArrayList fragments = CollectionLiterals.newArrayList((Object[])new ImplicitFragment[0]);
        ImplicitFragment _implicitFragment = new ImplicitFragment();
        fragments.add(_implicitFragment);
        _xblockexpression = fragments;
        return _xblockexpression;
    }

    public void initialize(Grammar grammar) {
        RuleNames _ruleNames;
        this.grammar = grammar;
        this.ruleNames = _ruleNames = RuleNames.getRuleNames((Grammar)grammar, (boolean)true);
    }

    private void installIndex() {
        List _emptyList = Collections.emptyList();
        ResourceDescriptionsData index = new ResourceDescriptionsData(_emptyList);
        EList _resources = this.resourceSet.getResources();
        ArrayList resources = Lists.newArrayList((Iterable)_resources);
        for (Resource resource : resources) {
            URI _uRI = resource.getURI();
            this.index(resource, _uRI, index);
        }
        ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)this.resourceSet, (ResourceDescriptionsData)index);
    }

    private void index(Resource resource, URI uri, ResourceDescriptionsData index) {
        boolean _notEquals;
        IResourceServiceProvider serviceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri);
        boolean bl = _notEquals = !Objects.equal((Object)serviceProvider, null);
        if (_notEquals) {
            boolean _notEquals_1;
            IResourceDescription.Manager _resourceDescriptionManager = serviceProvider.getResourceDescriptionManager();
            IResourceDescription resourceDescription = _resourceDescriptionManager.getResourceDescription(resource);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)resourceDescription, null);
            if (_notEquals_1) {
                index.addDescription(uri, resourceDescription);
            }
        }
    }

    protected void validateGrammar(Grammar grammar) {
        this.validateAllImports(grammar);
        EValidator validator = EValidator.Registry.INSTANCE.getEValidator((EPackage)XtextPackage.eINSTANCE);
        if (validator != null) {
            DiagnosticChain chain = new DiagnosticChain(){

                public void add(Diagnostic diagnostic) {
                    boolean _equals;
                    int _severity = diagnostic.getSeverity();
                    boolean bl = _equals = _severity == 4;
                    if (_equals) {
                        Throwable _exception = diagnostic.getException();
                        boolean _equals_1 = Objects.equal((Object)_exception, null);
                        if (_equals_1) {
                            String _message = diagnostic.getMessage();
                            throw new IllegalStateException(_message);
                        }
                        String _message_1 = diagnostic.getMessage();
                        Throwable _exception_1 = diagnostic.getException();
                        throw new IllegalStateException(_message_1, _exception_1);
                    }
                }

                public void addAll(Diagnostic diagnostic) {
                    this.add(diagnostic);
                }

                public void merge(Diagnostic diagnostic) {
                    throw new UnsupportedOperationException();
                }
            };
            validator.validate((EObject)grammar, chain, null);
            TreeIterator iterator = grammar.eAllContents();
            while (iterator.hasNext()) {
                EObject _next = (EObject)iterator.next();
                HashMap _hashMap = new HashMap();
                validator.validate(_next, chain, _hashMap);
            }
        }
    }

    protected void validateAllImports(Grammar grammar) {
        List _allMetamodelDeclarations = GrammarUtil.allMetamodelDeclarations((Grammar)grammar);
        for (AbstractMetamodelDeclaration amd : _allMetamodelDeclarations) {
            if (!(amd instanceof ReferencedMetamodel)) continue;
            this.validateReferencedMetamodel((ReferencedMetamodel)amd);
        }
    }

    protected void validateReferencedMetamodel(ReferencedMetamodel ref) {
        EPackage _ePackage_1;
        boolean _eIsProxy;
        boolean _not;
        boolean _notEquals;
        boolean _and = false;
        EPackage _ePackage = ref.getEPackage();
        boolean bl = _notEquals = !Objects.equal((Object)_ePackage, null);
        _and = !_notEquals ? false : (_not = !(_eIsProxy = (_ePackage_1 = ref.getEPackage()).eIsProxy()));
        if (_and) {
            return;
        }
        EReference eref = XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE;
        List nodes = NodeModelUtils.findNodesForFeature((EObject)ref, (EStructuralFeature)eref);
        String _xifexpression = null;
        boolean _isEmpty = nodes.isEmpty();
        if (_isEmpty) {
            _xifexpression = "(unknown)";
        } else {
            INode _get = (INode)nodes.get(0);
            _xifexpression = NodeModelUtils.getTokenText((INode)_get);
        }
        String refName = _xifexpression;
        Grammar _grammar = GrammarUtil.getGrammar((EObject)ref);
        String grammarName = _grammar.getName();
        String msg = "The EPackage " + refName + " in grammar " + grammarName + " could not be found. " + "You might want to register that EPackage in your workflow file.";
        throw new IllegalStateException(msg);
    }

    public void setGenerateXtendStubs(Boolean generateXtendStubs) {
        this.generateXtendStubs = generateXtendStubs;
    }

    @Override
    @Pure
    public Grammar getGrammar() {
        return this.grammar;
    }

    @Pure
    public RuleNames getRuleNames() {
        return this.ruleNames;
    }

    @Pure
    public List<String> getReferencedResources() {
        return this.referencedResources;
    }

    @Override
    @Pure
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    @Pure
    public Module getGuiceModule() {
        return this.guiceModule;
    }

    public void setGuiceModule(Module guiceModule) {
        this.guiceModule = guiceModule;
    }

    @Override
    @Pure
    public StandaloneSetupAccess getRuntimeGenSetup() {
        return this.runtimeGenSetup;
    }

    @Override
    @Pure
    public GuiceModuleAccess getRuntimeGenModule() {
        return this.runtimeGenModule;
    }

    @Override
    @Pure
    public GuiceModuleAccess getEclipsePluginGenModule() {
        return this.eclipsePluginGenModule;
    }

    @Override
    @Pure
    public GuiceModuleAccess getIdeaGenModule() {
        return this.ideaGenModule;
    }

    @Override
    @Pure
    public GuiceModuleAccess getWebGenModule() {
        return this.webGenModule;
    }
}

