/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.predicates.impl;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.oomph.predicates.AndPredicate;
import org.eclipse.oomph.predicates.BuilderPredicate;
import org.eclipse.oomph.predicates.CommentPredicate;
import org.eclipse.oomph.predicates.FilePredicate;
import org.eclipse.oomph.predicates.LocationPredicate;
import org.eclipse.oomph.predicates.NamePredicate;
import org.eclipse.oomph.predicates.NaturePredicate;
import org.eclipse.oomph.predicates.NotPredicate;
import org.eclipse.oomph.predicates.OrPredicate;
import org.eclipse.oomph.predicates.Predicate;
import org.eclipse.oomph.predicates.PredicatesFactory;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.RepositoryPredicate;
import org.eclipse.oomph.predicates.impl.AndPredicateImpl;
import org.eclipse.oomph.predicates.impl.BuilderPredicateImpl;
import org.eclipse.oomph.predicates.impl.CommentPredicateImpl;
import org.eclipse.oomph.predicates.impl.FilePredicateImpl;
import org.eclipse.oomph.predicates.impl.LocationPredicateImpl;
import org.eclipse.oomph.predicates.impl.NamePredicateImpl;
import org.eclipse.oomph.predicates.impl.NaturePredicateImpl;
import org.eclipse.oomph.predicates.impl.NotPredicateImpl;
import org.eclipse.oomph.predicates.impl.OrPredicateImpl;
import org.eclipse.oomph.predicates.impl.PredicateImpl;
import org.eclipse.oomph.predicates.impl.RepositoryPredicateImpl;

public class PredicatesFactoryImpl
extends EFactoryImpl
implements PredicatesFactory {
    public static PredicatesFactory init() {
        try {
            PredicatesFactory thePredicatesFactory = (PredicatesFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/oomph/predicates/1.0");
            if (thePredicatesFactory != null) {
                return thePredicatesFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new PredicatesFactoryImpl();
    }

    public EObject create(EClass eClass) {
        if (eClass == PredicatesPackage.Literals.PREDICATE) {
            return new PredicateImpl(){

                public boolean matches(IResource resource) {
                    return false;
                }
            };
        }
        return this.createGen(eClass);
    }

    public EObject createGen(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createNamePredicate();
            }
            case 2: {
                return this.createCommentPredicate();
            }
            case 3: {
                return this.createLocationPredicate();
            }
            case 4: {
                return this.createRepositoryPredicate();
            }
            case 5: {
                return this.createAndPredicate();
            }
            case 6: {
                return this.createOrPredicate();
            }
            case 7: {
                return this.createNotPredicate();
            }
            case 8: {
                return this.createNaturePredicate();
            }
            case 9: {
                return this.createBuilderPredicate();
            }
            case 10: {
                return this.createFilePredicate();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.createProjectFromString(eDataType, initialValue);
            }
            case 12: {
                return this.createResourceFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.convertProjectToString(eDataType, instanceValue);
            }
            case 12: {
                return this.convertResourceToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public NamePredicate createNamePredicate() {
        NamePredicateImpl namePredicate = new NamePredicateImpl();
        return namePredicate;
    }

    public CommentPredicate createCommentPredicate() {
        CommentPredicateImpl commentPredicate = new CommentPredicateImpl();
        return commentPredicate;
    }

    public LocationPredicate createLocationPredicate() {
        LocationPredicateImpl locationPredicate = new LocationPredicateImpl();
        return locationPredicate;
    }

    public NamePredicate createNamePredicate(String pattern) {
        NamePredicate result = this.createNamePredicate();
        result.setPattern(pattern);
        return result;
    }

    public RepositoryPredicate createRepositoryPredicate() {
        RepositoryPredicateImpl repositoryPredicate = new RepositoryPredicateImpl();
        return repositoryPredicate;
    }

    public RepositoryPredicate createRepositoryPredicate(IProject project) {
        RepositoryPredicate result = this.createRepositoryPredicate();
        result.setProject(project);
        return result;
    }

    public AndPredicate createAndPredicate() {
        AndPredicateImpl andPredicate = new AndPredicateImpl();
        return andPredicate;
    }

    public AndPredicate createAndPredicate(Predicate ... operands) {
        AndPredicate result = this.createAndPredicate();
        result.getOperands().addAll(Arrays.asList(operands));
        return result;
    }

    public OrPredicate createOrPredicate() {
        OrPredicateImpl orPredicate = new OrPredicateImpl();
        return orPredicate;
    }

    public OrPredicate createOrPredicate(Predicate ... operands) {
        OrPredicate result = this.createOrPredicate();
        result.getOperands().addAll(Arrays.asList(operands));
        return result;
    }

    public NotPredicate createNotPredicate() {
        NotPredicateImpl notPredicate = new NotPredicateImpl();
        return notPredicate;
    }

    public NotPredicate createNotPredicate(Predicate operand) {
        NotPredicate result = this.createNotPredicate();
        result.setOperand(operand);
        return result;
    }

    public NaturePredicate createNaturePredicate() {
        NaturePredicateImpl naturePredicate = new NaturePredicateImpl();
        return naturePredicate;
    }

    public NaturePredicate createNaturePredicate(String nature) {
        NaturePredicate result = this.createNaturePredicate();
        result.setNature(nature);
        return result;
    }

    public BuilderPredicate createBuilderPredicate() {
        BuilderPredicateImpl builderPredicate = new BuilderPredicateImpl();
        return builderPredicate;
    }

    public BuilderPredicate createBuilderPredicate(String builder) {
        BuilderPredicate result = this.createBuilderPredicate();
        result.setBuilder(builder);
        return result;
    }

    public FilePredicate createFilePredicate() {
        FilePredicateImpl filePredicate = new FilePredicateImpl();
        return filePredicate;
    }

    public FilePredicate createFilePredicate(String filePattern) {
        FilePredicate result = this.createFilePredicate();
        result.setFilePattern(filePattern);
        return result;
    }

    public FilePredicate createFilePredicate(String filePattern, String contentPattern) {
        FilePredicate result = this.createFilePredicate(filePattern);
        result.setContentPattern(contentPattern);
        return result;
    }

    public IProject createProjectFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(initialValue);
    }

    public String convertProjectToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        IProject project = (IProject)instanceValue;
        return project.getName();
    }

    public IResource createResourceFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        if (initialValue.endsWith("/")) {
            return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(initialValue));
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(initialValue));
    }

    public String convertResourceToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        IResource resource = (IResource)instanceValue;
        if (resource.getType() == 1) {
            return resource.getFullPath().toString();
        }
        return resource.getFullPath() + "/";
    }

    public File createFileFromString(EDataType eDataType, String initialValue) {
        return new File(initialValue);
    }

    public String convertFileToString(EDataType eDataType, Object instanceValue) {
        return ((File)instanceValue).getAbsolutePath();
    }

    public PredicatesPackage getPredicatesPackage() {
        return (PredicatesPackage)this.getEPackage();
    }

    @Deprecated
    public static PredicatesPackage getPackage() {
        return PredicatesPackage.eINSTANCE;
    }
}

