/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation.handlers;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.setup.ui.wizards.ProgressPage;
import org.eclipse.oomph.ui.ButtonAnimator;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class PerformStatusControl
extends WorkbenchWindowControlContribution {
    private IStatus status;

    protected void resetPerforming() {
        SetupPropertyTester.setPerformingShell(null);
    }

    protected Control createControl(Composite parent) {
        final ToolBar toolBar = new ToolBar(parent, 0x800100);
        final ToolItem toolItem = new ToolItem(toolBar, 32);
        toolItem.setImage(SetupEditorPlugin.INSTANCE.getSWTImage("progress0"));
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = SetupPropertyTester.getPerformingShell();
                if (shell != null) {
                    boolean visible = !shell.isVisible();
                    shell.setVisible(visible);
                    if (PerformStatusControl.this.status != null) {
                        PerformStatusControl.this.resetPerforming();
                    }
                    if (visible) {
                        shell.setFocus();
                    }
                }
            }
        });
        ButtonAnimator buttonAnimator = new ButtonAnimator(SetupEditorPlugin.INSTANCE, toolItem, "progress", 7, true){
            private boolean done;

            public void run() {
                if (!toolItem.isDisposed()) {
                    if (!toolBar.isVisible()) {
                        PerformStatusControl.this.fixPosition();
                    }
                    super.run();
                }
            }

            public Shell getShell() {
                Shell shell = SetupPropertyTester.getPerformingShell();
                if (shell != null && !shell.isDisposed()) {
                    boolean visible = shell.isVisible();
                    if (toolItem.getSelection() != visible) {
                        toolItem.setSelection(visible);
                    }
                    if (PerformStatusControl.this.status == null) {
                        PerformStatusControl.this.status = (IStatus)shell.getData("org.eclipse.oomph.setup.status");
                        if (PerformStatusControl.this.status != null) {
                            String statusImage;
                            switch (PerformStatusControl.this.status.getSeverity()) {
                                case 0: {
                                    statusImage = "progress_success";
                                    this.delayedDispose(shell);
                                    break;
                                }
                                case 2: {
                                    statusImage = "progress_warning";
                                    break;
                                }
                                case 4: {
                                    statusImage = "progress_error";
                                    break;
                                }
                                case 8: {
                                    statusImage = "progress_cancel";
                                    this.delayedDispose(shell);
                                    break;
                                }
                                default: {
                                    statusImage = "progress";
                                }
                            }
                            if (this.images == null) {
                                this.images = new Image[1 + this.additionalImages];
                            }
                            int i = 0;
                            while (i < this.images.length) {
                                this.images[i] = SetupEditorPlugin.INSTANCE.getSWTImage(i >= 4 ? statusImage : "progress");
                                ++i;
                            }
                            this.done = true;
                        }
                    }
                }
                return shell;
            }

            protected int getQuietCycles() {
                if (this.done) {
                    return 2;
                }
                return super.getQuietCycles();
            }

            private void delayedDispose(final Shell shell) {
                UIUtil.timerExec((int)15000, (Runnable)new Runnable(){

                    public void run() {
                        if (!(toolItem.isDisposed() || shell.isDisposed() || shell.isVisible())) {
                            shell.dispose();
                        }
                    }
                });
            }

            protected boolean doAnimate() {
                if (PerformStatusControl.this.status != null) {
                    Shell shell = this.getShell();
                    if (shell.isVisible()) {
                        PerformStatusControl.this.resetPerforming();
                    }
                    return true;
                }
                if (Job.getJobManager().find(ProgressPage.PROGRESS_FAMILY).length == 0) {
                    PerformStatusControl.this.resetPerforming();
                }
                return true;
            }
        };
        buttonAnimator.run();
        return toolBar;
    }

    private void fixPosition() {
        IWorkbenchWindow workbenchWindow = this.getWorkbenchWindow();
        try {
            Object model = ReflectUtil.getValue((String)"model", (Object)workbenchWindow);
            Object modelService = ReflectUtil.getValue((String)"modelService", (Object)workbenchWindow);
            Class elementClass = CommonPlugin.loadClass((String)"org.eclipse.ui.workbench", (String)"org.eclipse.e4.ui.model.application.ui.MUIElement");
            Method findMethod = ReflectUtil.getMethod(modelService.getClass(), (String)"find", (Class[])new Class[]{String.class, elementClass});
            EObject progressBar = (EObject)ReflectUtil.invokeMethod((Method)findMethod, (Object)modelService, (Object[])new Object[]{"org.eclipse.ui.ProgressBar", model});
            EObject performStatusBar = (EObject)ReflectUtil.invokeMethod((Method)findMethod, (Object)modelService, (Object[])new Object[]{"org.eclipse.oomph.setup.status", model});
            EList children = (EList)progressBar.eContainer().eGet((EStructuralFeature)progressBar.eContainmentFeature());
            children.remove((Object)performStatusBar);
            children.add(children.indexOf((Object)progressBar), (Object)performStatusBar);
            workbenchWindow.getShell().layout(true, true);
        }
        catch (Throwable throwable) {}
    }
}

