/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.projectconfig.PreferenceFilter;
import org.eclipse.oomph.projectconfig.PreferenceProfile;
import org.eclipse.oomph.projectconfig.Project;
import org.eclipse.oomph.projectconfig.ProjectConfigFactory;
import org.eclipse.oomph.projectconfig.WorkspaceConfiguration;
import org.eclipse.oomph.projectconfig.impl.ProjectConfigPlugin;
import org.eclipse.oomph.projectconfig.util.ProjectConfigValidator;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectConfigUtil {
    private static final Pattern JDT_CORE_BREE_PATTERN = Pattern.compile("org\\.eclipse\\.jdt\\.core\\.compiler\\.codegen\\.targetPlatform|org.eclipse\\.jdt\\.core\\.compiler\\.compliance|org\\.eclipse\\.jdt\\.core\\.compiler\\.source");
    private static final Pattern RESOURCE_ENCODING_PROJECT_PATTERN = Pattern.compile("<project>");
    private static final IWorkspaceRoot WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot();
    public static final String PROJECT_CONF_NODE_NAME = "org.eclipse.oomph.projectconfig";
    public static final String PROJECT_CONF_PROJECT_KEY = "project";
    public static final String PROJECT_CONFIG_SCHEME = "configuration";
    public static final URI PROJECT_CONFIG_URI = URI.createURI((String)"configuration:/");

    public static WorkspaceConfiguration getWorkspaceConfiguration() {
        return ProjectConfigUtil.getWorkspaceConfiguration(null);
    }

    public static EList<PreferenceProfile> getDefaultPreferenceProfiles(IProject project, PreferenceNode projectPreferenceNode) {
        BasicEList result = new BasicEList();
        PreferenceNode encodingPreferenceNode = projectPreferenceNode.getNode(URI.createURI((String)"org.eclipse.core.resources/encoding"));
        if (encodingPreferenceNode != null) {
            PreferenceProfile encodingPreferenceProfile = ProjectConfigFactory.eINSTANCE.createPreferenceProfile();
            encodingPreferenceProfile.setName("Core Resources Encoding for Local Resources");
            PreferenceFilter encodingPreferenceFilter = ProjectConfigFactory.eINSTANCE.createPreferenceFilter();
            encodingPreferenceFilter.setExclusions(RESOURCE_ENCODING_PROJECT_PATTERN);
            encodingPreferenceFilter.setPreferenceNode(encodingPreferenceNode);
            encodingPreferenceProfile.getPreferenceFilters().add((Object)encodingPreferenceFilter);
            result.add((Object)encodingPreferenceProfile);
        }
        try {
            PreferenceNode jdtCorePreferenceNode;
            if (project.hasNature("org.eclipse.jdt.core.javanature") && (jdtCorePreferenceNode = projectPreferenceNode.getNode("org.eclipse.jdt.core")) != null) {
                PreferenceProfile jdtCompilerCompliancePreferenceProfile = ProjectConfigFactory.eINSTANCE.createPreferenceProfile();
                jdtCompilerCompliancePreferenceProfile.setName("JDT Core Managed by Build Path");
                PreferenceFilter jdtCompilerCompliancePreferenceFilter = ProjectConfigFactory.eINSTANCE.createPreferenceFilter();
                jdtCompilerCompliancePreferenceFilter.setInclusions(JDT_CORE_BREE_PATTERN);
                jdtCompilerCompliancePreferenceFilter.setPreferenceNode(jdtCorePreferenceNode);
                jdtCompilerCompliancePreferenceProfile.getPreferenceFilters().add((Object)jdtCompilerCompliancePreferenceFilter);
                result.add((Object)jdtCompilerCompliancePreferenceProfile);
            }
        }
        catch (CoreException coreException) {}
        return result;
    }

    public static WorkspaceConfiguration getWorkspaceConfiguration(PreferenceNode cachedProjectsPreferenceNode) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)"*.projectconfig"));
        resource.setURI(PROJECT_CONFIG_URI);
        PreferenceNode rootPreferenceNode = PreferencesUtil.getRootPreferenceNode();
        WorkspaceConfiguration workspaceConfiguration = ProjectConfigFactory.eINSTANCE.createWorkspaceConfiguration();
        PreferenceNode instancePreferenceNode = rootPreferenceNode.getNode("instance");
        workspaceConfiguration.setInstancePreferenceNode(instancePreferenceNode);
        workspaceConfiguration.setDefaultPreferenceNode(rootPreferenceNode.getNode("default"));
        PreferenceNode projectsPreferenceNode = rootPreferenceNode.getNode(PROJECT_CONF_PROJECT_KEY);
        EList<Project> projects = workspaceConfiguration.getProjects();
        IProject[] iProjectArray = WORKSPACE_ROOT.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (iProject.isAccessible()) {
                PreferenceNode cachedProjectPreferenceNode;
                String name = iProject.getName();
                PreferenceNode projectPreferenceNode = projectsPreferenceNode.getNode(name);
                PreferenceNode preferenceNode = cachedProjectPreferenceNode = cachedProjectsPreferenceNode == null ? null : cachedProjectsPreferenceNode.getNode(name);
                if (projectPreferenceNode != null && (cachedProjectsPreferenceNode == null || cachedProjectPreferenceNode != null)) {
                    Project project = ProjectConfigFactory.eINSTANCE.createProject();
                    PreferenceNode projectConfNode = (cachedProjectPreferenceNode == null ? projectPreferenceNode : cachedProjectPreferenceNode).getNode(PROJECT_CONF_NODE_NAME);
                    if (projectConfNode == null) {
                        project.getPreferenceProfiles().addAll(ProjectConfigUtil.getDefaultPreferenceProfiles(iProject, projectPreferenceNode));
                    } else {
                        String value;
                        Property projectProperty = projectConfNode.getProperty(PROJECT_CONF_PROJECT_KEY);
                        if (projectProperty != null && (value = projectProperty.getValue()) != null) {
                            XMLResourceImpl projectResource = new XMLResourceImpl(PROJECT_CONFIG_URI);
                            URIConverter.ReadableInputStream in = new URIConverter.ReadableInputStream(value);
                            try {
                                projectResource.load((InputStream)in, null);
                            }
                            catch (IOException iOException) {}
                            EList contents = projectResource.getContents();
                            if (!contents.isEmpty()) {
                                project = (Project)contents.get(0);
                            }
                        }
                    }
                    project.setPreferenceNode(projectPreferenceNode);
                    projects.add((Object)project);
                }
            }
            ++n2;
        }
        EList contents = resource.getContents();
        contents.add((Object)workspaceConfiguration);
        contents.add((Object)rootPreferenceNode);
        for (Project project : projects) {
            for (PreferenceProfile preferenceProfile : project.getPreferenceProfiles()) {
                for (PreferenceFilter preferenceFilter : preferenceProfile.getPreferenceFilters()) {
                    preferenceFilter.getPreferenceNode();
                }
            }
            EList<PreferenceProfile> profileReferences = project.getPreferenceProfileReferences();
            ArrayList<PreferenceProfile> copy = new ArrayList<PreferenceProfile>((Collection<PreferenceProfile>)profileReferences);
            profileReferences.clear();
            profileReferences.addAll(copy);
        }
        workspaceConfiguration.updatePreferenceProfileReferences();
        return workspaceConfiguration;
    }

    public static final void saveWorkspaceConfiguration(WorkspaceConfiguration workspaceConfiguration) throws BackingStoreException {
        ProjectConfigUtil.saveWorkspaceConfiguration(workspaceConfiguration, false);
    }

    public static final PreferenceNode cacheWorkspaceConfiguration(WorkspaceConfiguration workspaceConfiguration) {
        try {
            return ProjectConfigUtil.saveWorkspaceConfiguration(workspaceConfiguration, true);
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }

    private static final PreferenceNode saveWorkspaceConfiguration(WorkspaceConfiguration workspaceConfiguration, boolean cache) throws BackingStoreException {
        PreferenceNode projectsPreferenceNode = null;
        for (Project project : workspaceConfiguration.getProjects()) {
            PreferenceNode projectPreferenceNode = project.getPreferenceNode();
            Preferences projectPreferences = cache ? null : PreferencesUtil.getPreferences((PreferenceNode)projectPreferenceNode, (boolean)true);
            EList<PreferenceProfile> preferenceProfiles = project.getPreferenceProfiles();
            EList<PreferenceProfile> preferenceProfileReferences = project.getPreferenceProfileReferences();
            String projectPropertyValue = null;
            if (!preferenceProfileReferences.isEmpty() || !preferenceProfiles.isEmpty()) {
                boolean hasOnlyDefaultPreferenceProfiles = false;
                if (!preferenceProfiles.isEmpty()) {
                    IProject iProject = WORKSPACE_ROOT.getProject(projectPreferenceNode.getName());
                    EList<PreferenceProfile> defaultPreferenceProfiles = ProjectConfigUtil.getDefaultPreferenceProfiles(iProject, projectPreferenceNode);
                    ArrayList copiedPreferenceProfiles = new ArrayList(EcoreUtil.copyAll(preferenceProfiles));
                    hasOnlyDefaultPreferenceProfiles = EcoreUtil.equals(copiedPreferenceProfiles, defaultPreferenceProfiles);
                }
                if (!hasOnlyDefaultPreferenceProfiles) {
                    Project copy = (Project)EcoreUtil.copy((EObject)project);
                    copy.setPreferenceNode(null);
                    EList<PreferenceProfile> copyPreferenceProfileReferences = copy.getPreferenceProfileReferences();
                    copyPreferenceProfileReferences.clear();
                    for (PreferenceProfile preferenceProfileReference : preferenceProfileReferences) {
                        if (!preferenceProfileReference.getPredicates().isEmpty()) continue;
                        PreferenceProfile proxy = ProjectConfigFactory.eINSTANCE.createPreferenceProfile();
                        ((InternalEObject)proxy).eSetProxyURI(URI.createURI((String)(".#" + preferenceProfileReference.eResource().getURIFragment((EObject)preferenceProfileReference))));
                        copyPreferenceProfileReferences.add((Object)proxy);
                    }
                    TreeIterator it = EcoreUtil.getAllContents(copy.getPreferenceProfiles());
                    while (it.hasNext()) {
                        EObject eObject = (EObject)it.next();
                        ProjectConfigUtil.proxifyCrossReferences(eObject);
                    }
                    if (!copy.getPreferenceProfiles().isEmpty() || !copy.getPreferenceProfileReferences().isEmpty()) {
                        XMLResourceImpl resource = new XMLResourceImpl(workspaceConfiguration.eResource().getURI());
                        resource.getContents().add((Object)copy);
                        HashMap<String, Object> options = new HashMap<String, Object>();
                        options.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                        options.put("LINE_WIDTH", 10);
                        options.put("ENCODING", "UTF-8");
                        try {
                            StringWriter writer = new StringWriter();
                            URIConverter.WriteableOutputStream out = new URIConverter.WriteableOutputStream((Writer)writer, "UTF-8");
                            resource.save((OutputStream)out, options);
                            projectPropertyValue = writer.toString();
                        }
                        catch (IOException ex) {
                            ProjectConfigPlugin.INSTANCE.log(ex);
                        }
                    }
                }
            }
            if (projectPropertyValue == null) {
                if (cache) {
                    projectsPreferenceNode = projectPreferenceNode.getParent();
                    PreferenceNode projectConfPreferenceNode = projectPreferenceNode.getNode(PROJECT_CONF_NODE_NAME);
                    if (projectConfPreferenceNode == null) continue;
                    projectConfPreferenceNode.getChildren().remove((Object)projectConfPreferenceNode);
                    continue;
                }
                if (!projectPreferences.nodeExists(PROJECT_CONF_NODE_NAME)) continue;
                Preferences projectConfPreferenceNode = projectPreferences.node(PROJECT_CONF_NODE_NAME);
                projectConfPreferenceNode.remove(PROJECT_CONF_PROJECT_KEY);
                projectConfPreferenceNode.flush();
                projectConfPreferenceNode.removeNode();
                projectPreferences.flush();
                continue;
            }
            if (cache) {
                Property projectConfProperty;
                projectsPreferenceNode = projectPreferenceNode.getParent();
                PreferenceNode projectConfPreferenceNode = projectPreferenceNode.getNode(PROJECT_CONF_NODE_NAME);
                if (projectConfPreferenceNode == null) {
                    projectConfPreferenceNode = PreferencesFactory.eINSTANCE.createPreferenceNode();
                    projectConfPreferenceNode.setName(PROJECT_CONF_NODE_NAME);
                    projectPreferenceNode.getChildren().add((Object)projectConfPreferenceNode);
                }
                if ((projectConfProperty = projectConfPreferenceNode.getProperty(PROJECT_CONF_PROJECT_KEY)) == null) {
                    projectConfProperty = PreferencesFactory.eINSTANCE.createProperty();
                    projectConfProperty.setName(PROJECT_CONF_PROJECT_KEY);
                    projectConfPreferenceNode.getProperties().add((Object)projectConfProperty);
                }
                projectConfProperty.setValue(projectPropertyValue);
                continue;
            }
            Preferences projectConfPreferences = projectPreferences.node(PROJECT_CONF_NODE_NAME);
            projectConfPreferences.put(PROJECT_CONF_PROJECT_KEY, projectPropertyValue);
            projectConfPreferences.flush();
        }
        return projectsPreferenceNode;
    }

    private static void proxifyCrossReferences(EObject eObject) {
        for (EReference eReference : eObject.eClass().getEAllReferences()) {
            if (eReference.isTransient() || eReference.isContainer() || eReference.isContainment()) continue;
            if (eReference.isMany()) {
                EList eObjects = (EList)eObject.eGet((EStructuralFeature)eReference);
                ArrayList eObjectsCopy = new ArrayList(eObjects);
                eObjects.clear();
                for (EObject referencedEObject : eObjectsCopy) {
                    Resource eResource = referencedEObject.eResource();
                    if (eResource == null) {
                        eObjects.add((Object)referencedEObject);
                        continue;
                    }
                    EObject proxy = EcoreUtil.create((EClass)referencedEObject.eClass());
                    ((InternalEObject)proxy).eSetProxyURI(URI.createURI((String)(".#" + eResource.getURIFragment(referencedEObject))));
                    eObjects.add((Object)proxy);
                }
                continue;
            }
            EObject referencedEObject = (EObject)eObject.eGet((EStructuralFeature)eReference);
            Resource eResource = referencedEObject.eResource();
            if (eResource == null) continue;
            EObject proxy = EcoreUtil.create((EClass)referencedEObject.eClass());
            ((InternalEObject)proxy).eSetProxyURI(URI.createURI((String)(".#" + eResource.getURIFragment(referencedEObject))));
            eObject.eSet((EStructuralFeature)eReference, (Object)proxy);
        }
    }

    public static IProject getProject(Project project) {
        String name;
        PreferenceNode preferenceNode = project.getPreferenceNode();
        if (preferenceNode != null && (name = preferenceNode.getName()) != null) {
            return WORKSPACE_ROOT.getProject(name);
        }
        return null;
    }

    public static Map<PreferenceNode, Set<Property>> getUnmanagedPreferenceNodes(Project project) {
        return ProjectConfigValidator.collectUnmanagedPreferences(project);
    }

    public static Map<PreferenceNode, Map<Property, Property>> getInconsistentPreferenceNodes(Project project) {
        return ProjectConfigValidator.collectInconsistentPreferences(project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CompletenessChecker {
        public CompletenessChecker() {
            this(ProjectConfigUtil.getWorkspaceConfiguration());
        }

        public CompletenessChecker(WorkspaceConfiguration workspaceConfiguration) {
            final HashSet<String> projectNames = new HashSet<String>();
            IProject[] iProjectArray = WORKSPACE_ROOT.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray[n2];
                if (iProject.isAccessible()) {
                    projectNames.add(iProject.getName());
                }
                ++n2;
            }
            if (this.getProjectNames(workspaceConfiguration.getInstancePreferenceNode().getParent().getNode(ProjectConfigUtil.PROJECT_CONF_PROJECT_KEY)).containsAll(projectNames)) {
                this.complete(workspaceConfiguration);
            } else {
                final PreferenceNode projectPreferenceNode = PreferencesUtil.getRootPreferenceNode((boolean)true).getNode(ProjectConfigUtil.PROJECT_CONF_PROJECT_KEY);
                AdapterImpl projectNodeListener = new AdapterImpl(){

                    public synchronized void notifyChanged(Notification msg) {
                        Set projectPreferenceNodeNames = CompletenessChecker.this.getProjectNames(projectPreferenceNode);
                        if (projectPreferenceNodeNames.containsAll(projectNames) && projectPreferenceNode.eAdapters().remove((Object)this)) {
                            projectPreferenceNode.eResource().unload();
                            CompletenessChecker.this.complete();
                        }
                    }
                };
                projectPreferenceNode.eAdapters().add((Object)projectNodeListener);
            }
        }

        private Set<String> getProjectNames(PreferenceNode projectPreferenceNode) {
            HashSet<String> projectPreferenceNodeNames = new HashSet<String>();
            for (PreferenceNode preferenceNode : projectPreferenceNode.getChildren()) {
                projectPreferenceNodeNames.add(preferenceNode.getName());
            }
            return projectPreferenceNodeNames;
        }

        protected void complete() {
            this.complete(ProjectConfigUtil.getWorkspaceConfiguration());
        }

        protected void complete(WorkspaceConfiguration workspaceConfiguration) {
        }
    }
}

