/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.oomph.internal.ui.DelegatingPreferenceStore;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.util.OfflineMode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RemoteResourcesPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String OFFLINE = "offline";

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return new DelegatingPreferenceStore(UIPlugin.INSTANCE.getPreferenceStore()){

            public void setToDefault(String name) {
                if (RemoteResourcesPreferencePage.OFFLINE.equals(name)) {
                    OfflineMode.setEnabled((boolean)false);
                } else {
                    super.setToDefault(name);
                }
            }

            public void setValue(String name, boolean value) {
                if (RemoteResourcesPreferencePage.OFFLINE.equals(name)) {
                    OfflineMode.setEnabled((boolean)value);
                } else {
                    super.setValue(name, value);
                }
            }

            public boolean getBoolean(String name) {
                if (RemoteResourcesPreferencePage.OFFLINE.equals(name)) {
                    return OfflineMode.isEnabled();
                }
                return super.getBoolean(name);
            }

            public boolean getDefaultBoolean(String name) {
                if (RemoteResourcesPreferencePage.OFFLINE.equals(name)) {
                    return false;
                }
                return super.getDefaultBoolean(name);
            }
        };
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        BooleanFieldEditor offline = new BooleanFieldEditor(OFFLINE, "Use offline cache", parent);
        offline.fillIntoGrid(parent, 2);
        this.addField((FieldEditor)offline);
        offline.getDescriptionControl(parent).setToolTipText("Use locally cached versions of remote resources whenever possible");
        BooleanFieldEditor showOffline = new BooleanFieldEditor("showOffline", "Show offline tool bar", parent);
        showOffline.fillIntoGrid(parent, 2);
        this.addField((FieldEditor)showOffline);
        showOffline.getDescriptionControl(parent).setToolTipText("Show the offline toolbar contribution in the main toolbar");
        Runnable runnable = null;
        try {
            Class refreshCacheHandlerClass = CommonPlugin.loadClass((String)"org.eclipse.oomph.setup.editor", (String)"org.eclipse.oomph.setup.presentation.handlers.RefreshCacheHandler");
            runnable = (Runnable)refreshCacheHandlerClass.newInstance();
        }
        catch (Exception exception) {}
        if (runnable != null) {
            final Runnable finalRunnable = runnable;
            Button refreshCache = new Button(parent, 8);
            refreshCache.setText("Refresh Remote Cache...");
            refreshCache.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    finalRunnable.run();
                }
            });
        }
    }
}

