/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import org.eclipse.oomph.ui.SecondaryToolItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolButton
extends ToolBar {
    private final ToolItem toolItem;

    public ToolButton(Composite parent, int style, Image image, boolean secondary) {
        super(parent, 0x800000);
        if (secondary) {
            this.toolItem = new SecondaryToolItem(this, style, image);
        } else {
            this.toolItem = new ToolItem((ToolBar)this, style);
            this.toolItem.setImage(image);
        }
    }

    public final ToolItem getToolItem() {
        return this.toolItem;
    }

    public void setImage(Image image) {
        if (this.toolItem instanceof SecondaryToolItem) {
            SecondaryToolItem secondaryToolItem = (SecondaryToolItem)this.toolItem;
            secondaryToolItem.init(image);
        } else {
            this.toolItem.setImage(image);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.toolItem.addSelectionListener(listener);
    }

    public boolean getSelection() {
        return this.toolItem.getSelection();
    }

    public String getToolTipText() {
        return this.toolItem.getToolTipText();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.toolItem.removeSelectionListener(listener);
    }

    public void setSelection(boolean selected) {
        this.toolItem.setSelection(selected);
    }

    public void setToolTipText(String string) {
        this.toolItem.setToolTipText(string);
    }

    protected void checkSubclass() {
    }
}

